/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.nestedstructure.authorizer;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.authorization.nestedstructure.authorizer.MaskingException;

public class DataMasker {
    static final Number DEFAULT_NUMBER_MASK = new Long(-11111L);
    static final Boolean DEFAULT_BOOLEAN_MASK = false;
    static final List<DateTimeFormatter> SUPPORTED_DATE_FORMATS = Arrays.asList(DateTimeFormatter.BASIC_ISO_DATE, DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.ISO_OFFSET_DATE, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_ZONED_DATE_TIME, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_ORDINAL_DATE, DateTimeFormatter.ISO_WEEK_DATE, DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.RFC_1123_DATE_TIME);

    public static Boolean maskBoolean(Boolean value, String maskType, String customMaskValueStr) {
        Boolean ret;
        if (maskType == null) {
            throw new MaskingException("boolean doesn't support mask type: " + maskType);
        }
        switch (maskType) {
            case "MASK": {
                ret = DEFAULT_BOOLEAN_MASK;
                break;
            }
            case "MASK_NULL": {
                ret = null;
                break;
            }
            case "MASK_NONE": {
                ret = value;
                break;
            }
            case "CUSTOM": {
                Boolean customMaskValue = DEFAULT_BOOLEAN_MASK;
                try {
                    customMaskValue = Boolean.parseBoolean(customMaskValueStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ret = customMaskValue;
                break;
            }
            default: {
                throw new MaskingException("boolean doesn't support mask type: " + maskType);
            }
        }
        return ret;
    }

    public static Number maskNumber(Number value, String maskType, String customMaskValueStr) {
        Number ret;
        if (maskType == null) {
            throw new MaskingException("number doesn't support mask type: " + maskType);
        }
        switch (maskType) {
            case "MASK": {
                ret = DEFAULT_NUMBER_MASK;
                break;
            }
            case "MASK_NULL": {
                ret = null;
                break;
            }
            case "MASK_NONE": {
                ret = value;
                break;
            }
            case "CUSTOM": {
                try {
                    ret = Long.parseLong(customMaskValueStr);
                    break;
                }
                catch (Exception e) {
                    throw new MaskingException("unable to extract number from custom mask value: " + customMaskValueStr, e);
                }
            }
            default: {
                throw new MaskingException("number doesn't support mask type: " + maskType);
            }
        }
        return ret;
    }

    public static String maskString(String value, String maskType, String customMaskValue) {
        String ret;
        if (maskType == null) {
            throw new MaskingException("string doesn't support mask type: " + maskType);
        }
        switch (maskType) {
            case "MASK": {
                ret = DataMasker.generateMask(value);
                break;
            }
            case "MASK_SHOW_LAST_4": {
                ret = DataMasker.showLastFour(value);
                break;
            }
            case "MASK_SHOW_FIRST_4": {
                ret = DataMasker.showFirstFour(value);
                break;
            }
            case "MASK_HASH": {
                ret = DigestUtils.sha256Hex((String)(value == null ? "null" : value));
                break;
            }
            case "MASK_NULL": {
                ret = null;
                break;
            }
            case "MASK_NONE": {
                ret = value;
                break;
            }
            case "MASK_DATE_SHOW_YEAR": {
                ret = DataMasker.maskYear(value);
                break;
            }
            case "CUSTOM": {
                ret = customMaskValue;
                break;
            }
            default: {
                throw new MaskingException("string doesn't support mask type: " + maskType);
            }
        }
        return ret;
    }

    private static String generateMask(String value) {
        int maskedValueLen = StringUtils.length((CharSequence)value);
        if (maskedValueLen < 5) {
            maskedValueLen = 5;
        } else if (maskedValueLen > 30) {
            maskedValueLen = 30;
        }
        return StringUtils.repeat((String)"*", (int)maskedValueLen);
    }

    private static String showLastFour(String value) {
        int length = StringUtils.length((CharSequence)value);
        return length <= 4 ? value : StringUtils.repeat((String)"x", (int)(length - 4)) + value.substring(length - 4);
    }

    private static String showFirstFour(String value) {
        int length = StringUtils.length((CharSequence)value);
        return length <= 4 ? value : value.substring(0, 4) + StringUtils.repeat((String)"x", (int)(length - 4));
    }

    private static String maskYear(String value) {
        String ret = null;
        if (StringUtils.isEmpty((CharSequence)value)) {
            ret = value;
        } else {
            for (DateTimeFormatter dateFormat : SUPPORTED_DATE_FORMATS) {
                try {
                    TemporalAccessor temporalAccessor = dateFormat.parse(value);
                    LocalDate localDateTime = LocalDate.from(temporalAccessor);
                    ret = localDateTime.format(DateTimeFormatter.ofPattern("yyyy"));
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (ret == null) {
                throw new MaskingException("Unable to mask year, unsupported date format: " + value + ". See documentation for supported date formats.");
            }
        }
        return ret;
    }
}

