/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.yarn.authorizer;

import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.ranger.authorization.yarn.authorizer.RangerYarnResource;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;

class RangerYarnAccessRequest
extends RangerAccessRequestImpl {
    public RangerYarnAccessRequest(PrivilegedEntity entity, String accessType, String action, UserGroupInformation ugi, List<String> forwardedAddresses, String remoteIpAddress) {
        super.setResource((RangerAccessResource)new RangerYarnResource(entity));
        super.setAccessType(accessType);
        super.setUser(ugi.getShortUserName());
        super.setUserGroups((Set)Sets.newHashSet((Object[])ugi.getGroupNames()));
        super.setAccessTime(new Date());
        String clientIPAddress = remoteIpAddress;
        if (StringUtils.isEmpty((CharSequence)clientIPAddress)) {
            clientIPAddress = RangerYarnAccessRequest.getRemoteIp();
        }
        super.setClientIPAddress(clientIPAddress);
        super.setAction(action);
        super.setRemoteIPAddress(remoteIpAddress);
        super.setForwardedAddresses(forwardedAddresses);
    }

    private static String getRemoteIp() {
        String ret = null;
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            ret = ip.getHostAddress();
        }
        return ret;
    }
}

