/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlas;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;

public class AtlasStormResourceMapper
extends AtlasResourceMapper {
    public static final String ENTITY_TYPE_STORM_TOPOLOGY = "storm_topology";
    public static final String RANGER_TYPE_STORM_TOPOLOGY = "topology";
    public static final String[] SUPPORTED_ENTITY_TYPES = new String[]{"storm_topology"};

    public AtlasStormResourceMapper() {
        super("storm", SUPPORTED_ENTITY_TYPES);
    }

    @Override
    public RangerServiceResource buildResource(RangerAtlasEntity entity) throws Exception {
        String clusterName;
        String qualifiedName = (String)entity.getAttributes().get("qualifiedName");
        String topology = this.getResourceNameFromQualifiedName(qualifiedName);
        if (StringUtils.isEmpty((CharSequence)topology)) {
            this.throwExceptionWithMessage("topology not found in attribute 'qualifiedName'");
        }
        if (StringUtils.isEmpty((CharSequence)(clusterName = this.getClusterNameFromQualifiedName(qualifiedName)))) {
            clusterName = this.defaultClusterName;
        }
        if (StringUtils.isEmpty((CharSequence)clusterName)) {
            this.throwExceptionWithMessage("attribute 'qualifiedName' not found in entity");
        }
        HashMap<String, RangerPolicy.RangerPolicyResource> elements = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        Boolean isExcludes = Boolean.FALSE;
        Boolean isRecursive = Boolean.TRUE;
        elements.put(RANGER_TYPE_STORM_TOPOLOGY, new RangerPolicy.RangerPolicyResource(topology, isExcludes, isRecursive));
        String entityGuid = entity.getGuid();
        String serviceName = this.getRangerServiceName(clusterName);
        return new RangerServiceResource(entityGuid, serviceName, elements);
    }
}

