/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.grpc.metrics.MessageMetrics;
import org.apache.ratis.grpc.metrics.intercept.server.MetricServerInterceptor;
import org.apache.ratis.grpc.server.GrpcAdminProtocolService;
import org.apache.ratis.grpc.server.GrpcClientProtocolService;
import org.apache.ratis.grpc.server.GrpcServerProtocolClient;
import org.apache.ratis.grpc.server.GrpcServerProtocolService;
import org.apache.ratis.grpc.server.GrpcServices;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.AdminAsynchronousProtocol;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerRpcWithProxy;
import org.apache.ratis.server.protocol.RaftServerAsynchronousProtocol;
import org.apache.ratis.thirdparty.io.grpc.BindableService;
import org.apache.ratis.thirdparty.io.grpc.Server;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptor;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptors;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyServerBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelOption;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.ClientAuth;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslProvider;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.ConcurrentUtils;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.PeerProxyMap;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcServicesImpl
extends RaftServerRpcWithProxy<GrpcServerProtocolClient, PeerProxyMap<GrpcServerProtocolClient>>
implements GrpcServices {
    static final Logger LOG = LoggerFactory.getLogger(GrpcServicesImpl.class);
    public static final String GRPC_SEND_SERVER_REQUEST = JavaUtils.getClassSimpleName(GrpcServicesImpl.class) + ".sendRequest";
    private final Map<String, Server> servers = new HashMap<String, Server>();
    private final Supplier<InetSocketAddress> addressSupplier;
    private final Supplier<InetSocketAddress> clientServerAddressSupplier;
    private final Supplier<InetSocketAddress> adminServerAddressSupplier;
    private final AsyncService asyncService = new AsyncService();
    private final ExecutorService executor;
    private final GrpcClientProtocolService clientProtocolService;
    private final MetricServerInterceptor serverInterceptor;

    public static Builder newBuilder() {
        return new Builder();
    }

    private GrpcServicesImpl(Builder b) {
        super(b.server::getId, (RaftPeerId id) -> new PeerProxyMap<GrpcServerProtocolClient>(id.toString(), x$0 -> b.newGrpcServerProtocolClient(x$0)));
        NettyServerBuilder builder;
        this.executor = b.newExecutor();
        this.clientProtocolService = b.newGrpcClientProtocolService(this.executor);
        this.serverInterceptor = b.newMetricServerInterceptor();
        Server server = b.newServer(this.clientProtocolService, this.serverInterceptor);
        this.servers.put(GrpcServerProtocolService.class.getSimpleName(), server);
        this.addressSupplier = GrpcServicesImpl.newAddressSupplier(b.serverPort, server);
        if (b.separateAdminServer()) {
            builder = b.newNettyServerBuilderForAdmin();
            GrpcServicesImpl.addAdminService(builder, b.server, this.serverInterceptor);
            Server adminServer = b.buildServer(builder, EnumSet.of(GrpcServices.Type.ADMIN));
            this.servers.put(GrpcAdminProtocolService.class.getName(), adminServer);
            this.adminServerAddressSupplier = GrpcServicesImpl.newAddressSupplier(b.adminPort, adminServer);
        } else {
            this.adminServerAddressSupplier = this.addressSupplier;
        }
        if (b.separateClientServer()) {
            builder = b.newNettyServerBuilderForClient();
            GrpcServicesImpl.addClientService(builder, this.clientProtocolService, this.serverInterceptor);
            Server clientServer = b.buildServer(builder, EnumSet.of(GrpcServices.Type.CLIENT));
            this.servers.put(GrpcClientProtocolService.class.getName(), clientServer);
            this.clientServerAddressSupplier = GrpcServicesImpl.newAddressSupplier(b.clientPort, clientServer);
        } else {
            this.clientServerAddressSupplier = this.addressSupplier;
        }
    }

    static MemoizedSupplier<InetSocketAddress> newAddressSupplier(int port, Server server) {
        return JavaUtils.memoize(() -> new InetSocketAddress(port != 0 ? port : server.getPort()));
    }

    static void addClientService(NettyServerBuilder builder, GrpcClientProtocolService client, ServerInterceptor interceptor) {
        builder.addService(ServerInterceptors.intercept((BindableService)client, interceptor));
    }

    static void addAdminService(NettyServerBuilder builder, AdminAsynchronousProtocol admin, ServerInterceptor interceptor) {
        GrpcAdminProtocolService service = new GrpcAdminProtocolService(admin);
        builder.addService(ServerInterceptors.intercept((BindableService)service, interceptor));
    }

    @Override
    public SupportedRpcType getRpcType() {
        return SupportedRpcType.GRPC;
    }

    @Override
    public void startImpl() {
        for (Server server : this.servers.values()) {
            try {
                server.start();
            }
            catch (IOException e) {
                ExitUtils.terminate(1, "Failed to start Grpc server", e, LOG);
            }
            LOG.info("{}: {} started, listening on {}", this.getId(), JavaUtils.getClassSimpleName(this.getClass()), server.getPort());
        }
    }

    @Override
    public void closeImpl() throws IOException {
        for (Map.Entry<String, Server> server : this.servers.entrySet()) {
            String name = this.getId() + ": shutdown server " + server.getKey();
            LOG.info("{} now", (Object)name);
            Server s2 = server.getValue().shutdownNow();
            super.closeImpl();
            try {
                s2.awaitTermination();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw IOUtils.toInterruptedIOException(name + " failed", e);
            }
            LOG.info("{} successfully", (Object)name);
        }
        this.serverInterceptor.close();
        ConcurrentUtils.shutdownAndWait(this.executor);
    }

    @Override
    public void notifyNotLeader(RaftGroupId groupId) {
        this.clientProtocolService.closeAllOrderedRequestStreamObservers(groupId);
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.addressSupplier.get();
    }

    @Override
    public InetSocketAddress getClientServerAddress() {
        return this.clientServerAddressSupplier.get();
    }

    @Override
    public InetSocketAddress getAdminServerAddress() {
        return this.adminServerAddressSupplier.get();
    }

    @Override
    public RaftServerAsynchronousProtocol async() {
        return this.asyncService;
    }

    @Override
    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) {
        throw new UnsupportedOperationException("Blocking " + JavaUtils.getCurrentStackTraceElement().getMethodName() + " call is not supported");
    }

    @Override
    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) {
        throw new UnsupportedOperationException("Blocking " + JavaUtils.getCurrentStackTraceElement().getMethodName() + " call is not supported");
    }

    @Override
    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        CodeInjectionForTesting.execute(GRPC_SEND_SERVER_REQUEST, this.getId(), null, request);
        RaftPeerId target = RaftPeerId.valueOf(request.getServerRequest().getReplyId());
        return ((GrpcServerProtocolClient)((PeerProxyMap)this.getProxies()).getProxy(target)).requestVote(request);
    }

    @Override
    public RaftProtos.StartLeaderElectionReplyProto startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request) throws IOException {
        CodeInjectionForTesting.execute(GRPC_SEND_SERVER_REQUEST, this.getId(), null, request);
        RaftPeerId target = RaftPeerId.valueOf(request.getServerRequest().getReplyId());
        return ((GrpcServerProtocolClient)((PeerProxyMap)this.getProxies()).getProxy(target)).startLeaderElection(request);
    }

    MessageMetrics getMessageMetrics() {
        return this.serverInterceptor.getMetrics();
    }

    public static final class Builder {
        private RaftServer server;
        private GrpcServices.Customizer customizer;
        private String adminHost;
        private int adminPort;
        private GrpcTlsConfig adminTlsConfig;
        private String clientHost;
        private int clientPort;
        private GrpcTlsConfig clientTlsConfig;
        private String serverHost;
        private int serverPort;
        private GrpcTlsConfig serverTlsConfig;
        private SizeInBytes messageSizeMax;
        private SizeInBytes flowControlWindow;
        private TimeDuration requestTimeoutDuration;
        private boolean separateHeartbeatChannel;

        private Builder() {
        }

        public Builder setServer(RaftServer raftServer) {
            this.server = raftServer;
            RaftProperties properties = this.server.getProperties();
            this.adminHost = GrpcConfigKeys.Admin.host(properties);
            this.adminPort = GrpcConfigKeys.Admin.port(properties);
            this.clientHost = GrpcConfigKeys.Client.host(properties);
            this.clientPort = GrpcConfigKeys.Client.port(properties);
            this.serverHost = GrpcConfigKeys.Server.host(properties);
            this.serverPort = GrpcConfigKeys.Server.port(properties);
            this.messageSizeMax = GrpcConfigKeys.messageSizeMax(properties, LOG::info);
            this.flowControlWindow = GrpcConfigKeys.flowControlWindow(properties, LOG::info);
            this.requestTimeoutDuration = RaftServerConfigKeys.Rpc.requestTimeout(properties);
            this.separateHeartbeatChannel = GrpcConfigKeys.Server.heartbeatChannel(properties);
            SizeInBytes appenderBufferSize = RaftServerConfigKeys.Log.Appender.bufferByteLimit(properties);
            SizeInBytes gap = SizeInBytes.ONE_MB;
            long diff = this.messageSizeMax.getSize() - appenderBufferSize.getSize();
            if (diff < gap.getSize()) {
                throw new IllegalArgumentException("Illegal configuration: raft.grpc.message.size.max(= " + this.messageSizeMax + ") must be " + gap + " larger than " + "raft.server.log.appender.buffer.byte-limit" + "(= " + appenderBufferSize + ").");
            }
            return this;
        }

        public Builder setCustomizer(GrpcServices.Customizer customizer) {
            this.customizer = customizer != null ? customizer : GrpcServices.Customizer.getDefaultInstance();
            return this;
        }

        private GrpcServerProtocolClient newGrpcServerProtocolClient(RaftPeer target) {
            return new GrpcServerProtocolClient(target, this.flowControlWindow.getSizeInt(), this.requestTimeoutDuration, this.serverTlsConfig, this.separateHeartbeatChannel);
        }

        private ExecutorService newExecutor() {
            RaftProperties properties = this.server.getProperties();
            return ConcurrentUtils.newThreadPoolWithMax(GrpcConfigKeys.Server.asyncRequestThreadPoolCached(properties), GrpcConfigKeys.Server.asyncRequestThreadPoolSize(properties), this.server.getId() + "-request-");
        }

        private GrpcClientProtocolService newGrpcClientProtocolService(ExecutorService executor) {
            return new GrpcClientProtocolService(this.server::getId, this.server, executor);
        }

        private GrpcServerProtocolService newGrpcServerProtocolService() {
            return new GrpcServerProtocolService(this.server::getId, this.server);
        }

        private MetricServerInterceptor newMetricServerInterceptor() {
            return new MetricServerInterceptor(this.server::getId, JavaUtils.getClassSimpleName(this.getClass()) + "_" + this.serverPort);
        }

        Server buildServer(NettyServerBuilder builder, EnumSet<GrpcServices.Type> types) {
            return this.customizer.customize(builder, types).build();
        }

        private NettyServerBuilder newNettyServerBuilderForServer() {
            return this.newNettyServerBuilder(this.serverHost, this.serverPort, this.serverTlsConfig);
        }

        private NettyServerBuilder newNettyServerBuilderForAdmin() {
            return this.newNettyServerBuilder(this.adminHost, this.adminPort, this.adminTlsConfig);
        }

        private NettyServerBuilder newNettyServerBuilderForClient() {
            return this.newNettyServerBuilder(this.clientHost, this.clientPort, this.clientTlsConfig);
        }

        private NettyServerBuilder newNettyServerBuilder(String hostname, int port, GrpcTlsConfig tlsConfig) {
            InetSocketAddress address = hostname == null || hostname.isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
            NettyServerBuilder nettyServerBuilder = NettyServerBuilder.forAddress(address).withChildOption(ChannelOption.SO_REUSEADDR, true).maxInboundMessageSize(this.messageSizeMax.getSizeInt()).flowControlWindow(this.flowControlWindow.getSizeInt());
            if (tlsConfig != null) {
                LOG.info("Setting TLS for {}", (Object)address);
                SslContextBuilder sslContextBuilder = GrpcUtil.initSslContextBuilderForServer(tlsConfig.getKeyManager());
                if (tlsConfig.getMtlsEnabled()) {
                    sslContextBuilder.clientAuth(ClientAuth.REQUIRE);
                    GrpcUtil.setTrustManager(sslContextBuilder, tlsConfig.getTrustManager());
                }
                sslContextBuilder = GrpcSslContexts.configure(sslContextBuilder, SslProvider.OPENSSL);
                try {
                    nettyServerBuilder.sslContext(sslContextBuilder.build());
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Failed to build SslContext, tlsConfig=" + tlsConfig, ex);
                }
            }
            return nettyServerBuilder;
        }

        private boolean separateAdminServer() {
            return this.adminPort > 0 && this.adminPort != this.serverPort;
        }

        private boolean separateClientServer() {
            return this.clientPort > 0 && this.clientPort != this.serverPort;
        }

        Server newServer(GrpcClientProtocolService client, ServerInterceptor interceptor) {
            EnumSet<GrpcServices.Type> types = EnumSet.of(GrpcServices.Type.SERVER);
            NettyServerBuilder serverBuilder = this.newNettyServerBuilderForServer();
            GrpcServerProtocolService service = this.newGrpcServerProtocolService();
            serverBuilder.addService(ServerInterceptors.intercept((BindableService)service, interceptor));
            if (!this.separateAdminServer()) {
                types.add(GrpcServices.Type.ADMIN);
                GrpcServicesImpl.addAdminService(serverBuilder, this.server, interceptor);
            }
            if (!this.separateClientServer()) {
                types.add(GrpcServices.Type.CLIENT);
                GrpcServicesImpl.addClientService(serverBuilder, client, interceptor);
            }
            return this.buildServer(serverBuilder, types);
        }

        public GrpcServicesImpl build() {
            return new GrpcServicesImpl(this);
        }

        public Builder setAdminTlsConfig(GrpcTlsConfig config) {
            this.adminTlsConfig = config;
            return this;
        }

        public Builder setClientTlsConfig(GrpcTlsConfig config) {
            this.clientTlsConfig = config;
            return this;
        }

        public Builder setServerTlsConfig(GrpcTlsConfig config) {
            this.serverTlsConfig = config;
            return this;
        }
    }

    class AsyncService
    implements RaftServerAsynchronousProtocol {
        AsyncService() {
        }

        @Override
        public CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftProtos.AppendEntriesRequestProto request) {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public CompletableFuture<RaftProtos.ReadIndexReplyProto> readIndexAsync(RaftProtos.ReadIndexRequestProto request) throws IOException {
            CodeInjectionForTesting.execute(GRPC_SEND_SERVER_REQUEST, GrpcServicesImpl.this.getId(), null, request);
            final CompletableFuture<RaftProtos.ReadIndexReplyProto> f = new CompletableFuture<RaftProtos.ReadIndexReplyProto>();
            StreamObserver<RaftProtos.ReadIndexReplyProto> s2 = new StreamObserver<RaftProtos.ReadIndexReplyProto>(){

                @Override
                public void onNext(RaftProtos.ReadIndexReplyProto reply) {
                    f.complete(reply);
                }

                @Override
                public void onError(Throwable throwable) {
                    f.completeExceptionally(throwable);
                }

                @Override
                public void onCompleted() {
                }
            };
            RaftPeerId target = RaftPeerId.valueOf(request.getServerRequest().getReplyId());
            ((GrpcServerProtocolClient)((PeerProxyMap)GrpcServicesImpl.this.getProxies()).getProxy(target)).readIndex(request, s2);
            return f;
        }
    }
}

