/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.impl.ServerImplUtils;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.thirdparty.com.google.protobuf.AbstractMessage;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;

public final class LogProtoUtils {
    private LogProtoUtils() {
    }

    public static String toLogEntryString(RaftProtos.LogEntryProto entry, Function<RaftProtos.StateMachineLogEntryProto, String> function) {
        String s2;
        if (entry == null) {
            return null;
        }
        if (entry.hasStateMachineLogEntry()) {
            if (function == null) {
                function = LogProtoUtils::stateMachineLogEntryProtoToString;
            }
            s2 = ", " + function.apply(entry.getStateMachineLogEntry());
        } else if (entry.hasMetadataEntry()) {
            RaftProtos.MetadataProto metadata = entry.getMetadataEntry();
            s2 = "(c:" + metadata.getCommitIndex() + ")";
        } else if (entry.hasConfigurationEntry()) {
            RaftProtos.RaftConfigurationProto config = entry.getConfigurationEntry();
            s2 = "(current:" + LogProtoUtils.peersToString(config.getPeersList()) + ", old:" + LogProtoUtils.peersToString(config.getOldPeersList()) + ")";
        } else {
            s2 = "";
        }
        return TermIndex.valueOf(entry) + ", " + entry.getLogEntryBodyCase() + s2;
    }

    static String peersToString(List<RaftProtos.RaftPeerProto> peers) {
        return peers.stream().map(AbstractMessage::toString).map(s2 -> s2.replace("\n", "")).map(s2 -> s2.replace(" ", "")).collect(Collectors.joining(", "));
    }

    static String stateMachineLogEntryProtoToString(RaftProtos.StateMachineLogEntryProto p) {
        RaftProtos.StateMachineEntryProto stateMachineEntry = p.getStateMachineEntry();
        return p.getType() + ": logData.size=" + p.getLogData().size() + ", stateMachineData.size=" + stateMachineEntry.getStateMachineData().size() + ", logEntryProtoSerializedSize=" + stateMachineEntry.getLogEntryProtoSerializedSize();
    }

    public static String toLogEntryString(RaftProtos.LogEntryProto entry) {
        return LogProtoUtils.toLogEntryString(entry, LogProtoUtils::stateMachineLogEntryProtoToString);
    }

    public static String toLogEntriesString(List<RaftProtos.LogEntryProto> entries) {
        return entries == null ? null : entries.stream().map(LogProtoUtils::toLogEntryString).collect(Collectors.toList()).toString();
    }

    public static String toLogEntriesShortString(List<RaftProtos.LogEntryProto> entries, Function<RaftProtos.StateMachineLogEntryProto, String> stateMachineToString) {
        return entries == null ? null : (entries.isEmpty() ? "<empty>" : "size=" + entries.size() + ", first=" + LogProtoUtils.toLogEntryString(entries.get(0), stateMachineToString));
    }

    public static RaftProtos.LogEntryProto toLogEntryProto(RaftConfiguration conf, Long term, long index) {
        RaftProtos.LogEntryProto.Builder b = RaftProtos.LogEntryProto.newBuilder();
        Optional.ofNullable(term).ifPresent(b::setTerm);
        return b.setIndex(index).setConfigurationEntry(LogProtoUtils.toRaftConfigurationProtoBuilder(conf)).build();
    }

    public static RaftProtos.RaftConfigurationProto.Builder toRaftConfigurationProtoBuilder(RaftConfiguration conf) {
        return RaftProtos.RaftConfigurationProto.newBuilder().addAllPeers(ProtoUtils.toRaftPeerProtos(conf.getCurrentPeers())).addAllListeners(ProtoUtils.toRaftPeerProtos(conf.getCurrentPeers(RaftProtos.RaftPeerRole.LISTENER))).addAllOldPeers(ProtoUtils.toRaftPeerProtos(conf.getPreviousPeers())).addAllOldListeners(ProtoUtils.toRaftPeerProtos(conf.getPreviousPeers(RaftProtos.RaftPeerRole.LISTENER)));
    }

    public static RaftProtos.LogEntryProto toLogEntryProto(RaftProtos.StateMachineLogEntryProto proto, long term, long index) {
        return RaftProtos.LogEntryProto.newBuilder().setTerm(term).setIndex(index).setStateMachineLogEntry(proto).build();
    }

    public static RaftProtos.LogEntryProto toLogEntryProto(long commitIndex, long term, long index) {
        return RaftProtos.LogEntryProto.newBuilder().setTerm(term).setIndex(index).setMetadataEntry(RaftProtos.MetadataProto.newBuilder().setCommitIndex(commitIndex)).build();
    }

    public static RaftProtos.LogEntryProto removeStateMachineData(RaftProtos.LogEntryProto entry) {
        return LogProtoUtils.getStateMachineEntry(entry).map(RaftProtos.StateMachineEntryProto::getStateMachineData).filter(stateMachineData -> !stateMachineData.isEmpty()).map(_dummy -> LogProtoUtils.replaceStateMachineDataWithSerializedSize(entry)).orElse(entry);
    }

    private static RaftProtos.LogEntryProto replaceStateMachineDataWithSerializedSize(RaftProtos.LogEntryProto entry) {
        return LogProtoUtils.replaceStateMachineEntry(entry, RaftProtos.StateMachineEntryProto.newBuilder().setLogEntryProtoSerializedSize(entry.getSerializedSize()));
    }

    private static RaftProtos.LogEntryProto replaceStateMachineEntry(RaftProtos.LogEntryProto proto, RaftProtos.StateMachineEntryProto.Builder newEntry) {
        Preconditions.assertTrue(proto.hasStateMachineLogEntry(), () -> "Unexpected proto " + proto);
        return RaftProtos.LogEntryProto.newBuilder(proto).setStateMachineLogEntry(RaftProtos.StateMachineLogEntryProto.newBuilder(proto.getStateMachineLogEntry()).setStateMachineEntry(newEntry)).build();
    }

    static RaftProtos.LogEntryProto addStateMachineData(ByteString stateMachineData, RaftProtos.LogEntryProto entry) {
        Preconditions.assertTrue(LogProtoUtils.isStateMachineDataEmpty(entry), () -> "Failed to addStateMachineData to " + entry + " since shouldReadStateMachineData is false.");
        return LogProtoUtils.replaceStateMachineEntry(entry, RaftProtos.StateMachineEntryProto.newBuilder().setStateMachineData(stateMachineData));
    }

    public static boolean isStateMachineDataEmpty(RaftProtos.LogEntryProto entry) {
        return LogProtoUtils.getStateMachineEntry(entry).map(RaftProtos.StateMachineEntryProto::getStateMachineData).map(ByteString::isEmpty).orElse(false);
    }

    private static Optional<RaftProtos.StateMachineEntryProto> getStateMachineEntry(RaftProtos.LogEntryProto entry) {
        return Optional.of(entry).filter(RaftProtos.LogEntryProto::hasStateMachineLogEntry).map(RaftProtos.LogEntryProto::getStateMachineLogEntry).filter(RaftProtos.StateMachineLogEntryProto::hasStateMachineEntry).map(RaftProtos.StateMachineLogEntryProto::getStateMachineEntry);
    }

    public static int getSerializedSize(RaftProtos.LogEntryProto entry) {
        return LogProtoUtils.getStateMachineEntry(entry).filter(stateMachineEntry -> stateMachineEntry.getStateMachineData().isEmpty()).map(RaftProtos.StateMachineEntryProto::getLogEntryProtoSerializedSize).orElseGet(entry::getSerializedSize);
    }

    private static RaftProtos.StateMachineLogEntryProto.Type toStateMachineLogEntryProtoType(RaftProtos.RaftClientRequestProto.TypeCase type) {
        switch (type) {
            case WRITE: {
                return RaftProtos.StateMachineLogEntryProto.Type.WRITE;
            }
            case DATASTREAM: {
                return RaftProtos.StateMachineLogEntryProto.Type.DATASTREAM;
            }
        }
        throw new IllegalStateException("Unexpected request type " + type);
    }

    public static RaftProtos.StateMachineLogEntryProto toStateMachineLogEntryProto(RaftClientRequest request, ByteString logData, ByteString stateMachineData) {
        if (logData == null) {
            logData = request.getMessage().getContent();
        }
        RaftProtos.StateMachineLogEntryProto.Type type = LogProtoUtils.toStateMachineLogEntryProtoType(request.getType().getTypeCase());
        return LogProtoUtils.toStateMachineLogEntryProto(request.getClientId(), request.getCallId(), type, logData, stateMachineData);
    }

    public static RaftProtos.StateMachineLogEntryProto toStateMachineLogEntryProto(ClientId clientId, long callId, RaftProtos.StateMachineLogEntryProto.Type type, ByteString logData, ByteString stateMachineData) {
        RaftProtos.StateMachineLogEntryProto.Builder b = RaftProtos.StateMachineLogEntryProto.newBuilder().setClientId(clientId.toByteString()).setCallId(callId).setType(type).setLogData(logData);
        Optional.ofNullable(stateMachineData).map(RaftProtos.StateMachineEntryProto.newBuilder()::setStateMachineData).ifPresent(b::setStateMachineEntry);
        return b.build();
    }

    public static RaftConfiguration toRaftConfiguration(RaftProtos.LogEntryProto entry) {
        Preconditions.assertTrue(entry.hasConfigurationEntry());
        RaftProtos.RaftConfigurationProto proto = entry.getConfigurationEntry();
        List<RaftPeer> conf = ProtoUtils.toRaftPeers(proto.getPeersList());
        List<RaftPeer> listener = ProtoUtils.toRaftPeers(proto.getListenersList());
        List<RaftPeer> oldConf = ProtoUtils.toRaftPeers(proto.getOldPeersList());
        List<RaftPeer> oldListener = ProtoUtils.toRaftPeers(proto.getOldListenersList());
        return ServerImplUtils.newRaftConfiguration(conf, listener, entry.getIndex(), oldConf, oldListener);
    }
}

