/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.utils;

public class Quota {
    private final int max;
    private final int[] samples;
    private final long[] timeVec;
    private final int window;

    public Quota(int max) {
        this(5, max);
    }

    public Quota(int window, int max) {
        if (window < 5) {
            window = 5;
        }
        this.max = max;
        this.window = window;
        this.samples = new int[window];
        this.timeVec = new long[window];
    }

    private int index(long currTimeMs) {
        return (int)(this.second(currTimeMs) % (long)this.window);
    }

    private long second(long currTimeMs) {
        return currTimeMs / 1000L;
    }

    public void sample(int value) {
        long second;
        long timeMs = System.currentTimeMillis();
        int index = this.index(timeMs);
        if (this.timeVec[index] != (second = this.second(timeMs))) {
            this.timeVec[index] = second;
            this.samples[index] = value;
        } else {
            int n = index;
            this.samples[n] = this.samples[n] + value;
        }
    }

    public boolean validateNow() {
        long second;
        long timeMs = System.currentTimeMillis();
        int index = this.index(timeMs);
        if (this.timeVec[index] == (second = this.second(timeMs))) {
            return this.samples[index] >= this.max;
        }
        return false;
    }

    public int leftNow() {
        long timeMs = System.currentTimeMillis();
        return (int)((this.second(timeMs) + 1L) * 1000L - timeMs);
    }
}

