/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.cert;

import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.common.utils.StartAndShutdown;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;
import org.apache.rocketmq.srvutil.FileWatchService;

public class TlsCertificateManager
implements StartAndShutdown {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final FileWatchService fileWatchService;
    private final List<TlsContextReloadListener> reloadListeners = new ArrayList<TlsContextReloadListener>();

    public TlsCertificateManager() {
        try {
            this.fileWatchService = new FileWatchService(new String[]{ConfigurationManager.getProxyConfig().getTlsCertPath(), ConfigurationManager.getProxyConfig().getTlsKeyPath()}, (FileWatchService.Listener)new CertKeyFileWatchListener(), ConfigurationManager.getProxyConfig().getTlsCertWatchIntervalMs());
        }
        catch (Exception e) {
            log.error("Failed to initialize TLS certificate watch service", (Throwable)e);
            throw new RuntimeException("Failed to initialize TLS certificate manager", e);
        }
    }

    public FileWatchService getFileWatchService() {
        return this.fileWatchService;
    }

    public void registerReloadListener(TlsContextReloadListener listener) {
        if (listener != null) {
            this.reloadListeners.add(listener);
        }
    }

    public void unregisterReloadListener(TlsContextReloadListener listener) {
        if (listener != null) {
            this.reloadListeners.remove(listener);
        }
    }

    public List<TlsContextReloadListener> getReloadListeners() {
        return this.reloadListeners;
    }

    public void start() throws Exception {
        this.fileWatchService.start();
        log.info("TLS certificate manager started successfully, start watching: {} {}", (Object)ConfigurationManager.getProxyConfig().getTlsCertPath(), (Object)ConfigurationManager.getProxyConfig().getTlsKeyPath());
    }

    public void shutdown() throws Exception {
        this.fileWatchService.shutdown();
        log.info("TLS certificate manager shutdown successfully");
    }

    public static interface TlsContextReloadListener {
        public void onTlsContextReload();
    }

    private class CertKeyFileWatchListener
    implements FileWatchService.Listener {
        private boolean certChanged = false;
        private boolean keyChanged = false;

        private CertKeyFileWatchListener() {
        }

        public void onChanged(String path) {
            log.info("File changed: {}", (Object)path);
            if (path.equals(TlsSystemConfig.tlsServerCertPath)) {
                this.certChanged = true;
            } else if (path.equals(TlsSystemConfig.tlsServerKeyPath)) {
                this.keyChanged = true;
            }
            if (this.certChanged && this.keyChanged) {
                log.info("The certificate and private key changed, reload the ssl context");
                this.notifyContextReload();
                this.certChanged = false;
                this.keyChanged = false;
            }
        }

        private void notifyContextReload() {
            for (TlsContextReloadListener listener : TlsCertificateManager.this.reloadListeners) {
                try {
                    listener.onTlsContextReload();
                }
                catch (Throwable e) {
                    log.error("Failed to notify TLS context reload to listener: " + listener, e);
                }
            }
        }
    }
}

