/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.nlpmodel;

import java.io.Serializable;
import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.seatunnel.transform.nlpmodel.ModelProvider;

public class ModelTransformConfig
implements Serializable {
    public static final Option<ModelProvider> MODEL_PROVIDER = Options.key((String)"model_provider").enumType(ModelProvider.class).noDefaultValue().withDescription("The model provider of LLM/Embedding");
    public static final Option<SqlType> OUTPUT_DATA_TYPE = Options.key((String)"output_data_type").enumType(SqlType.class).defaultValue((Object)SqlType.STRING).withDescription("The output data type of LLM");
    public static final Option<String> MODEL = Options.key((String)"model").stringType().noDefaultValue().withDescription("The model of LLM/Embedding, eg: if the model provider is OpenAI LLM, the model should be gpt-3.5-turbo/gpt-4o-mini, etc.");
    public static final Option<String> API_KEY = Options.key((String)"api_key").stringType().noDefaultValue().withDescription("The API key of LLM/Embedding");
    public static final Option<String> SECRET_KEY = Options.key((String)"secret_key").stringType().noDefaultValue().withDescription("The Secret key of LLM/Embedding");
    public static final Option<String> API_PATH = Options.key((String)"api_path").stringType().noDefaultValue().withFallbackKeys(new String[]{"openai.api_path"}).withDescription("The API of LLM/Embedding");
    public static final Option<String> OAUTH_PATH = Options.key((String)"oauth_path").stringType().noDefaultValue().withDescription("The Oauth path of LLM/Embedding");
    public static final Option<Integer> PROCESS_BATCH_SIZE = Options.key((String)"process_batch_size").intType().defaultValue((Object)100).withFallbackKeys(new String[]{"inference_batch_size"}).withDescription("The row batch size of each process");
    public static final Option<Integer> DIMENSION = Options.key((String)"dimension").intType().defaultValue((Object)2048).withDescription("dimension");

    public static class CustomRequestConfig {
        public static final Option<Map<String, Object>> CUSTOM_CONFIG = Options.key((String)"custom_config").type((TypeReference)new TypeReference<Map<String, Object>>(){}).noDefaultValue().withDescription("The custom config of the custom model.");
        public static final Option<String> CUSTOM_RESPONSE_PARSE = Options.key((String)"custom_response_parse").stringType().noDefaultValue().withDescription("The response parse of the custom model. You can use Jsonpath to parse the return object you want to parse. eg: $.choices[*].message.content");
        public static final Option<Map<String, String>> CUSTOM_REQUEST_HEADERS = Options.key((String)"custom_request_headers").mapType().noDefaultValue().withDescription("The custom request headers of the custom model.");
        public static final Option<Map<String, Object>> CUSTOM_REQUEST_BODY = Options.key((String)"custom_request_body").type((TypeReference)new TypeReference<Map<String, Object>>(){}).noDefaultValue().withDescription("The custom request body of the custom model.1. ${model} placeholder for selecting model name.2. ${input} placeholder for Determine input type. eg: [\"${input}\"]3. ${prompt} placeholder for LLM model 4. ...");
    }
}

