/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.table;

import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonAlias;

public class TableMergeConfig
implements Serializable {
    public static final Option<String> DATABASE = Options.key((String)"database").stringType().noDefaultValue().withDescription("Specify new database name");
    public static final Option<String> SCHEMA = Options.key((String)"schema").stringType().noDefaultValue().withDescription("Specify new schema name");
    public static final Option<String> TABLE = Options.key((String)"table").stringType().noDefaultValue().withDescription("Specify new table name");
    @JsonAlias(value={"database"})
    private String database;
    @JsonAlias(value={"schema"})
    private String schema;
    @JsonAlias(value={"table"})
    private String table;

    public TablePath getTablePath() {
        return TablePath.of((String)this.database, (String)this.schema, (String)this.table);
    }

    public static TableMergeConfig of(ReadonlyConfig config) {
        TableMergeConfig mergeConfig = new TableMergeConfig();
        mergeConfig.setDatabase((String)config.get(DATABASE));
        mergeConfig.setSchema((String)config.get(SCHEMA));
        mergeConfig.setTable((String)config.get(TABLE));
        return mergeConfig;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public TableMergeConfig setDatabase(String database) {
        this.database = database;
        return this;
    }

    public TableMergeConfig setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public TableMergeConfig setTable(String table) {
        this.table = table;
        return this;
    }
}

