/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAddListenerMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class AddPartitionLostListenerMessageTask
extends AbstractAddListenerMessageTask<Boolean> {
    public AddPartitionLostListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<UUID> processInternal() {
        IPartitionService partitionService = (IPartitionService)this.getService(this.getServiceName());
        PartitionLostListener listener = event -> {
            if (this.endpoint.isAlive()) {
                ClusterService clusterService = (ClusterService)this.getService("hz:core:clusterService");
                Address eventSource = event.getEventSource();
                MemberImpl member = clusterService.getMember(eventSource);
                ClientMessage eventMessage = ClientAddPartitionLostListenerCodec.encodePartitionLostEvent(event.getPartitionId(), event.getLostBackupCount(), member.getUuid());
                this.sendClientMessage(null, eventMessage);
            }
        };
        if (((Boolean)this.parameters).booleanValue()) {
            return InternalCompletableFuture.newCompletedFuture(partitionService.addLocalPartitionLostListener(listener));
        }
        return partitionService.addPartitionLostListenerAsync(listener);
    }

    @Override
    protected Boolean decodeClientMessage(ClientMessage clientMessage) {
        return ClientAddPartitionLostListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ClientAddPartitionLostListenerCodec.encodeResponse((UUID)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return ".partitionLost";
    }

    @Override
    public String getMethodName() {
        return "addPartitionLostListener";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

