/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.RingbufferAddAllCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferAddCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferCapacityCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferHeadSequenceCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferReadManyCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferReadOneCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferRemainingCapacityCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferSizeCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferTailSequenceCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.IFunction;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.ringbuffer.OverflowPolicy;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.ringbuffer.StaleSequenceException;
import com.hazelcast.ringbuffer.impl.ReadResultSetImpl;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.Collection;
import javax.annotation.Nonnull;

public class ClientRingbufferProxy<E>
extends ClientProxy
implements Ringbuffer<E> {
    private ClientMessageDecoder readManyAsyncResponseDecoder;
    private int partitionId;
    private volatile long capacity = -1L;

    public ClientRingbufferProxy(String serviceName, String objectName, ClientContext context) {
        super(serviceName, objectName, context);
    }

    @Override
    protected void onInitialize() {
        String partitionKey = StringPartitioningStrategy.getPartitionKey(this.name);
        this.partitionId = this.getContext().getPartitionService().getPartitionId(partitionKey);
        this.readManyAsyncResponseDecoder = clientMessage -> {
            RingbufferReadManyCodec.ResponseParameters params = RingbufferReadManyCodec.decodeResponse(clientMessage);
            ReadResultSetImpl readResultSet = new ReadResultSetImpl(params.readCount, params.items, params.itemSeqs, params.nextSeq);
            readResultSet.setSerializationService(this.getSerializationService());
            return readResultSet;
        };
    }

    @Override
    public long capacity() {
        if (this.capacity == -1L) {
            ClientMessage request = RingbufferCapacityCodec.encodeRequest(this.name);
            ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
            this.capacity = RingbufferCapacityCodec.decodeResponse(response);
        }
        return this.capacity;
    }

    @Override
    public long size() {
        ClientMessage request = RingbufferSizeCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
        return RingbufferSizeCodec.decodeResponse(response);
    }

    @Override
    public long tailSequence() {
        ClientMessage request = RingbufferTailSequenceCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
        return RingbufferTailSequenceCodec.decodeResponse(response);
    }

    @Override
    public long headSequence() {
        ClientMessage request = RingbufferHeadSequenceCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
        return RingbufferHeadSequenceCodec.decodeResponse(response);
    }

    @Override
    public long remainingCapacity() {
        ClientMessage request = RingbufferRemainingCapacityCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
        return RingbufferRemainingCapacityCodec.decodeResponse(response);
    }

    @Override
    public long add(@Nonnull E item) {
        Preconditions.checkNotNull(item, "item can't be null");
        Data element = this.toData(item);
        ClientMessage request = RingbufferAddCodec.encodeRequest(this.name, OverflowPolicy.OVERWRITE.getId(), element);
        ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
        return RingbufferAddCodec.decodeResponse(response);
    }

    public InternalCompletableFuture<Long> addAsync(@Nonnull E item, @Nonnull OverflowPolicy overflowPolicy) {
        Preconditions.checkNotNull(item, "item can't be null");
        Preconditions.checkNotNull(overflowPolicy, "overflowPolicy can't be null");
        Data element = this.toData(item);
        ClientMessage request = RingbufferAddCodec.encodeRequest(this.name, overflowPolicy.getId(), element);
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, (Object)this.getName(), this.partitionId).invoke();
            return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), RingbufferAddCodec::decodeResponse);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public E readOne(long sequence) throws InterruptedException {
        ClientRingbufferProxy.checkSequence(sequence);
        ClientMessage request = RingbufferReadOneCodec.encodeRequest(this.name, sequence);
        ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
        return (E)this.toObject(RingbufferReadOneCodec.decodeResponse(response));
    }

    public InternalCompletableFuture<Long> addAllAsync(@Nonnull Collection<? extends E> collection, @Nonnull OverflowPolicy overflowPolicy) {
        Preconditions.checkNotNull(collection, "collection can't be null");
        Preconditions.checkNotNull(overflowPolicy, "overflowPolicy can't be null");
        Preconditions.checkFalse(collection.isEmpty(), "collection can't be empty");
        Preconditions.checkTrue(collection.size() <= 1000, "collection can't be larger than 1000");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(collection, this.getSerializationService());
        ClientMessage request = RingbufferAddAllCodec.encodeRequest(this.name, dataCollection, overflowPolicy.getId());
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, (Object)this.getName(), this.partitionId).invoke();
            return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), RingbufferAddAllCodec::decodeResponse);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public InternalCompletableFuture<ReadResultSet<E>> readManyAsync(long startSequence, int minCount, int maxCount, IFunction<E, Boolean> filter) {
        ClientRingbufferProxy.checkSequence(startSequence);
        Preconditions.checkNotNegative(minCount, "minCount can't be smaller than 0");
        Preconditions.checkTrue(maxCount >= minCount, "maxCount should be equal or larger than minCount");
        try {
            this.capacity();
        }
        catch (Throwable e) {
            return InternalCompletableFuture.completedExceptionally(e);
        }
        Preconditions.checkTrue((long)maxCount <= this.capacity, "the maxCount should be smaller than or equal to the capacity");
        Preconditions.checkTrue(maxCount <= 1000, "maxCount can't be larger than 1000");
        ClientMessage request = RingbufferReadManyCodec.encodeRequest(this.name, startSequence, minCount, maxCount, this.toData(filter));
        try {
            ClientInvocationFuture invocationFuture = new ClientInvocation(this.getClient(), request, (Object)this.getName(), this.partitionId).invoke();
            return new ClientDelegatingFuture<ReadResultSet<E>>(invocationFuture, this.getSerializationService(), this.readManyAsyncResponseDecoder);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private static void checkSequence(long sequence) {
        if (sequence < 0L) {
            throw new IllegalArgumentException("sequence can't be smaller than 0, but was: " + sequence);
        }
    }

    protected <T> T invoke(ClientMessage clientMessage, int partitionId) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, (Object)this.getName(), partitionId).invoke();
            return (T)future.joinInternal();
        }
        catch (StaleSequenceException e) {
            long l = this.headSequence();
            throw new StaleSequenceException(e.getMessage(), l);
        }
    }

    public String toString() {
        return String.format("Ringbuffer{name='%s'}", this.name);
    }
}

