/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.pipeline.ServiceFactory;
import com.hazelcast.map.IMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.security.impl.function.SecuredFunctions;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import javax.annotation.Nonnull;

public final class ServiceFactories {
    private ServiceFactories() {
    }

    @Nonnull
    public static <K, V> ServiceFactory<?, ReplicatedMap<K, V>> replicatedMapService(@Nonnull String mapName) {
        ServiceFactory replicatedMapFactory = ServiceFactories.sharedService(SecuredFunctions.replicatedMapFn(mapName));
        return replicatedMapFactory.withPermission(new ReplicatedMapPermission(mapName, "create", "read"));
    }

    @Nonnull
    public static <K, V> ServiceFactory<?, IMap<K, V>> iMapService(@Nonnull String mapName) {
        ServiceFactory iMapServiceFactory = ServiceFactories.sharedService(SecuredFunctions.iMapFn(mapName));
        return iMapServiceFactory.withPermission(new MapPermission(mapName, "create", "read"));
    }

    @Nonnull
    public static <S> ServiceFactory<?, S> sharedService(@Nonnull FunctionEx<? super ProcessorSupplier.Context, S> createServiceFn) {
        return ServiceFactories.sharedService(createServiceFn, ConsumerEx.noop());
    }

    public static <S> ServiceFactory<?, S> sharedService(@Nonnull FunctionEx<? super ProcessorSupplier.Context, S> createServiceFn, @Nonnull ConsumerEx<S> destroyServiceFn) {
        return ServiceFactory.withCreateContextFn(createServiceFn).withCreateServiceFn((ctx, c) -> c).withDestroyContextFn(destroyServiceFn);
    }

    @Nonnull
    public static <S> ServiceFactory<?, S> nonSharedService(@Nonnull FunctionEx<? super Processor.Context, ? extends S> createServiceFn) {
        return ServiceFactories.nonSharedService(createServiceFn, ConsumerEx.noop());
    }

    public static <S> ServiceFactory<?, S> nonSharedService(@Nonnull FunctionEx<? super Processor.Context, ? extends S> createServiceFn, @Nonnull ConsumerEx<? super S> destroyServiceFn) {
        return ServiceFactory.withCreateContextFn(c -> null).withCreateServiceFn(SecuredFunctions.createServiceFn(createServiceFn)).withDestroyServiceFn(destroyServiceFn);
    }
}

