/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryRunner;
import com.hazelcast.map.impl.query.ResultSegment;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class MapFetchWithQueryOperation
extends MapOperation
implements ReadonlyOperation {
    private Query query;
    private int fetchSize;
    private IterationPointer[] pointers;
    private transient ResultSegment response;

    public MapFetchWithQueryOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is an internal class")
    public MapFetchWithQueryOperation(String name, IterationPointer[] pointers, int fetchSize, Query query) {
        super(name);
        this.pointers = pointers;
        this.fetchSize = fetchSize;
        this.query = query;
    }

    @Override
    protected void runInternal() {
        QueryRunner runner = this.mapServiceContext.getMapQueryRunner(this.query.getMapName());
        this.response = runner.runPartitionScanQueryOnPartitionChunk(this.query, this.getPartitionId(), this.pointers, this.fetchSize);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.fetchSize = in.readInt();
        int pointersCount = in.readInt();
        this.pointers = new IterationPointer[pointersCount];
        for (int i = 0; i < pointersCount; ++i) {
            this.pointers[i] = new IterationPointer(in.readInt(), in.readInt());
        }
        this.query = (Query)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.fetchSize);
        out.writeInt(this.pointers.length);
        for (IterationPointer pointer : this.pointers) {
            out.writeInt(pointer.getIndex());
            out.writeInt(pointer.getSize());
        }
        out.writeObject(this.query);
    }

    @Override
    public int getClassId() {
        return 127;
    }
}

