/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore.expiry;

import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public interface ExpiryMetadata {
    public static final ExpiryMetadata NULL = new ExpiryMetadata(){

        @Override
        public boolean hasExpiry() {
            return false;
        }

        @Override
        public long getTtl() {
            return Long.MAX_VALUE;
        }

        @Override
        public int getRawTtl() {
            return Integer.MAX_VALUE;
        }

        @Override
        public ExpiryMetadata setTtl(long ttl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExpiryMetadata setRawTtl(int ttl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getMaxIdle() {
            return Long.MAX_VALUE;
        }

        @Override
        public int getRawMaxIdle() {
            return Integer.MAX_VALUE;
        }

        @Override
        public ExpiryMetadata setMaxIdle(long maxIdle) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExpiryMetadata setRawMaxIdle(int maxIdle) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getExpirationTime() {
            return Long.MAX_VALUE;
        }

        @Override
        public int getRawExpirationTime() {
            return Integer.MAX_VALUE;
        }

        @Override
        public ExpiryMetadata setExpirationTime(long expirationTime) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExpiryMetadata setRawExpirationTime(int expirationTime) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastUpdateTime() {
            return 0L;
        }

        @Override
        public int getRawLastUpdateTime() {
            return 0;
        }

        @Override
        public ExpiryMetadata setLastUpdateTime(long lastUpdateTime) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExpiryMetadata setRawLastUpdateTime(int lastUpdateTime) {
            throw new UnsupportedOperationException();
        }
    };

    default public boolean hasExpiry() {
        return true;
    }

    public long getTtl();

    public int getRawTtl();

    public ExpiryMetadata setTtl(long var1);

    public ExpiryMetadata setRawTtl(int var1);

    public long getMaxIdle();

    public int getRawMaxIdle();

    public ExpiryMetadata setMaxIdle(long var1);

    public ExpiryMetadata setRawMaxIdle(int var1);

    public long getExpirationTime();

    public int getRawExpirationTime();

    public ExpiryMetadata setExpirationTime(long var1);

    public ExpiryMetadata setRawExpirationTime(int var1);

    public long getLastUpdateTime();

    public int getRawLastUpdateTime();

    public ExpiryMetadata setLastUpdateTime(long var1);

    public ExpiryMetadata setRawLastUpdateTime(int var1);

    default public void write(ObjectDataOutput out) throws IOException {
        out.writeInt(this.getRawTtl());
        out.writeInt(this.getRawMaxIdle());
        out.writeInt(this.getRawExpirationTime());
        out.writeInt(this.getRawLastUpdateTime());
    }

    default public void read(ObjectDataInput in) throws IOException {
        this.setRawTtl(in.readInt());
        this.setRawMaxIdle(in.readInt());
        this.setRawExpirationTime(in.readInt());
        this.setRawLastUpdateTime(in.readInt());
    }

    default public int stripBaseTime(long value) {
        int diff = -1;
        if (value > 0L) {
            diff = (int)TimeUnit.MILLISECONDS.toSeconds(value - Record.EPOCH_TIME);
        }
        return diff;
    }

    default public long recomputeWithBaseTime(int value) {
        if (value == -1) {
            return 0L;
        }
        long exploded = TimeUnit.SECONDS.toMillis(value);
        return exploded + Record.EPOCH_TIME;
    }
}

