/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.wan.impl;

import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.wan.WanEventCounters;
import java.util.concurrent.ConcurrentHashMap;

public class WanEventCounterRegistry {
    private static final ConstructorFunction<String, WanPublisherEventCounters> WAN_EVENT_COUNTER_CONSTRUCTOR_FN = ignored -> new WanPublisherEventCounters();
    private final ConcurrentHashMap<String, WanPublisherEventCounters> eventCounterMap = new ConcurrentHashMap();

    public WanEventCounters getWanEventCounter(String wanReplicationName, String wanPublisherId, String serviceName) {
        String counterId = wanReplicationName + ":" + wanPublisherId;
        WanPublisherEventCounters serviceWanEventCounters = ConcurrencyUtil.getOrPutIfAbsent(this.eventCounterMap, counterId, WAN_EVENT_COUNTER_CONSTRUCTOR_FN);
        return serviceWanEventCounters.getWanEventCounter(serviceName);
    }

    public void removeCounter(String serviceName, String dataStructureName) {
        for (WanPublisherEventCounters publisherWanCounterContainer : this.eventCounterMap.values()) {
            publisherWanCounterContainer.removeCounter(serviceName, dataStructureName);
        }
    }

    private static final class WanPublisherEventCounters {
        private final WanEventCounters mapEventCounters = new WanEventCounters();
        private final WanEventCounters cacheEventCounters = new WanEventCounters();

        private WanPublisherEventCounters() {
        }

        void removeCounter(String serviceName, String dataStructureName) {
            this.getWanEventCounter(serviceName).removeCounter(dataStructureName);
        }

        WanEventCounters getWanEventCounter(String serviceName) {
            if ("hz:impl:mapService".equals(serviceName)) {
                return this.mapEventCounters;
            }
            if ("hz:impl:cacheService".equals(serviceName)) {
                return this.cacheEventCounters;
            }
            throw new IllegalArgumentException("Unsupported service for counting WAN events " + serviceName);
        }
    }
}

