/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.event;

import java.util.LinkedList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.seatunnel.api.event.Event;
import org.apache.seatunnel.api.event.EventHandler;

public interface EventProcessor
extends AutoCloseable {
    public void process(Event var1);

    public static List<EventHandler> loadEventHandlers(ClassLoader classLoader) {
        try {
            LinkedList<EventHandler> result = new LinkedList<EventHandler>();
            ServiceLoader.load(EventHandler.class, classLoader).iterator().forEachRemaining(result::add);
            return result;
        }
        catch (ServiceConfigurationError e) {
            throw new RuntimeException("Could not load service provider for event handlers.", e);
        }
    }

    public static void close(List<EventHandler> handlers) throws Exception {
        if (handlers != null) {
            for (EventHandler handler : handlers) {
                handler.close();
            }
        }
    }
}

