/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager;

import com.hazelcast.spi.impl.NodeEngine;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.common.runtime.DeployType;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.StandaloneResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.UnsupportedDeployTypeException;
import org.apache.seatunnel.engine.server.resourcemanager.thirdparty.kubernetes.KubernetesResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.thirdparty.yarn.YarnResourceManager;

public class ResourceManagerFactory {
    private final NodeEngine nodeEngine;
    private final EngineConfig engineConfig;

    public ResourceManagerFactory(NodeEngine nodeEngine, EngineConfig engineConfig) {
        this.nodeEngine = nodeEngine;
        this.engineConfig = engineConfig;
    }

    public ResourceManager getResourceManager(DeployType type) {
        if (DeployType.STANDALONE.equals((Object)type)) {
            return new StandaloneResourceManager(this.nodeEngine, this.engineConfig);
        }
        if (DeployType.KUBERNETES.equals((Object)type)) {
            return new KubernetesResourceManager(this.nodeEngine, this.engineConfig);
        }
        if (DeployType.YARN.equals((Object)type)) {
            return new YarnResourceManager(this.nodeEngine, this.engineConfig);
        }
        throw new UnsupportedDeployTypeException(type);
    }

    public ResourceManager getResourceManager() {
        return this.getResourceManager(DeployType.STANDALONE);
    }
}

