/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.com.typesafe.config.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigException;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigOrigin;
import org.apache.seatunnel.shade.com.typesafe.config.impl.AbstractConfigObject;
import org.apache.seatunnel.shade.com.typesafe.config.impl.AbstractConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.impl.ConfigImpl;
import org.apache.seatunnel.shade.com.typesafe.config.impl.ConfigString;
import org.apache.seatunnel.shade.com.typesafe.config.impl.FromMapMode;
import org.apache.seatunnel.shade.com.typesafe.config.impl.Path;
import org.apache.seatunnel.shade.com.typesafe.config.impl.ResolveStatus;
import org.apache.seatunnel.shade.com.typesafe.config.impl.SimpleConfigObject;

final class PropertiesParser {
    PropertiesParser() {
    }

    static AbstractConfigObject parse(Reader reader, ConfigOrigin origin) throws IOException {
        Properties props = new Properties();
        props.load(reader);
        return PropertiesParser.fromProperties(origin, props);
    }

    static String lastElement(String path) {
        int i = path.lastIndexOf(46);
        if (i < 0) {
            return path;
        }
        return path.substring(i + 1);
    }

    static String exceptLastElement(String path) {
        int i = path.lastIndexOf(46);
        if (i < 0) {
            return null;
        }
        return path.substring(0, i);
    }

    static Path pathFromPropertyKey(String key) {
        String last = PropertiesParser.lastElement(key);
        String exceptLast = PropertiesParser.exceptLastElement(key);
        Path path = new Path(last, null);
        while (exceptLast != null) {
            last = PropertiesParser.lastElement(exceptLast);
            exceptLast = PropertiesParser.exceptLastElement(exceptLast);
            path = new Path(last, path);
        }
        return path;
    }

    static AbstractConfigObject fromProperties(ConfigOrigin origin, Properties props) {
        return PropertiesParser.fromEntrySet(origin, props.entrySet());
    }

    private static <K, V> AbstractConfigObject fromEntrySet(ConfigOrigin origin, Set<Map.Entry<K, V>> entries) {
        Map<Path, Object> pathMap = PropertiesParser.getPathMap(entries);
        return PropertiesParser.fromPathMap(origin, pathMap, true);
    }

    private static <K, V> Map<Path, Object> getPathMap(Set<Map.Entry<K, V>> entries) {
        LinkedHashMap<Path, Object> pathMap = new LinkedHashMap<Path, Object>();
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key instanceof String) {
                Path path = PropertiesParser.pathFromPropertyKey((String)key);
                pathMap.put(path, value);
            }
        }));
        for (Map.Entry<K, V> entry : entries) {
            K key2 = entry.getKey();
            if (!(key2 instanceof String)) continue;
            Path path = PropertiesParser.pathFromPropertyKey((String)key2);
            pathMap.put(path, entry.getValue());
        }
        return pathMap;
    }

    static AbstractConfigObject fromStringMap(ConfigOrigin origin, Map<String, String> stringMap) {
        return PropertiesParser.fromEntrySet(origin, stringMap.entrySet());
    }

    static AbstractConfigObject fromPathMap(ConfigOrigin origin, Map<?, ?> pathExpressionMap) {
        LinkedHashMap<Path, Object> pathMap = new LinkedHashMap<Path, Object>();
        for (Map.Entry<?, ?> entry : pathExpressionMap.entrySet()) {
            Object keyObj = entry.getKey();
            if (!(keyObj instanceof String)) {
                throw new ConfigException.BugOrBroken("Map has a non-string as a key, expecting a path expression as a String");
            }
            Path path = Path.newPath((String)keyObj);
            pathMap.put(path, entry.getValue());
        }
        return PropertiesParser.fromPathMap(origin, pathMap, false);
    }

    private static AbstractConfigObject fromPathMap(ConfigOrigin origin, Map<Path, Object> pathMap, boolean convertedFromProperties) {
        LinkedHashSet<Path> scopePaths = new LinkedHashSet<Path>();
        LinkedHashSet<Path> valuePaths = new LinkedHashSet<Path>();
        for (Path path : pathMap.keySet()) {
            valuePaths.add(path);
            for (Iterator next = path.parent(); next != null; next = ((Path)((Object)next)).parent()) {
                scopePaths.add((Path)((Object)next));
            }
        }
        if (convertedFromProperties) {
            valuePaths.removeAll(scopePaths);
        } else {
            for (Path path : valuePaths) {
                if (!scopePaths.contains(path)) continue;
                throw new ConfigException.BugOrBroken("In the map, path '" + path.render() + "' occurs as both the parent object of a value and as a value. Because Map has no defined ordering, this is a broken situation.");
            }
        }
        LinkedHashMap<String, AbstractConfigValue> root = new LinkedHashMap<String, AbstractConfigValue>();
        LinkedHashMap scopes = new LinkedHashMap();
        for (Path path : scopePaths) {
            LinkedHashMap scope = new LinkedHashMap();
            scopes.put(path, scope);
        }
        for (Path path : valuePaths) {
            AbstractConfigValue value;
            Path parentPath = path.parent();
            LinkedHashMap<String, AbstractConfigValue> parent = parentPath != null ? (Map)scopes.get(parentPath) : root;
            String last = path.last();
            Object rawValue = pathMap.get(path);
            if (convertedFromProperties) {
                if (rawValue instanceof String) {
                    if (((String)rawValue).startsWith("[") && ((String)rawValue).endsWith("]")) {
                        List<String> list = Arrays.asList(((String)rawValue).substring(1, ((String)rawValue).length() - 1).split(","));
                        value = ConfigImpl.fromAnyRef(list, origin, FromMapMode.KEYS_ARE_PATHS);
                    } else {
                        value = new ConfigString.Quoted(origin, (String)rawValue);
                    }
                } else {
                    value = null;
                }
            } else {
                value = ConfigImpl.fromAnyRef(pathMap.get(path), origin, FromMapMode.KEYS_ARE_PATHS);
            }
            if (value == null) continue;
            parent.put(last, value);
        }
        ArrayList sortedScopePaths = new ArrayList(scopePaths);
        sortedScopePaths.sort((a, b) -> b.length() - a.length());
        for (Path scopePath : sortedScopePaths) {
            Map scope = (Map)scopes.get(scopePath);
            Path parentPath = scopePath.parent();
            LinkedHashMap<String, AbstractConfigValue> parent = parentPath != null ? (Map)scopes.get(parentPath) : root;
            SimpleConfigObject o = new SimpleConfigObject(origin, scope, ResolveStatus.RESOLVED, false);
            parent.put(scopePath.last(), o);
        }
        return new SimpleConfigObject(origin, root, ResolveStatus.RESOLVED, false);
    }
}

