/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.llm.model;

import java.io.IOException;
import java.util.List;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.format.json.RowToJsonConverters;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.seatunnel.transform.llm.model.Model;

public abstract class AbstractModel
implements Model {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final RowToJsonConverters.RowToJsonConverter rowToJsonConverters;
    private final String prompt;
    private final SqlType outputType;

    public AbstractModel(SeaTunnelRowType rowType, SqlType outputType, String prompt) {
        this.prompt = prompt;
        this.outputType = outputType;
        this.rowToJsonConverters = new RowToJsonConverters().createConverter((SeaTunnelDataType<?>)rowType, null);
    }

    private String getPromptWithLimit() {
        return this.prompt + "\n The following rules need to be followed: \n 1. The received data is an array, and the result is returned in the form of an array.\n 2. Only the result needs to be returned, and no other information can be returned.\n 3. The element type of the array is " + this.outputType.toString() + ".\n Eg: [\"value1\", \"value2\"]";
    }

    @Override
    public List<String> inference(List<SeaTunnelRow> rows) throws IOException {
        ArrayNode rowsNode = OBJECT_MAPPER.createArrayNode();
        for (SeaTunnelRow row : rows) {
            ObjectNode rowNode = OBJECT_MAPPER.createObjectNode();
            this.rowToJsonConverters.convert(OBJECT_MAPPER, (JsonNode)rowNode, row);
            rowsNode.add((JsonNode)rowNode);
        }
        return this.chatWithModel(this.getPromptWithLimit(), OBJECT_MAPPER.writeValueAsString((Object)rowsNode));
    }

    protected abstract List<String> chatWithModel(String var1, String var2) throws IOException;
}

