/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.ccache;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.KrbInputStream;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.ad.AuthorizationData;
import org.apache.kerby.kerberos.kerb.type.ad.AuthorizationDataEntry;
import org.apache.kerby.kerberos.kerb.type.ad.AuthorizationType;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.HostAddrType;
import org.apache.kerby.kerberos.kerb.type.base.HostAddress;
import org.apache.kerby.kerberos.kerb.type.base.HostAddresses;
import org.apache.kerby.kerberos.kerb.type.base.NameType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.ticket.Ticket;
import org.apache.kerby.kerberos.kerb.type.ticket.TicketFlags;

public class CredCacheInputStream
extends KrbInputStream {
    public CredCacheInputStream(InputStream in) {
        super(in);
    }

    @Override
    public PrincipalName readPrincipal(int version) throws IOException {
        NameType nameType = NameType.NT_UNKNOWN;
        if (version != 1281) {
            int typeValue = this.readInt();
            nameType = NameType.fromValue(typeValue);
        }
        int numComponents = this.readInt();
        if (version == 1281) {
            --numComponents;
        }
        String realm = this.readCountedString();
        ArrayList<String> nameStrings = new ArrayList<String>();
        for (int i = 0; i < numComponents; ++i) {
            String component = this.readCountedString();
            nameStrings.add(component);
        }
        PrincipalName principal = new PrincipalName(nameStrings, nameType);
        principal.setRealm(realm);
        return principal;
    }

    public EncryptionKey readKey(int version) throws IOException {
        if (version == 1283) {
            this.readShort();
        }
        return super.readKey();
    }

    public KerberosTime[] readTimes() throws IOException {
        KerberosTime[] times = new KerberosTime[4];
        for (int i = 0; i < times.length; ++i) {
            times[i] = this.readTime();
        }
        return times;
    }

    public boolean readIsSkey() throws IOException {
        byte value = this.readByte();
        return value == 1;
    }

    public HostAddresses readAddr() throws IOException {
        int numAddresses = this.readInt();
        if (numAddresses <= 0) {
            return null;
        }
        Asn1Type[] addresses = new HostAddress[numAddresses];
        for (int i = 0; i < numAddresses; ++i) {
            addresses[i] = this.readAddress();
        }
        HostAddresses result = new HostAddresses();
        result.addElements(addresses);
        return result;
    }

    public HostAddress readAddress() throws IOException {
        short typeValue = this.readShort();
        HostAddrType addrType = HostAddrType.fromValue(Integer.valueOf(typeValue));
        if (addrType == HostAddrType.NONE) {
            throw new IOException("Invalid host address type");
        }
        byte[] addrData = this.readCountedOctets();
        if (addrData == null) {
            throw new IOException("Invalid host address data");
        }
        HostAddress addr = new HostAddress();
        addr.setAddrType(addrType);
        addr.setAddress(addrData);
        return addr;
    }

    public AuthorizationData readAuthzData() throws IOException {
        int numEntries = this.readInt();
        if (numEntries <= 0) {
            return null;
        }
        Asn1Type[] authzData = new AuthorizationDataEntry[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            authzData[i] = this.readAuthzDataEntry();
        }
        AuthorizationData result = new AuthorizationData();
        result.addElements(authzData);
        return result;
    }

    public AuthorizationDataEntry readAuthzDataEntry() throws IOException {
        short typeValue = this.readShort();
        AuthorizationType authzType = AuthorizationType.fromValue(Integer.valueOf(typeValue));
        if (authzType == AuthorizationType.NONE) {
            throw new IOException("Invalid authorization data type");
        }
        byte[] authzData = this.readCountedOctets();
        if (authzData == null) {
            throw new IOException("Invalid authorization data");
        }
        AuthorizationDataEntry authzEntry = new AuthorizationDataEntry();
        authzEntry.setAuthzType(authzType);
        authzEntry.setAuthzData(authzData);
        return authzEntry;
    }

    @Override
    public int readOctetsCount() throws IOException {
        return this.readInt();
    }

    public TicketFlags readTicketFlags() throws IOException {
        int flags = this.readInt();
        TicketFlags tktFlags = new TicketFlags(flags);
        return tktFlags;
    }

    public Ticket readTicket() throws IOException {
        byte[] ticketData = this.readCountedOctets();
        if (ticketData == null) {
            return null;
        }
        Ticket ticket = new Ticket();
        ticket.decode(ticketData);
        return ticket;
    }
}

