/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.record;

import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.record.ComponentReader;
import com.hazelcast.internal.serialization.impl.compact.record.ComponentWriter;
import com.hazelcast.internal.serialization.impl.compact.record.JavaRecordReader;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.compact.CompactReader;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class JavaRecordSerializer
implements CompactSerializer<Object> {
    private final Method isRecordMethod;
    private final Method getRecordComponentsMethod;
    private final Method getTypeMethod;
    private final Method getNameMethod;
    private final Map<Class<?>, JavaRecordReader> readersCache = new ConcurrentHashMap();
    private final Map<Class<?>, ComponentWriter[]> writersCache = new ConcurrentHashMap();

    public JavaRecordSerializer() {
        Method getNameMethod;
        Method getTypeMethod;
        Method getRecordComponentsMethod;
        Method isRecordMethod;
        try {
            isRecordMethod = Class.class.getMethod("isRecord", new Class[0]);
            getRecordComponentsMethod = Class.class.getMethod("getRecordComponents", new Class[0]);
            Class<?> recordComponentClass = Class.forName("java.lang.reflect.RecordComponent");
            getTypeMethod = recordComponentClass.getMethod("getType", new Class[0]);
            getNameMethod = recordComponentClass.getMethod("getName", new Class[0]);
        }
        catch (Throwable t) {
            isRecordMethod = null;
            getRecordComponentsMethod = null;
            getTypeMethod = null;
            getNameMethod = null;
        }
        this.isRecordMethod = isRecordMethod;
        this.getRecordComponentsMethod = getRecordComponentsMethod;
        this.getTypeMethod = getTypeMethod;
        this.getNameMethod = getNameMethod;
    }

    public boolean isRecord(Class<?> clazz) {
        if (this.isRecordMethod == null) {
            return false;
        }
        try {
            return (Boolean)this.isRecordMethod.invoke(clazz, new Object[0]);
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    @Nonnull
    public Object read(@Nonnull CompactReader reader) {
        DefaultCompactReader compactReader = (DefaultCompactReader)reader;
        Class associatedClass = Objects.requireNonNull(compactReader.getAssociatedClass(), "AssociatedClass is required for JavaRecordSerializer");
        JavaRecordReader recordReader = this.readersCache.get(associatedClass);
        if (recordReader == null) {
            this.populateReadersWriters(associatedClass);
            recordReader = this.readersCache.get(associatedClass);
        }
        return recordReader.readRecord(compactReader, compactReader.getSchema());
    }

    @Override
    public void write(@Nonnull CompactWriter compactWriter, @Nonnull Object object) {
        Class<?> clazz = object.getClass();
        ComponentWriter[] componentWriters = this.writersCache.get(clazz);
        if (componentWriters == null) {
            this.populateReadersWriters(clazz);
            componentWriters = this.writersCache.get(clazz);
        }
        try {
            for (ComponentWriter componentWriter : componentWriters) {
                componentWriter.writeComponent(compactWriter, object);
            }
        }
        catch (Exception e) {
            throw new HazelcastSerializationException("Failed to write the Java record", e);
        }
    }

    private void populateReadersWriters(Class<?> clazz) {
        try {
            Object[] recordComponents = (Object[])this.getRecordComponentsMethod.invoke(clazz, new Object[0]);
            Class[] componentTypes = new Class[recordComponents.length];
            ComponentReader[] componentReaders = new ComponentReader[recordComponents.length];
            ComponentWriter[] componentWriters = new ComponentWriter[recordComponents.length];
            for (int i = 0; i < recordComponents.length; ++i) {
                Object recordComponent = recordComponents[i];
                Class type = (Class)this.getTypeMethod.invoke(recordComponent, new Object[0]);
                String name = (String)this.getNameMethod.invoke(recordComponent, new Object[0]);
                componentTypes[i] = type;
                Method componentGetter = clazz.getDeclaredMethod(name, new Class[0]);
                componentGetter.setAccessible(true);
                if (Byte.TYPE.equals(type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.INT8, FieldKind.NULLABLE_INT8)) {
                            return (byte)0;
                        }
                        return compactReader.readInt8(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeInt8(name, (Byte)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (Byte.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.NULLABLE_INT8, FieldKind.INT8)) {
                            return null;
                        }
                        return compactReader.readNullableInt8(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeNullableInt8(name, (Byte)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (Character.TYPE.equals(type)) {
                    this.throwUnsupportedFieldTypeException("char");
                    continue;
                }
                if (Character.class.equals((Object)type)) {
                    this.throwUnsupportedFieldTypeException("Character");
                    continue;
                }
                if (Short.TYPE.equals(type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.INT16, FieldKind.NULLABLE_INT16)) {
                            return (short)0;
                        }
                        return compactReader.readInt16(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeInt16(name, (Short)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (Short.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.NULLABLE_INT16, FieldKind.INT16)) {
                            return null;
                        }
                        return compactReader.readNullableInt16(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeNullableInt16(name, (Short)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (Integer.TYPE.equals(type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.INT32, FieldKind.NULLABLE_INT32)) {
                            return 0;
                        }
                        return compactReader.readInt32(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeInt32(name, (Integer)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (Integer.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.NULLABLE_INT32, FieldKind.INT32)) {
                            return null;
                        }
                        return compactReader.readNullableInt32(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeNullableInt32(name, (Integer)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (Long.TYPE.equals(type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.INT64, FieldKind.NULLABLE_INT64)) {
                            return 0L;
                        }
                        return compactReader.readInt64(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeInt64(name, (Long)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (Long.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.NULLABLE_INT64, FieldKind.INT64)) {
                            return null;
                        }
                        return compactReader.readNullableInt64(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeNullableInt64(name, (Long)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (Float.TYPE.equals(type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.FLOAT32, FieldKind.NULLABLE_FLOAT32)) {
                            return Float.valueOf(0.0f);
                        }
                        return Float.valueOf(compactReader.readFloat32(name));
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeFloat32(name, ((Float)componentGetter.invoke(object, new Object[0])).floatValue());
                    continue;
                }
                if (Float.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.NULLABLE_FLOAT32, FieldKind.FLOAT32)) {
                            return null;
                        }
                        return compactReader.readNullableFloat32(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeNullableFloat32(name, (Float)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (Double.TYPE.equals(type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.FLOAT64, FieldKind.NULLABLE_FLOAT64)) {
                            return 0.0;
                        }
                        return compactReader.readFloat64(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeFloat64(name, (Double)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (Double.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.NULLABLE_FLOAT64, FieldKind.FLOAT64)) {
                            return null;
                        }
                        return compactReader.readNullableFloat64(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeNullableFloat64(name, (Double)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (Boolean.TYPE.equals(type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.BOOLEAN, FieldKind.NULLABLE_BOOLEAN)) {
                            return false;
                        }
                        return compactReader.readBoolean(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeBoolean(name, (Boolean)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (Boolean.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.NULLABLE_BOOLEAN, FieldKind.BOOLEAN)) {
                            return null;
                        }
                        return compactReader.readNullableBoolean(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeNullableBoolean(name, (Boolean)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (String.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.STRING)) {
                            return null;
                        }
                        return compactReader.readString(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeString(name, (String)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (BigDecimal.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.DECIMAL)) {
                            return null;
                        }
                        return compactReader.readDecimal(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeDecimal(name, (BigDecimal)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (LocalTime.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.TIME)) {
                            return null;
                        }
                        return compactReader.readTime(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeTime(name, (LocalTime)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (LocalDate.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.DATE)) {
                            return null;
                        }
                        return compactReader.readDate(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeDate(name, (LocalDate)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (LocalDateTime.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.TIMESTAMP)) {
                            return null;
                        }
                        return compactReader.readTimestamp(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeTimestamp(name, (LocalDateTime)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (OffsetDateTime.class.equals((Object)type)) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.TIMESTAMP_WITH_TIMEZONE)) {
                            return null;
                        }
                        return compactReader.readTimestampWithTimezone(name);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeTimestampWithTimezone(name, (OffsetDateTime)componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                if (type.isEnum()) {
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.STRING)) {
                            return null;
                        }
                        String enumName = compactReader.readString(name, null);
                        return enumName == null ? null : Enum.valueOf(type, enumName);
                    };
                    componentWriters[i] = (compactWriter, object) -> {
                        Object rawValue = componentGetter.invoke(object, new Object[0]);
                        String value = rawValue == null ? null : ((Enum)rawValue).name();
                        compactWriter.writeString(name, value);
                    };
                    continue;
                }
                if (type.isArray()) {
                    Class<?> componentType = type.getComponentType();
                    if (Byte.TYPE.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_INT8, FieldKind.ARRAY_OF_NULLABLE_INT8)) {
                                return null;
                            }
                            return compactReader.readArrayOfInt8(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfInt8(name, (byte[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Byte.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_NULLABLE_INT8, FieldKind.ARRAY_OF_INT8)) {
                                return null;
                            }
                            return compactReader.readArrayOfNullableInt8(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfNullableInt8(name, (Byte[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Character.TYPE.equals(componentType)) {
                        this.throwUnsupportedFieldTypeException("char[]");
                        continue;
                    }
                    if (Character.class.equals(componentType)) {
                        this.throwUnsupportedFieldTypeException("Character[]");
                        continue;
                    }
                    if (Short.TYPE.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_INT16, FieldKind.ARRAY_OF_NULLABLE_INT16)) {
                                return null;
                            }
                            return compactReader.readArrayOfInt16(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfInt16(name, (short[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Short.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_NULLABLE_INT16, FieldKind.ARRAY_OF_INT16)) {
                                return null;
                            }
                            return compactReader.readArrayOfNullableInt16(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfNullableInt16(name, (Short[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Integer.TYPE.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_INT32, FieldKind.ARRAY_OF_NULLABLE_INT32)) {
                                return null;
                            }
                            return compactReader.readArrayOfInt32(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfInt32(name, (int[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Integer.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_NULLABLE_INT32, FieldKind.ARRAY_OF_INT32)) {
                                return null;
                            }
                            return compactReader.readArrayOfNullableInt32(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfNullableInt32(name, (Integer[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Long.TYPE.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_INT64, FieldKind.ARRAY_OF_NULLABLE_INT64)) {
                                return null;
                            }
                            return compactReader.readArrayOfInt64(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfInt64(name, (long[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Long.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_NULLABLE_INT64, FieldKind.ARRAY_OF_INT64)) {
                                return null;
                            }
                            return compactReader.readArrayOfNullableInt64(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfNullableInt64(name, (Long[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Float.TYPE.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_FLOAT32, FieldKind.ARRAY_OF_NULLABLE_FLOAT32)) {
                                return null;
                            }
                            return compactReader.readArrayOfFloat32(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfFloat32(name, (float[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Float.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_NULLABLE_FLOAT32, FieldKind.ARRAY_OF_FLOAT32)) {
                                return null;
                            }
                            return compactReader.readArrayOfNullableFloat32(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfNullableFloat32(name, (Float[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Double.TYPE.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_FLOAT64, FieldKind.ARRAY_OF_NULLABLE_FLOAT64)) {
                                return null;
                            }
                            return compactReader.readArrayOfFloat64(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfFloat64(name, (double[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Double.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_NULLABLE_FLOAT64, FieldKind.ARRAY_OF_FLOAT64)) {
                                return null;
                            }
                            return compactReader.readArrayOfNullableFloat64(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfNullableFloat64(name, (Double[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Boolean.TYPE.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_BOOLEAN, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN)) {
                                return null;
                            }
                            return compactReader.readArrayOfBoolean(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfBoolean(name, (boolean[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (Boolean.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN, FieldKind.ARRAY_OF_BOOLEAN)) {
                                return null;
                            }
                            return compactReader.readArrayOfNullableBoolean(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfNullableBoolean(name, (Boolean[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (String.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_STRING)) {
                                return null;
                            }
                            return compactReader.readArrayOfString(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfString(name, (String[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (BigDecimal.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_DECIMAL)) {
                                return null;
                            }
                            return compactReader.readArrayOfDecimal(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfDecimal(name, (BigDecimal[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (LocalTime.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_TIME)) {
                                return null;
                            }
                            return compactReader.readArrayOfTime(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfTime(name, (LocalTime[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (LocalDate.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_DATE)) {
                                return null;
                            }
                            return compactReader.readArrayOfDate(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfDate(name, (LocalDate[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (LocalDateTime.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_TIMESTAMP)) {
                                return null;
                            }
                            return compactReader.readArrayOfTimestamp(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfTimestamp(name, (LocalDateTime[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (OffsetDateTime.class.equals(componentType)) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_TIMESTAMP_WITH_TIMEZONE)) {
                                return null;
                            }
                            return compactReader.readArrayOfTimestampWithTimezone(name);
                        };
                        componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfTimestampWithTimezone(name, (OffsetDateTime[])componentGetter.invoke(object, new Object[0]));
                        continue;
                    }
                    if (componentType.isEnum()) {
                        componentReaders[i] = (compactReader, schema) -> {
                            if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_STRING)) {
                                return null;
                            }
                            String[] enumNames = compactReader.readArrayOfString(name);
                            if (enumNames == null) {
                                return null;
                            }
                            Class enumType = componentType;
                            Enum[] enums = (Enum[])Array.newInstance(enumType, enumNames.length);
                            for (int j = 0; j < enumNames.length; ++j) {
                                String enumName = enumNames[j];
                                enums[j] = enumName == null ? null : Enum.valueOf(enumType, enumName);
                            }
                            return enums;
                        };
                        componentWriters[i] = (compactWriter, object) -> {
                            Enum[] enums = (Enum[])componentGetter.invoke(object, new Object[0]);
                            String[] enumNames = null;
                            if (enums != null) {
                                enumNames = new String[enums.length];
                                for (int j = 0; j < enums.length; ++j) {
                                    Enum e = enums[j];
                                    enumNames[j] = e == null ? null : e.name();
                                }
                            }
                            compactWriter.writeArrayOfString(name, enumNames);
                        };
                        continue;
                    }
                    componentReaders[i] = (compactReader, schema) -> {
                        if (!this.isFieldExist(schema, name, FieldKind.ARRAY_OF_COMPACT)) {
                            return null;
                        }
                        return compactReader.readArrayOfCompact(name, componentType);
                    };
                    componentWriters[i] = (compactWriter, object) -> compactWriter.writeArrayOfCompact(name, (Object[])componentGetter.invoke(object, new Object[0]));
                    continue;
                }
                componentReaders[i] = (compactReader, schema) -> {
                    if (!this.isFieldExist(schema, name, FieldKind.COMPACT)) {
                        return null;
                    }
                    return compactReader.readCompact(name);
                };
                componentWriters[i] = (compactWriter, object) -> compactWriter.writeCompact(name, componentGetter.invoke(object, new Object[0]));
            }
            Constructor<?> constructor = clazz.getDeclaredConstructor(componentTypes);
            constructor.setAccessible(true);
            JavaRecordReader recordReader = new JavaRecordReader(constructor, componentReaders);
            this.readersCache.put(clazz, recordReader);
            this.writersCache.put(clazz, componentWriters);
        }
        catch (Exception e) {
            throw new HazelcastSerializationException("Failed to construct the readers/writers for the Java record", e);
        }
    }

    private boolean isFieldExist(Schema schema, String fieldName, FieldKind expectedFieldKind) {
        FieldDescriptor field2 = schema.getField(fieldName);
        if (field2 == null) {
            return false;
        }
        return field2.getKind() == expectedFieldKind;
    }

    private boolean isFieldExist(Schema schema, String fieldName, FieldKind expectedFieldKind, FieldKind compatibleFieldKind) {
        FieldDescriptor field2 = schema.getField(fieldName);
        if (field2 == null) {
            return false;
        }
        return field2.getKind() == expectedFieldKind || field2.getKind() == compatibleFieldKind;
    }

    private void throwUnsupportedFieldTypeException(String typeName) {
        throw new HazelcastSerializationException("Compact serialization format does not support fields of type '" + typeName + "'. If you want to use such fields with the compact serialization format, consider adding an explicit serializer for it.");
    }
}

