/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.schema;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.SchemaService;
import com.hazelcast.internal.serialization.impl.compact.schema.FetchSchemaOperation;
import com.hazelcast.internal.serialization.impl.compact.schema.SendAllSchemasOperation;
import com.hazelcast.internal.serialization.impl.compact.schema.SendSchemaOperation;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.PreJoinAwareService;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class MemberSchemaService
implements ManagedService,
PreJoinAwareService,
SchemaService {
    private static final int MAX_RETRIES = 100;
    private final Map<Long, Schema> schemas = new ConcurrentHashMap<Long, Schema>();
    private ILogger logger;
    private NodeEngine nodeEngine;

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.logger = nodeEngine.getLogger(SchemaService.class);
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        this.schemas.clear();
    }

    @Override
    public Operation getPreJoinOperation() {
        if (this.schemas.size() == 0) {
            return null;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Preparing prejoin operation with schemas " + this.schemas);
        }
        return new SendAllSchemasOperation(new ArrayList<Schema>(this.schemas.values()));
    }

    @Override
    public Schema get(long schemaId) {
        return this.getAsync(schemaId).join();
    }

    public CompletableFuture<Schema> getAsync(long schemaId) {
        if (!this.nodeEngine.getClusterService().getClusterVersion().isEqualTo(Versions.V5_1)) {
            throw new UnsupportedOperationException("The BETA compact format can only be used with 5.1 cluster");
        }
        Schema schema = this.getLocal(schemaId);
        if (schema != null) {
            return CompletableFuture.completedFuture(schema);
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Could not find schema id  " + schemaId + " locally, will search on the cluster" + schemaId);
        }
        ClusterService cluster = this.nodeEngine.getClusterService();
        OperationService operationService = this.nodeEngine.getOperationService();
        Set<Member> members = cluster.getMembers();
        Iterator<Member> iterator = members.iterator();
        return this.searchClusterAsync(schemaId, iterator, operationService);
    }

    private CompletableFuture<Schema> searchClusterAsync(long schemaId, Iterator<Member> iterator, OperationService operationService) {
        if (!iterator.hasNext()) {
            return CompletableFuture.completedFuture(null);
        }
        Address address = iterator.next().getAddress();
        FetchSchemaOperation op = new FetchSchemaOperation(schemaId);
        InvocationFuture future = operationService.invokeOnTarget("schema-service", op, address);
        return ((InternalCompletableFuture)future.handle((data, throwable) -> {
            if (throwable != null) {
                return throwable;
            }
            return data;
        })).thenCompose(o -> {
            if (o instanceof Throwable || o == null) {
                return this.searchClusterAsync(schemaId, iterator, operationService);
            }
            Schema retrievedSchema = (Schema)o;
            this.putLocal(retrievedSchema);
            return CompletableFuture.completedFuture(this.getLocal(schemaId));
        });
    }

    public Schema getLocal(long schemaId) {
        return this.schemas.get(schemaId);
    }

    @Override
    public void put(Schema schema) {
        this.putAsync(schema).join();
    }

    public CompletableFuture<Void> putAsync(Schema schema) {
        if (!this.nodeEngine.getClusterService().getClusterVersion().isEqualTo(Versions.V5_1)) {
            throw new UnsupportedOperationException("The BETA compact format can only be used with 5.1 cluster");
        }
        long schemaId = schema.getSchemaId();
        if (this.getLocal(schemaId) != null) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Sending schema  " + schema + "  to the cluster");
        }
        return InvocationUtil.invokeOnStableClusterSerial(this.nodeEngine, () -> new SendSchemaOperation(schema), 100).thenRun(() -> this.putIfAbsent(schema));
    }

    @Nonnull
    public CompletableFuture<Void> putAllAsync(List<Schema> parameters) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(parameters.size());
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Putting schemas to the cluster" + parameters);
        }
        for (Schema schema : parameters) {
            futures.add(this.putAsync(schema));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    @Override
    public void putLocal(Schema schema) {
        this.putIfAbsent(schema);
    }

    public boolean putIfAbsent(Schema schema) {
        long schemaId = schema.getSchemaId();
        Schema existingSchema = this.schemas.putIfAbsent(schemaId, schema);
        if (existingSchema == null) {
            return true;
        }
        if (!schema.equals(existingSchema)) {
            throw new IllegalStateException("Schema with schemaId " + schemaId + " already exists. Existing schema " + existingSchema + "new schema " + schema);
        }
        return false;
    }
}

