/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import java.util.concurrent.TimeUnit;

public final class TimeUtil {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;

    private TimeUtil() {
    }

    public static long convertNanosToMillis(long nanos) {
        return TimeUtil.timeInMsOrOneIfResultIsZero(nanos, TimeUnit.NANOSECONDS);
    }

    public static long convertMillisToNanos(long millis) {
        return TimeUnit.MILLISECONDS.toNanos(millis);
    }

    public static long timeInMsOrOneIfResultIsZero(long time, TimeUnit timeUnit) {
        long timeInMillis = timeUnit.toMillis(time);
        if (time > 0L && timeInMillis == 0L) {
            timeInMillis = 1L;
        }
        return timeInMillis;
    }

    public static long timeInMsOrTimeIfNullUnit(long time, TimeUnit timeUnit) {
        return timeUnit != null ? timeUnit.toMillis(time) : time;
    }

    public static long zeroOutMs(long timestamp) {
        return TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(timestamp));
    }

    public static String toHumanReadableMillis(long givenMillis) {
        long time = givenMillis;
        long millis = time % 1000L;
        long seconds = (time /= 1000L) % 60L;
        long minutes = (time /= 60L) % 60L;
        long hours = (time /= 60L) % 24L;
        long days = time /= 24L;
        return String.format("%02dd %02dh %02dm %02ds %02dms", days, hours, minutes, seconds, millis);
    }
}

