/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.accumulator;

import com.hazelcast.jet.accumulator.DoubleAccumulator;
import com.hazelcast.jet.accumulator.LinTrendAccumulator;
import com.hazelcast.jet.accumulator.LongAccumulator;
import com.hazelcast.jet.accumulator.LongDoubleAccumulator;
import com.hazelcast.jet.accumulator.LongLongAccumulator;
import com.hazelcast.jet.accumulator.MutableReference;
import com.hazelcast.jet.accumulator.PickAnyAccumulator;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.math.BigInteger;
import javax.annotation.Nonnull;

final class AccumulatorSerializerHooks {
    private AccumulatorSerializerHooks() {
    }

    public static final class PickAnyAccHook
    implements SerializerHook<PickAnyAccumulator> {
        @Override
        public Class<PickAnyAccumulator> getSerializationType() {
            return PickAnyAccumulator.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<PickAnyAccumulator>(){

                @Override
                public int getTypeId() {
                    return -309;
                }

                @Override
                public void write(@Nonnull ObjectDataOutput out, @Nonnull PickAnyAccumulator acc2) throws IOException {
                    out.writeObject(acc2.get());
                    out.writeLong(acc2.count());
                }

                @Override
                @Nonnull
                public PickAnyAccumulator read(@Nonnull ObjectDataInput in) throws IOException {
                    return new PickAnyAccumulator(in.readObject(), in.readLong());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class LongDoubleAccHook
    implements SerializerHook<LongDoubleAccumulator> {
        @Override
        public Class<LongDoubleAccumulator> getSerializationType() {
            return LongDoubleAccumulator.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<LongDoubleAccumulator>(){

                @Override
                public int getTypeId() {
                    return -308;
                }

                @Override
                public void write(@Nonnull ObjectDataOutput out, @Nonnull LongDoubleAccumulator object) throws IOException {
                    out.writeLong(object.getLong());
                    out.writeDouble(object.getDouble());
                }

                @Override
                @Nonnull
                public LongDoubleAccumulator read(@Nonnull ObjectDataInput in) throws IOException {
                    return new LongDoubleAccumulator(in.readLong(), in.readDouble());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class LongLongAccHook
    implements SerializerHook<LongLongAccumulator> {
        @Override
        public Class<LongLongAccumulator> getSerializationType() {
            return LongLongAccumulator.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<LongLongAccumulator>(){

                @Override
                public int getTypeId() {
                    return -307;
                }

                @Override
                public void write(@Nonnull ObjectDataOutput out, @Nonnull LongLongAccumulator object) throws IOException {
                    out.writeLong(object.get1());
                    out.writeLong(object.get2());
                }

                @Override
                @Nonnull
                public LongLongAccumulator read(@Nonnull ObjectDataInput in) throws IOException {
                    return new LongLongAccumulator(in.readLong(), in.readLong());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class LinTrendAccHook
    implements SerializerHook<LinTrendAccumulator> {
        @Override
        public Class<LinTrendAccumulator> getSerializationType() {
            return LinTrendAccumulator.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<LinTrendAccumulator>(){

                @Override
                public int getTypeId() {
                    return -306;
                }

                @Override
                public void write(@Nonnull ObjectDataOutput out, @Nonnull LinTrendAccumulator object) throws IOException {
                    object.writeObject(out);
                }

                @Override
                @Nonnull
                public LinTrendAccumulator read(@Nonnull ObjectDataInput in) throws IOException {
                    return new LinTrendAccumulator(in.readLong(), this.readBigInt(in), this.readBigInt(in), this.readBigInt(in), this.readBigInt(in));
                }

                private BigInteger readBigInt(ObjectDataInput in) throws IOException {
                    byte[] bytes = new byte[in.readUnsignedByte()];
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = in.readByte();
                    }
                    return new BigInteger(bytes);
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class MutableReferenceHook
    implements SerializerHook<MutableReference> {
        @Override
        public Class<MutableReference> getSerializationType() {
            return MutableReference.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<MutableReference>(){

                @Override
                public int getTypeId() {
                    return -305;
                }

                @Override
                public void write(@Nonnull ObjectDataOutput out, @Nonnull MutableReference object) throws IOException {
                    out.writeObject(object.get());
                }

                @Override
                @Nonnull
                public MutableReference read(@Nonnull ObjectDataInput in) throws IOException {
                    return new MutableReference(in.readObject());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class DoubleAccHook
    implements SerializerHook<DoubleAccumulator> {
        @Override
        public Class<DoubleAccumulator> getSerializationType() {
            return DoubleAccumulator.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<DoubleAccumulator>(){

                @Override
                public int getTypeId() {
                    return -304;
                }

                @Override
                public void write(@Nonnull ObjectDataOutput out, @Nonnull DoubleAccumulator object) throws IOException {
                    out.writeDouble(object.export());
                }

                @Override
                @Nonnull
                public DoubleAccumulator read(@Nonnull ObjectDataInput in) throws IOException {
                    return new DoubleAccumulator(in.readDouble());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class LongAccHook
    implements SerializerHook<LongAccumulator> {
        @Override
        public Class<LongAccumulator> getSerializationType() {
            return LongAccumulator.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<LongAccumulator>(){

                @Override
                public int getTypeId() {
                    return -303;
                }

                @Override
                public void write(@Nonnull ObjectDataOutput out, @Nonnull LongAccumulator object) throws IOException {
                    out.writeLong(object.get());
                }

                @Override
                @Nonnull
                public LongAccumulator read(@Nonnull ObjectDataInput in) throws IOException {
                    return new LongAccumulator(in.readLong());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }
}

