/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.everit.json.schema;

import com.hazelcast.org.everit.json.schema.internal.DateTimeFormatValidator;
import com.hazelcast.org.everit.json.schema.internal.EmailFormatValidator;
import com.hazelcast.org.everit.json.schema.internal.HostnameFormatValidator;
import com.hazelcast.org.everit.json.schema.internal.IPV4Validator;
import com.hazelcast.org.everit.json.schema.internal.IPV6Validator;
import com.hazelcast.org.everit.json.schema.internal.URIFormatValidator;
import java.util.Objects;
import java.util.Optional;

@FunctionalInterface
public interface FormatValidator {
    public static final FormatValidator NONE = subject -> Optional.empty();

    public static FormatValidator forFormat(String formatName) {
        Objects.requireNonNull(formatName, "formatName cannot be null");
        switch (formatName) {
            case "date-time": {
                return new DateTimeFormatValidator();
            }
            case "email": {
                return new EmailFormatValidator();
            }
            case "hostname": {
                return new HostnameFormatValidator();
            }
            case "uri": {
                return new URIFormatValidator();
            }
            case "ipv4": {
                return new IPV4Validator();
            }
            case "ipv6": {
                return new IPV6Validator();
            }
        }
        throw new IllegalArgumentException("unsupported format: " + formatName);
    }

    public Optional<String> validate(String var1);

    default public String formatName() {
        return "unnamed-format";
    }
}

