/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.executor.UnblockableThread;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.WrappableException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressFBWarnings(value={"DLS_DEAD_STORE_OF_CLASS_LITERAL"}, justification="Recommended way to prevent classloading bug")
public abstract class AbstractInvocationFuture<V>
extends InternalCompletableFuture<V> {
    static final Object UNRESOLVED = new Object(){

        public String toString() {
            return "UNRESOLVED";
        }
    };
    private static final AtomicReferenceFieldUpdater<AbstractInvocationFuture, Object> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractInvocationFuture.class, Object.class, "state");
    protected final ILogger logger;
    protected volatile Object state = UNRESOLVED;

    protected AbstractInvocationFuture(@Nonnull ILogger logger) {
        this.logger = logger;
    }

    protected abstract String invocationToString();

    protected abstract V resolveAndThrowIfException(Object var1) throws ExecutionException, InterruptedException;

    protected abstract TimeoutException newTimeoutException(long var1, TimeUnit var3);

    @Override
    public <U> InternalCompletableFuture<U> thenApply(@Nonnull Function<? super V, ? extends U> fn) {
        return this.thenApplyAsync((Function)fn, this.defaultExecutor());
    }

    @Override
    public <U> InternalCompletableFuture<U> thenApplyAsync(@Nonnull Function<? super V, ? extends U> fn) {
        return this.thenApplyAsync((Function)fn, this.defaultExecutor());
    }

    @Override
    public <U> InternalCompletableFuture<U> thenApplyAsync(@Nonnull Function<? super V, ? extends U> fn, Executor executor) {
        Objects.requireNonNull(fn);
        Objects.requireNonNull(executor);
        InternalCompletableFuture future = this.newCompletableFuture();
        if (this.isDone()) {
            this.unblockApply(fn, executor, future);
        } else {
            Object result = this.registerWaiter(new ApplyNode<V, U>(future, fn), executor);
            if (result != UNRESOLVED) {
                this.unblockApply(fn, executor, future);
            }
        }
        return future;
    }

    public InternalCompletableFuture<Void> thenAccept(@Nonnull Consumer<? super V> action) {
        return this.thenAcceptAsync((Consumer)action, this.defaultExecutor());
    }

    public InternalCompletableFuture<Void> thenAcceptAsync(@Nonnull Consumer<? super V> action) {
        return this.thenAcceptAsync((Consumer)action, this.defaultExecutor());
    }

    public InternalCompletableFuture<Void> thenAcceptAsync(@Nonnull Consumer<? super V> action, @Nonnull Executor executor) {
        Objects.requireNonNull(action);
        Objects.requireNonNull(executor);
        InternalCompletableFuture<Void> future = this.newCompletableFuture();
        if (this.isDone()) {
            this.unblockAccept(action, executor, future);
        } else {
            Object result = this.registerWaiter(new AcceptNode<V>(future, action), executor);
            if (result != UNRESOLVED) {
                this.unblockAccept(action, executor, future);
            }
        }
        return future;
    }

    @Override
    public InternalCompletableFuture<Void> thenRun(@Nonnull Runnable action) {
        return this.thenRunAsync(action, this.defaultExecutor());
    }

    @Override
    public InternalCompletableFuture<Void> thenRunAsync(@Nonnull Runnable action) {
        return this.thenRunAsync(action, this.defaultExecutor());
    }

    @Override
    public InternalCompletableFuture<Void> thenRunAsync(@Nonnull Runnable action, @Nonnull Executor executor) {
        Objects.requireNonNull(action);
        Objects.requireNonNull(executor);
        InternalCompletableFuture<Void> future = this.newCompletableFuture();
        if (this.isDone()) {
            this.unblockRun(action, executor, future);
        } else {
            Object result = this.registerWaiter(new RunNode(future, action), executor);
            if (result != UNRESOLVED) {
                this.unblockRun(action, executor, future);
            }
        }
        return future;
    }

    @Override
    public <U> InternalCompletableFuture<U> handle(@Nonnull BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.handleAsync((BiFunction)fn, this.defaultExecutor());
    }

    @Override
    public <U> InternalCompletableFuture<U> handleAsync(@Nonnull BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.handleAsync((BiFunction)fn, this.defaultExecutor());
    }

    @Override
    public <U> InternalCompletableFuture<U> handleAsync(@Nonnull BiFunction<? super V, Throwable, ? extends U> fn, @Nonnull Executor executor) {
        Objects.requireNonNull(fn);
        Objects.requireNonNull(executor);
        InternalCompletableFuture future = this.newCompletableFuture();
        if (this.isDone()) {
            this.unblockHandle(fn, executor, future);
        } else {
            Object result = this.registerWaiter(new HandleNode<V, U>(future, fn), executor);
            if (result != UNRESOLVED) {
                this.unblockHandle(fn, executor, future);
            }
        }
        return future;
    }

    @Override
    public InternalCompletableFuture<V> whenComplete(@Nonnull BiConsumer<? super V, ? super Throwable> action) {
        return this.whenCompleteAsync((BiConsumer)action, this.defaultExecutor());
    }

    @Override
    public InternalCompletableFuture<V> whenCompleteAsync(@Nonnull BiConsumer<? super V, ? super Throwable> action) {
        return this.whenCompleteAsync((BiConsumer)action, this.defaultExecutor());
    }

    @Override
    public InternalCompletableFuture<V> whenCompleteAsync(@Nonnull BiConsumer<? super V, ? super Throwable> action, @Nonnull Executor executor) {
        Objects.requireNonNull(action);
        Objects.requireNonNull(executor);
        InternalCompletableFuture future = this.newCompletableFuture();
        if (this.isDone()) {
            this.unblockWhenComplete(action, executor, future);
        } else {
            Object result = this.registerWaiter(new WhenCompleteNode<V, Throwable>(future, action), executor);
            if (result != UNRESOLVED) {
                this.unblockWhenComplete(action, executor, future);
            }
        }
        return future;
    }

    @Override
    public <U> InternalCompletableFuture<U> thenCompose(@Nonnull Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.thenComposeAsync((Function)fn, this.defaultExecutor());
    }

    @Override
    public <U> InternalCompletableFuture<U> thenComposeAsync(@Nonnull Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.thenComposeAsync((Function)fn, this.defaultExecutor());
    }

    @Override
    public <U> InternalCompletableFuture<U> thenComposeAsync(@Nonnull Function<? super V, ? extends CompletionStage<U>> fn, @Nonnull Executor executor) {
        Objects.requireNonNull(fn);
        Objects.requireNonNull(executor);
        InternalCompletableFuture future = this.newCompletableFuture();
        if (this.isDone()) {
            this.unblockCompose(fn, executor, future);
        } else {
            Object result = this.registerWaiter(new ComposeNode(future, fn), executor);
            if (result != UNRESOLVED) {
                this.unblockCompose(fn, executor, future);
            }
        }
        return future;
    }

    @Override
    public <U, R> InternalCompletableFuture<R> thenCombine(@Nonnull CompletionStage<? extends U> other, @Nonnull BiFunction<? super V, ? super U, ? extends R> fn) {
        return this.thenCombineAsync((CompletionStage)other, (BiFunction)fn, this.defaultExecutor());
    }

    @Override
    public <U, R> InternalCompletableFuture<R> thenCombineAsync(@Nonnull CompletionStage<? extends U> other, @Nonnull BiFunction<? super V, ? super U, ? extends R> fn) {
        return this.thenCombineAsync((CompletionStage)other, (BiFunction)fn, this.defaultExecutor());
    }

    @Override
    public <U, R> InternalCompletableFuture<R> thenCombineAsync(@Nonnull CompletionStage<? extends U> other, @Nonnull BiFunction<? super V, ? super U, ? extends R> fn, @Nonnull Executor executor) {
        Objects.requireNonNull(other);
        Objects.requireNonNull(fn);
        Objects.requireNonNull(executor);
        InternalCompletableFuture future = this.newCompletableFuture();
        if (this.isDone()) {
            this.unblockCombine(other, fn, executor, future);
        } else {
            Object result = this.registerWaiter(new CombineNode<V, U, R>(future, other.toCompletableFuture(), fn), executor);
            if (result != UNRESOLVED) {
                this.unblockCombine(other, fn, executor, future);
            }
        }
        return future;
    }

    public <U> InternalCompletableFuture<Void> thenAcceptBoth(@Nonnull CompletionStage<? extends U> other, @Nonnull BiConsumer<? super V, ? super U> action) {
        return this.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, this.defaultExecutor());
    }

    public <U> InternalCompletableFuture<Void> thenAcceptBothAsync(@Nonnull CompletionStage<? extends U> other, @Nonnull BiConsumer<? super V, ? super U> action) {
        return this.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, this.defaultExecutor());
    }

    public <U> InternalCompletableFuture<Void> thenAcceptBothAsync(@Nonnull CompletionStage<? extends U> other, @Nonnull BiConsumer<? super V, ? super U> action, @Nonnull Executor executor) {
        CompletableFuture<U> otherFuture;
        Objects.requireNonNull(action);
        Objects.requireNonNull(executor);
        InternalCompletableFuture<Void> future = this.newCompletableFuture();
        CompletableFuture<U> completableFuture = otherFuture = other instanceof CompletableFuture ? (CompletableFuture<U>)other : other.toCompletableFuture();
        if (this.isDone()) {
            this.unblockAcceptBoth(otherFuture, action, executor, future);
        } else {
            Object result = this.registerWaiter(new AcceptBothNode<V, U>(future, otherFuture, action), executor);
            if (result != UNRESOLVED) {
                this.unblockAcceptBoth(otherFuture, action, executor, future);
            }
        }
        return future;
    }

    public InternalCompletableFuture<Void> runAfterBoth(@Nonnull CompletionStage<?> other, @Nonnull Runnable action) {
        return this.runAfterBothAsync((CompletionStage)other, action, this.defaultExecutor());
    }

    public InternalCompletableFuture<Void> runAfterBothAsync(@Nonnull CompletionStage<?> other, @Nonnull Runnable action) {
        return this.runAfterBothAsync((CompletionStage)other, action, this.defaultExecutor());
    }

    public InternalCompletableFuture<Void> runAfterBothAsync(@Nonnull CompletionStage<?> other, @Nonnull Runnable action, @Nonnull Executor executor) {
        CompletableFuture<?> otherFuture;
        Objects.requireNonNull(other);
        Objects.requireNonNull(action);
        Objects.requireNonNull(executor);
        InternalCompletableFuture<Void> future = this.newCompletableFuture();
        CompletableFuture<?> completableFuture = otherFuture = other instanceof CompletableFuture ? (CompletableFuture<?>)other : other.toCompletableFuture();
        if (this.isDone()) {
            this.unblockRunAfterBoth(otherFuture, action, executor, future);
        } else {
            Object result = this.registerWaiter(new RunAfterBothNode(future, otherFuture, action), executor);
            if (result != UNRESOLVED) {
                this.unblockRunAfterBoth(otherFuture, action, executor, future);
            }
        }
        return future;
    }

    @Override
    public <U> InternalCompletableFuture<U> applyToEither(@Nonnull CompletionStage<? extends V> other, @Nonnull Function<? super V, U> fn) {
        return this.applyToEitherAsync((CompletionStage)other, (Function)fn, this.defaultExecutor());
    }

    @Override
    public <U> InternalCompletableFuture<U> applyToEitherAsync(@Nonnull CompletionStage<? extends V> other, @Nonnull Function<? super V, U> fn) {
        return this.applyToEitherAsync((CompletionStage)other, (Function)fn, this.defaultExecutor());
    }

    @Override
    public <U> InternalCompletableFuture<U> applyToEitherAsync(@Nonnull CompletionStage<? extends V> other, @Nonnull Function<? super V, U> fn, @Nonnull Executor executor) {
        CompletableFuture<V> otherFuture;
        Objects.requireNonNull(other);
        Objects.requireNonNull(fn);
        Objects.requireNonNull(executor);
        InternalCompletableFuture future = this.newCompletableFuture();
        CompletableFuture<V> completableFuture = otherFuture = other instanceof CompletableFuture ? (CompletableFuture<V>)other : other.toCompletableFuture();
        if (this.isDone()) {
            this.unblockApplyToEither(fn, executor, future);
        } else {
            ApplyEither<V, ? super V> waiter = new ApplyEither<V, V>(future, fn);
            Object result = this.registerWaiter(waiter, executor);
            if (result == UNRESOLVED) {
                otherFuture.whenCompleteAsync(waiter, executor);
                return future;
            }
            this.unblockApplyToEither(fn, executor, future);
        }
        return future;
    }

    public InternalCompletableFuture<Void> acceptEither(@Nonnull CompletionStage<? extends V> other, @Nonnull Consumer<? super V> action) {
        return this.acceptEitherAsync((CompletionStage)other, (Consumer)action, this.defaultExecutor());
    }

    public InternalCompletableFuture<Void> acceptEitherAsync(@Nonnull CompletionStage<? extends V> other, @Nonnull Consumer<? super V> action) {
        return this.acceptEitherAsync((CompletionStage)other, (Consumer)action, this.defaultExecutor());
    }

    public InternalCompletableFuture<Void> acceptEitherAsync(@Nonnull CompletionStage<? extends V> other, @Nonnull Consumer<? super V> action, @Nonnull Executor executor) {
        CompletableFuture<V> otherFuture;
        Objects.requireNonNull(other);
        Objects.requireNonNull(action);
        Objects.requireNonNull(executor);
        InternalCompletableFuture<Void> future = this.newCompletableFuture();
        CompletableFuture<V> completableFuture = otherFuture = other instanceof CompletableFuture ? (CompletableFuture<V>)other : other.toCompletableFuture();
        if (this.isDone()) {
            this.unblockAcceptEither(action, executor, future);
        } else {
            AcceptEither<V> waiter = new AcceptEither<V>(future, action);
            Object result = this.registerWaiter(waiter, executor);
            if (result == UNRESOLVED) {
                otherFuture.whenCompleteAsync(waiter, executor);
                return future;
            }
            this.unblockAcceptEither(action, executor, future);
        }
        return future;
    }

    public InternalCompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherAsync((CompletionStage)other, action, this.defaultExecutor());
    }

    public InternalCompletableFuture<Void> runAfterEitherAsync(@Nonnull CompletionStage<?> other, @Nonnull Runnable action) {
        return this.runAfterEitherAsync((CompletionStage)other, action, this.defaultExecutor());
    }

    public InternalCompletableFuture<Void> runAfterEitherAsync(@Nonnull CompletionStage<?> other, @Nonnull Runnable action, @Nonnull Executor executor) {
        CompletableFuture<?> otherFuture;
        Objects.requireNonNull(other);
        Objects.requireNonNull(action);
        Objects.requireNonNull(executor);
        InternalCompletableFuture<Void> future = this.newCompletableFuture();
        CompletableFuture<?> completableFuture = otherFuture = other instanceof CompletableFuture ? (CompletableFuture<?>)other : other.toCompletableFuture();
        if (this.isDone()) {
            this.unblockRunAfterEither(action, executor, future);
        } else {
            RunAfterEither waiter = new RunAfterEither(future, action);
            Object result = this.registerWaiter(waiter, executor);
            if (result == UNRESOLVED) {
                otherFuture.whenCompleteAsync((BiConsumer)waiter, executor);
                return future;
            }
            this.unblockRunAfterEither(action, executor, future);
        }
        return future;
    }

    @Override
    public InternalCompletableFuture<V> exceptionally(@Nonnull Function<Throwable, ? extends V> fn) {
        Objects.requireNonNull(fn);
        InternalCompletableFuture future = this.newCompletableFuture();
        if (this.isDone()) {
            this.unblockExceptionally(fn, future);
        } else {
            Object result = this.registerWaiter(new ExceptionallyNode<V>(future, fn), null);
            if (result != UNRESOLVED) {
                this.unblockExceptionally(fn, future);
            }
        }
        return future;
    }

    @Override
    public InternalCompletableFuture<V> toCompletableFuture() {
        return this;
    }

    boolean compareAndSetState(Object oldState, Object newState) {
        return STATE_UPDATER.compareAndSet(this, oldState, newState);
    }

    protected final Object getState() {
        return this.state;
    }

    @Override
    public final boolean isDone() {
        return AbstractInvocationFuture.isDone(this.state);
    }

    protected void onInterruptDetected() {
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.completeExceptionally(new CancellationException());
    }

    @Override
    public boolean isCancelled() {
        return AbstractInvocationFuture.isStateCancelled(this.state);
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.state instanceof ExceptionalResult;
    }

    @Override
    public final V join() {
        Object response = this.registerWaiter(Thread.currentThread(), null);
        if (response != UNRESOLVED) {
            return this.resolveAndThrowWithJoinConvention(response);
        }
        boolean interrupted = false;
        try {
            while (true) {
                this.manageParking(0L);
                if (this.isDone()) {
                    V v = this.resolveAndThrowWithJoinConvention(this.state);
                    return v;
                }
                if (!Thread.interrupted()) continue;
                interrupted = true;
                this.onInterruptDetected();
            }
        }
        finally {
            AbstractInvocationFuture.restoreInterrupt(interrupted);
        }
    }

    @Override
    public V joinInternal() {
        Object response = this.registerWaiter(Thread.currentThread(), null);
        if (response != UNRESOLVED) {
            return this.resolveAndThrowForJoinInternal(response);
        }
        boolean interrupted = false;
        try {
            while (true) {
                this.manageParking(0L);
                if (this.isDone()) {
                    V v = this.resolveAndThrowForJoinInternal(this.state);
                    return v;
                }
                if (!Thread.interrupted()) continue;
                interrupted = true;
                this.onInterruptDetected();
            }
        }
        finally {
            AbstractInvocationFuture.restoreInterrupt(interrupted);
        }
    }

    V resolveAndThrowForJoinInternal(Object unresolved) {
        Object resolved = this.resolve(unresolved);
        if (!(resolved instanceof ExceptionalResult)) {
            return (V)resolved;
        }
        throw ExceptionUtil.sneakyThrow(((ExceptionalResult)resolved).wrapForJoinInternal());
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        Object response = this.registerWaiter(Thread.currentThread(), null);
        if (response != UNRESOLVED) {
            return this.resolveAndThrowIfException(response);
        }
        boolean interrupted = false;
        try {
            while (true) {
                this.manageParking(0L);
                if (this.isDone()) {
                    V v = this.resolveAndThrowIfException(this.state);
                    return v;
                }
                if (!Thread.interrupted()) continue;
                interrupted = true;
                this.onInterruptDetected();
            }
        }
        finally {
            AbstractInvocationFuture.restoreInterrupt(interrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object response = this.registerWaiter(Thread.currentThread(), null);
        if (response != UNRESOLVED) {
            return this.resolveAndThrowIfException(response);
        }
        long deadlineNanos = System.nanoTime() + unit.toNanos(timeout);
        boolean interrupted = false;
        try {
            long timeoutNanos = unit.toNanos(timeout);
            while (timeoutNanos > 0L) {
                this.manageParking(timeoutNanos);
                timeoutNanos = deadlineNanos - System.nanoTime();
                if (this.isDone()) {
                    V v = this.resolveAndThrowIfException(this.state);
                    return v;
                }
                if (!Thread.interrupted()) continue;
                interrupted = true;
                this.onInterruptDetected();
            }
        }
        finally {
            AbstractInvocationFuture.restoreInterrupt(interrupted);
        }
        this.unregisterWaiter(Thread.currentThread());
        throw this.newTimeoutException(timeout, unit);
    }

    private void manageParking(long timeoutNanos) {
        try {
            if (ForkJoinTask.inForkJoinPool()) {
                ForkJoinPool.managedBlock(new ManagedBlocker(timeoutNanos));
            } else if (timeoutNanos == 0L) {
                LockSupport.park();
            } else if (timeoutNanos > 0L) {
                LockSupport.parkNanos(timeoutNanos);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public V getNow(V valueIfAbsent) {
        return this.isDone() ? this.join() : valueIfAbsent;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        return this.completeExceptionallyInternal(ex);
    }

    @Override
    public void obtrudeValue(V value) {
        this.obtrude0(value);
    }

    @Override
    public void obtrudeException(Throwable ex) {
        this.obtrude0(AbstractInvocationFuture.wrapThrowable(ex));
    }

    private void obtrude0(Object value) {
        Object oldState;
        while (!this.compareAndSetState(oldState = this.state, value)) {
        }
        this.onComplete();
        this.unblockAll(oldState, this.defaultExecutor());
    }

    @Override
    public int getNumberOfDependents() {
        int dependents = 0;
        Object index = this.state;
        while (index instanceof WaitNode) {
            ++dependents;
            index = ((WaitNode)index).next;
        }
        if (index instanceof Waiter) {
            ++dependents;
        }
        return dependents;
    }

    private void unblockAll(Object waiter, Executor executor) {
        while (waiter != null) {
            if (waiter instanceof Thread) {
                LockSupport.unpark((Thread)waiter);
                return;
            }
            if (waiter.getClass() == WaitNode.class) {
                WaitNode waitNode = (WaitNode)waiter;
                this.unblockAll(waitNode.waiter, waitNode.executor);
                waiter = waitNode.next;
                continue;
            }
            this.unblockOtherNode(waiter, executor);
            return;
        }
    }

    private void unblockAccept(@Nonnull Consumer<? super V> consumer, @Nonnull Executor executor, @Nonnull InternalCompletableFuture<Void> future) {
        Object value = this.resolve(this.state);
        if (AbstractInvocationFuture.cascadeException(value, future)) {
            return;
        }
        try {
            executor.execute(() -> {
                try {
                    consumer.accept((Object)value);
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        }
        catch (RejectedExecutionException e) {
            future.completeExceptionally(this.wrapToInstanceNotActiveException(e));
        }
    }

    protected void unblockOtherNode(Object waiter, Executor executor) {
        if (!(waiter instanceof Waiter)) {
            return;
        }
        Object value = this.resolve(this.state);
        if (waiter instanceof UniWaiter) {
            ((UniWaiter)waiter).execute(executor, value);
        } else if (waiter instanceof BiWaiter) {
            Throwable t = value instanceof ExceptionalResult ? ((ExceptionalResult)value).cause : null;
            value = value instanceof ExceptionalResult ? null : value;
            ((BiWaiter)waiter).execute(executor, value, t);
        } else if (waiter instanceof ExceptionallyNode) {
            ((ExceptionallyNode)waiter).execute(value);
        }
    }

    protected abstract Exception wrapToInstanceNotActiveException(RejectedExecutionException var1);

    protected V returnOrThrowWithJoinConventions(Object resolved) {
        if (!(resolved instanceof ExceptionalResult)) {
            return (V)resolved;
        }
        Throwable cause = ((ExceptionalResult)resolved).cause;
        if (cause instanceof CancellationException) {
            throw (CancellationException)cause;
        }
        if (cause instanceof CompletionException) {
            throw (CompletionException)cause;
        }
        throw new CompletionException(cause);
    }

    protected Object resolve(Object value) {
        return value;
    }

    protected V resolveAndThrowWithJoinConvention(Object state) {
        Object value = this.resolve(state);
        return this.returnOrThrowWithJoinConventions(value);
    }

    protected <U> void unblockApply(@Nonnull Function<? super V, ? extends U> function, @Nonnull Executor executor, @Nonnull InternalCompletableFuture<U> future) {
        Object value = this.resolve(this.state);
        if (AbstractInvocationFuture.cascadeException(value, future)) {
            return;
        }
        try {
            executor.execute(() -> {
                try {
                    Object result = function.apply((Object)value);
                    future.complete(result);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        }
        catch (RejectedExecutionException e) {
            future.completeExceptionally(this.wrapToInstanceNotActiveException(e));
        }
    }

    protected void unblockRun(@Nonnull Runnable runnable, @Nonnull Executor executor, @Nonnull CompletableFuture<Void> future) {
        Object value = this.resolve(this.state);
        if (AbstractInvocationFuture.cascadeException(value, future)) {
            return;
        }
        this.runAfter0(future, runnable, executor);
    }

    protected <U> void unblockHandle(@Nonnull BiFunction<? super V, Throwable, ? extends U> fn, @Nonnull Executor executor, @Nonnull CompletableFuture<U> future) {
        Object value;
        Throwable throwable;
        Object result = this.resolve(this.state);
        if (result instanceof ExceptionalResult) {
            throwable = ((ExceptionalResult)result).getCause();
            value = null;
        } else {
            throwable = null;
            value = result;
        }
        try {
            executor.execute(() -> {
                try {
                    Object r = fn.apply((Object)value, throwable);
                    future.complete(r);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        }
        catch (RejectedExecutionException e) {
            future.completeExceptionally(this.wrapToInstanceNotActiveException(e));
        }
    }

    protected void unblockWhenComplete(@Nonnull BiConsumer<? super V, ? super Throwable> biConsumer, @Nonnull Executor executor, @Nonnull CompletableFuture<V> future) {
        Object value;
        Throwable throwable;
        Object result = this.resolve(this.state);
        if (result instanceof ExceptionalResult) {
            throwable = ((ExceptionalResult)result).cause;
            value = null;
        } else {
            throwable = null;
            value = result;
        }
        try {
            executor.execute(() -> {
                try {
                    biConsumer.accept((Object)value, throwable);
                }
                catch (Throwable t) {
                    AbstractInvocationFuture.completeDependentExceptionally(future, throwable, t);
                    return;
                }
                AbstractInvocationFuture.completeDependent(future, value, throwable);
            });
        }
        catch (RejectedExecutionException e) {
            future.completeExceptionally(this.wrapToInstanceNotActiveException(e));
        }
    }

    private void unblockExceptionally(@Nonnull Function<Throwable, ? extends V> fn, InternalCompletableFuture<V> future) {
        Object result = this.resolve(this.state);
        if (result instanceof ExceptionalResult) {
            Throwable throwable = ((ExceptionalResult)result).cause;
            try {
                V value = fn.apply(throwable);
                future.complete(value);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        } else {
            future.complete(result);
        }
    }

    protected <U> void unblockCompose(@Nonnull Function<? super V, ? extends CompletionStage<U>> function, @Nonnull Executor executor, @Nonnull CompletableFuture<U> future) {
        Object result = this.resolve(this.state);
        if (AbstractInvocationFuture.cascadeException(result, future)) {
            return;
        }
        Object res = result;
        try {
            executor.execute(() -> {
                try {
                    CompletionStage r = (CompletionStage)function.apply((Object)res);
                    r.whenComplete((? super T v, ? super Throwable t) -> {
                        if (t == null) {
                            future.complete(v);
                        } else {
                            future.completeExceptionally((Throwable)t);
                        }
                    });
                }
                catch (Throwable t2) {
                    future.completeExceptionally(t2);
                }
            });
        }
        catch (RejectedExecutionException e) {
            future.completeExceptionally(this.wrapToInstanceNotActiveException(e));
        }
    }

    protected <U, R> void unblockCombine(@Nonnull CompletionStage<? extends U> other, @Nonnull BiFunction<? super V, ? super U, ? extends R> function, @Nonnull Executor executor, @Nonnull InternalCompletableFuture<R> future) {
        CompletableFuture<U> otherFuture;
        Object result = this.resolve(this.state);
        CompletableFuture<U> completableFuture = otherFuture = other instanceof CompletableFuture ? (CompletableFuture<U>)other : other.toCompletableFuture();
        if (AbstractInvocationFuture.cascadeException(result, future)) {
            return;
        }
        Object value = result;
        if (!otherFuture.isDone()) {
            otherFuture.whenCompleteAsync((T v, U t) -> {
                if (t != null) {
                    future.completeExceptionally((Throwable)t);
                }
                try {
                    Object r = function.apply((Object)value, (Object)v);
                    future.complete(r);
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                }
            }, executor);
            return;
        }
        if (otherFuture.isCompletedExceptionally()) {
            otherFuture.whenComplete((T v, U t) -> future.completeExceptionally((Throwable)t));
            return;
        }
        Object otherValue = otherFuture.join();
        try {
            executor.execute(() -> {
                try {
                    Object r = function.apply((Object)value, (Object)otherValue);
                    future.complete(r);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        }
        catch (RejectedExecutionException e) {
            future.completeExceptionally(this.wrapToInstanceNotActiveException(e));
        }
    }

    private <U> void unblockAcceptBoth(@Nonnull CompletableFuture<? extends U> otherFuture, @Nonnull BiConsumer<? super V, ? super U> action, @Nonnull Executor executor, @Nonnull InternalCompletableFuture<Void> future) {
        Object value = this.resolve(this.state);
        if (AbstractInvocationFuture.cascadeException(value, future)) {
            return;
        }
        if (!otherFuture.isDone()) {
            otherFuture.whenCompleteAsync((T u, U t) -> {
                if (t != null) {
                    future.completeExceptionally((Throwable)t);
                }
                try {
                    action.accept((Object)value, (Object)u);
                    future.complete(null);
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                }
            }, executor);
            return;
        }
        if (otherFuture.isCompletedExceptionally()) {
            otherFuture.whenComplete((T v, U t) -> future.completeExceptionally((Throwable)t));
            return;
        }
        Object otherValue = otherFuture.join();
        try {
            executor.execute(() -> {
                try {
                    action.accept((Object)value, (Object)otherValue);
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        }
        catch (RejectedExecutionException e) {
            future.completeExceptionally(this.wrapToInstanceNotActiveException(e));
        }
    }

    private void unblockRunAfterBoth(@Nonnull CompletableFuture<?> otherFuture, @Nonnull Runnable action, @Nonnull Executor executor, @Nonnull CompletableFuture<Void> future) {
        Object result = this.resolve(this.state);
        if (AbstractInvocationFuture.cascadeException(result, future)) {
            return;
        }
        if (!otherFuture.isDone()) {
            otherFuture.whenCompleteAsync((u, t) -> {
                if (t != null) {
                    future.completeExceptionally((Throwable)t);
                }
                try {
                    action.run();
                    future.complete(null);
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                }
            }, executor);
            return;
        }
        if (otherFuture.isCompletedExceptionally()) {
            otherFuture.whenComplete((v, t) -> future.completeExceptionally((Throwable)t));
            return;
        }
        this.runAfter0(future, action, executor);
    }

    protected <U> void unblockApplyToEither(@Nonnull Function<? super V, U> action, @Nonnull Executor executor, @Nonnull CompletableFuture<U> future) {
        Object result = this.resolve(this.state);
        if (AbstractInvocationFuture.cascadeException(result, future)) {
            return;
        }
        this.applyTo0(future, action, executor, result);
    }

    protected void unblockAcceptEither(@Nonnull Consumer<? super V> action, @Nonnull Executor executor, @Nonnull CompletableFuture<Void> future) {
        Object result = this.resolve(this.state);
        if (AbstractInvocationFuture.cascadeException(result, future)) {
            return;
        }
        this.acceptAfter0(future, action, executor, result);
    }

    protected CompletableFuture<Void> unblockRunAfterEither(@Nonnull Runnable action, @Nonnull Executor executor, @Nonnull CompletableFuture<Void> future) {
        Object result = this.resolve(this.state);
        if (AbstractInvocationFuture.cascadeException(result, future)) {
            return future;
        }
        return this.runAfter0(future, action, executor);
    }

    private Object registerWaiter(Object waiter, Executor executor) {
        Object newState;
        Object oldState;
        assert (!(waiter instanceof UnblockableThread)) : "Waiting for response on this thread is illegal";
        WaitNode waitNode = null;
        do {
            if (AbstractInvocationFuture.isDone(oldState = this.state)) {
                return oldState;
            }
            if (oldState == UNRESOLVED && (executor == null || executor == this.defaultExecutor())) {
                newState = waiter;
                continue;
            }
            if (waitNode == null) {
                waitNode = new WaitNode(waiter, executor);
            }
            waitNode.next = oldState;
            newState = waitNode;
        } while (!this.compareAndSetState(oldState, newState));
        return UNRESOLVED;
    }

    void unregisterWaiter(Thread waiter) {
        WaitNode prev = null;
        Object current = this.state;
        while (current != null) {
            Object next;
            Object currentWaiter = current.getClass() == WaitNode.class ? ((WaitNode)current).waiter : current;
            Object object = next = current.getClass() == WaitNode.class ? ((WaitNode)current).next : null;
            if (currentWaiter == waiter) {
                if (prev == null) {
                    Object n = next == null ? UNRESOLVED : next;
                    current = this.compareAndSetState(current, n) ? null : this.state;
                    continue;
                }
                prev.next = next;
                current = null;
                continue;
            }
            prev = current.getClass() == WaitNode.class ? (WaitNode)current : null;
            current = next;
        }
    }

    @Override
    public final boolean complete(Object value) {
        return this.complete0(value);
    }

    public final boolean completeExceptionallyInternal(Object value) {
        return this.complete0(AbstractInvocationFuture.wrapThrowable(value));
    }

    private boolean complete0(Object value) {
        Object oldState;
        do {
            if (!AbstractInvocationFuture.isDone(oldState = this.state)) continue;
            this.warnIfSuspiciousDoubleCompletion(oldState, value);
            return false;
        } while (!this.compareAndSetState(oldState, value));
        this.onComplete();
        this.unblockAll(oldState, this.defaultExecutor());
        return true;
    }

    protected void onComplete() {
        if (this.state instanceof ExceptionalResult) {
            super.completeExceptionally(((ExceptionalResult)this.state).getCause());
        } else {
            super.complete(this.state);
        }
    }

    private void warnIfSuspiciousDoubleCompletion(Object s0, Object s1) {
        if (s0 != s1 && !AbstractInvocationFuture.isStateCancelled(s0) && !AbstractInvocationFuture.isStateCancelled(s1)) {
            this.logger.warning(String.format("Future.complete(Object) on completed future. Request: %s, current value: %s, offered value: %s", this.invocationToString(), s0, s1), new Exception());
        }
    }

    @Override
    public String toString() {
        Object state = this.getState();
        if (AbstractInvocationFuture.isDone(state)) {
            return "InvocationFuture{invocation=" + this.invocationToString() + ", value=" + state + '}';
        }
        return "InvocationFuture{invocation=" + this.invocationToString() + ", done=false}";
    }

    private CompletableFuture<Void> runAfter0(@Nonnull CompletableFuture<Void> result, @Nonnull Runnable action, @Nonnull Executor executor) {
        try {
            executor.execute(() -> {
                try {
                    action.run();
                    result.complete(null);
                }
                catch (Throwable t) {
                    result.completeExceptionally(t);
                }
            });
        }
        catch (RejectedExecutionException e) {
            result.completeExceptionally(this.wrapToInstanceNotActiveException(e));
        }
        return result;
    }

    private CompletableFuture<Void> acceptAfter0(@Nonnull CompletableFuture<Void> result, @Nonnull Consumer<? super V> consumer, @Nonnull Executor executor, V value) {
        try {
            executor.execute(() -> {
                try {
                    consumer.accept((Object)value);
                    result.complete(null);
                }
                catch (Throwable t) {
                    result.completeExceptionally(t);
                }
            });
        }
        catch (RejectedExecutionException e) {
            result.completeExceptionally(this.wrapToInstanceNotActiveException(e));
        }
        return result;
    }

    private <U> CompletableFuture<U> applyTo0(@Nonnull CompletableFuture<U> future, @Nonnull Function<? super V, U> consumer, @Nonnull Executor executor, V value) {
        try {
            executor.execute(() -> {
                try {
                    future.complete(consumer.apply((Object)value));
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        }
        catch (RejectedExecutionException e) {
            future.completeExceptionally(this.wrapToInstanceNotActiveException(e));
        }
        return future;
    }

    <T> InternalCompletableFuture<T> newCompletableFuture() {
        return new InternalCompletableFuture();
    }

    private static boolean cascadeException(Object resolved, CompletableFuture dependent) {
        if (resolved instanceof ExceptionalResult) {
            dependent.completeExceptionally(AbstractInvocationFuture.wrapInCompletionException(((ExceptionalResult)resolved).cause));
            return true;
        }
        return false;
    }

    private static CompletionException wrapInCompletionException(Throwable t) {
        return t instanceof CompletionException ? (CompletionException)t : new CompletionException(t);
    }

    protected static ExceptionalResult wrapThrowable(Object value) {
        if (value instanceof ExceptionalResult) {
            return (ExceptionalResult)value;
        }
        return new ExceptionalResult((Throwable)value);
    }

    private static boolean isStateCancelled(Object state) {
        return state instanceof ExceptionalResult && ((ExceptionalResult)state).cause instanceof CancellationException;
    }

    private static void completeDependentExceptionally(CompletableFuture future, Throwable exceptionFromParent, Throwable exceptionFromAction) {
        assert (exceptionFromParent != null || exceptionFromAction != null);
        if (exceptionFromParent == null) {
            future.completeExceptionally(exceptionFromAction);
        } else {
            future.completeExceptionally(AbstractInvocationFuture.wrapInCompletionException(exceptionFromParent));
        }
    }

    private static <V> void completeDependent(CompletableFuture<V> future, V value, Throwable throwable) {
        if (throwable == null) {
            future.complete(value);
        } else {
            future.completeExceptionally(AbstractInvocationFuture.wrapInCompletionException(throwable));
        }
    }

    private static boolean isDone(Object state) {
        if (state == null) {
            return true;
        }
        return state != UNRESOLVED && !(state instanceof WaitNode) && !(state instanceof Thread) && !(state instanceof ExecutionCallback) && !(state instanceof Waiter);
    }

    private static void restoreInterrupt(boolean interrupted) {
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    static Throwable wrapOrPeel(Throwable cause) {
        if (cause instanceof RuntimeException) {
            return AbstractInvocationFuture.wrapRuntimeException((RuntimeException)cause);
        }
        if ((cause instanceof ExecutionException || cause instanceof InvocationTargetException) && cause.getCause() != null) {
            return AbstractInvocationFuture.wrapOrPeel(cause.getCause());
        }
        if (cause instanceof Error) {
            if (cause instanceof OutOfMemoryError) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)cause);
            }
            return AbstractInvocationFuture.wrapError((Error)cause);
        }
        return new HazelcastException(cause);
    }

    private static RuntimeException wrapRuntimeException(RuntimeException cause) {
        if (cause instanceof WrappableException) {
            return ((WrappableException)((Object)cause)).wrap();
        }
        RuntimeException wrapped = ExceptionUtil.cloneExceptionWithFixedAsyncStackTrace(cause);
        return wrapped == null ? new HazelcastException(cause) : wrapped;
    }

    private static Error wrapError(Error cause) {
        Error result = ExceptionUtil.cloneExceptionWithFixedAsyncStackTrace(cause);
        return result == null ? cause : result;
    }

    static {
        Class<LockSupport> clazz = LockSupport.class;
    }

    private final class ApplyEither<T, R>
    extends AbstractEitherNode<T, R> {
        final Function<T, R> action;

        ApplyEither(CompletableFuture<R> future, Function<T, R> action) {
            super(future);
            this.action = action;
        }

        @Override
        R process(T t) {
            return this.action.apply(t);
        }
    }

    private final class AcceptEither<T>
    extends AbstractEitherNode<T, Void> {
        final Consumer<T> action;

        AcceptEither(CompletableFuture<Void> future, Consumer<T> action) {
            super(future);
            this.action = action;
        }

        @Override
        Void process(T t) {
            this.action.accept(t);
            return null;
        }
    }

    private final class RunAfterEither<T>
    extends AbstractEitherNode<T, Void> {
        final Runnable action;

        RunAfterEither(CompletableFuture<Void> future, Runnable action) {
            super(future);
            this.action = action;
        }

        @Override
        Void process(T t) {
            this.action.run();
            return null;
        }
    }

    protected abstract class AbstractEitherNode<T, R>
    implements UniWaiter,
    BiConsumer<T, Throwable> {
        final CompletableFuture<R> result;
        final AtomicBoolean executed;

        AbstractEitherNode(CompletableFuture<R> future) {
            this.result = future;
            this.executed = new AtomicBoolean();
        }

        @Override
        public void execute(@Nonnull Executor executor, Object resolved) {
            if (!this.executed.compareAndSet(false, true)) {
                return;
            }
            if (AbstractInvocationFuture.cascadeException(resolved, this.result)) {
                return;
            }
            try {
                executor.execute(() -> {
                    try {
                        R r = this.process(resolved);
                        this.result.complete(r);
                    }
                    catch (Throwable t) {
                        this.result.completeExceptionally(t);
                    }
                });
            }
            catch (RejectedExecutionException exception) {
                this.result.completeExceptionally(AbstractInvocationFuture.this.wrapToInstanceNotActiveException(exception));
                throw exception;
            }
        }

        @Override
        public void accept(T t, Throwable throwable) {
            if (!this.executed.compareAndSet(false, true)) {
                return;
            }
            if (throwable != null) {
                this.result.completeExceptionally(throwable);
            }
            try {
                R r = this.process(t);
                this.result.complete(r);
            }
            catch (Throwable e) {
                this.result.completeExceptionally(e);
            }
        }

        abstract R process(T var1);
    }

    private final class RunAfterBothNode<T, U>
    extends AbstractBiNode<T, U, Void> {
        final Runnable action;

        RunAfterBothNode(CompletableFuture<Void> future, CompletableFuture<? extends U> otherFuture, Runnable action) {
            super(future, otherFuture);
            this.action = action;
        }

        @Override
        Void process(T t, U u) {
            this.action.run();
            return null;
        }
    }

    private final class AcceptBothNode<T, U>
    extends AbstractBiNode<T, U, Void> {
        final BiConsumer<? super T, ? super U> action;

        AcceptBothNode(CompletableFuture<Void> future, CompletableFuture<? extends U> otherFuture, BiConsumer<? super T, ? super U> action) {
            super(future, otherFuture);
            this.action = action;
        }

        @Override
        Void process(T t, U u) {
            this.action.accept(t, u);
            return null;
        }
    }

    private final class CombineNode<T, U, R>
    extends AbstractBiNode<T, U, R> {
        final BiFunction<? super T, ? super U, ? extends R> function;

        CombineNode(CompletableFuture<R> future, CompletableFuture<? extends U> otherFuture, BiFunction<? super T, ? super U, ? extends R> function) {
            super(future, otherFuture);
            this.function = function;
        }

        @Override
        R process(T t, U u) {
            return this.function.apply(t, u);
        }
    }

    protected abstract class AbstractBiNode<T, U, R>
    implements UniWaiter {
        final CompletableFuture<R> result;
        final CompletableFuture<? extends U> otherFuture;
        final AtomicBoolean executed;

        AbstractBiNode(CompletableFuture<R> future, CompletableFuture<? extends U> otherFuture) {
            this.result = future;
            this.otherFuture = otherFuture;
            this.executed = new AtomicBoolean();
        }

        @Override
        public void execute(@Nonnull Executor executor, Object resolved) {
            if (AbstractInvocationFuture.cascadeException(resolved, this.result)) {
                return;
            }
            if (!this.otherFuture.isDone()) {
                this.otherFuture.whenCompleteAsync((u, t) -> {
                    if (!this.executed.compareAndSet(false, true)) {
                        return;
                    }
                    if (t != null) {
                        this.result.completeExceptionally((Throwable)t);
                    }
                    try {
                        R r = this.process(resolved, u);
                        this.result.complete(r);
                    }
                    catch (Throwable e) {
                        this.result.completeExceptionally(e);
                    }
                }, executor);
                return;
            }
            if (!this.executed.compareAndSet(false, true)) {
                return;
            }
            if (this.otherFuture.isCompletedExceptionally()) {
                this.otherFuture.exceptionally(t -> {
                    this.result.completeExceptionally((Throwable)t);
                    return null;
                });
                return;
            }
            U otherValue = this.otherFuture.join();
            try {
                executor.execute(() -> {
                    try {
                        R r = this.process(resolved, otherValue);
                        this.result.complete(r);
                    }
                    catch (Throwable t) {
                        this.result.completeExceptionally(t);
                    }
                });
            }
            catch (RejectedExecutionException exception) {
                this.result.completeExceptionally(AbstractInvocationFuture.this.wrapToInstanceNotActiveException(exception));
                throw exception;
            }
        }

        abstract R process(T var1, U var2);
    }

    protected final class ComposeNode<T, U>
    implements UniWaiter {
        final CompletableFuture<U> future;
        final Function<? super T, ? extends CompletionStage<U>> function;

        ComposeNode(CompletableFuture<U> future, Function<? super T, ? extends CompletionStage<U>> function) {
            this.future = future;
            this.function = function;
        }

        @Override
        public void execute(@Nonnull Executor executor, Object resolved) {
            if (AbstractInvocationFuture.cascadeException(resolved, this.future)) {
                return;
            }
            try {
                executor.execute(() -> {
                    try {
                        CompletionStage<U> r = this.function.apply(resolved);
                        r.whenComplete((v, t) -> {
                            if (t == null) {
                                this.future.complete(v);
                            } else {
                                this.future.completeExceptionally((Throwable)t);
                            }
                        });
                    }
                    catch (Throwable t2) {
                        this.future.completeExceptionally(t2);
                    }
                });
            }
            catch (RejectedExecutionException exception) {
                this.future.completeExceptionally(AbstractInvocationFuture.this.wrapToInstanceNotActiveException(exception));
                throw exception;
            }
        }
    }

    protected final class RunNode
    implements UniWaiter {
        final CompletableFuture<Void> future;
        final Runnable runnable;

        RunNode(@Nonnull CompletableFuture<Void> future, Runnable runnable) {
            this.future = future;
            this.runnable = runnable;
        }

        @Override
        public void execute(@Nonnull Executor executor, Object resolved) {
            if (AbstractInvocationFuture.cascadeException(resolved, this.future)) {
                return;
            }
            try {
                executor.execute(() -> {
                    try {
                        this.runnable.run();
                        this.future.complete(null);
                    }
                    catch (Throwable t) {
                        this.future.completeExceptionally(t);
                    }
                });
            }
            catch (RejectedExecutionException exception) {
                this.future.completeExceptionally(AbstractInvocationFuture.this.wrapToInstanceNotActiveException(exception));
                throw exception;
            }
        }
    }

    private final class AcceptNode<T>
    implements UniWaiter {
        final CompletableFuture<Void> future;
        final Consumer<T> consumer;

        AcceptNode(@Nonnull CompletableFuture<Void> future, Consumer<T> consumer) {
            this.future = future;
            this.consumer = consumer;
        }

        @Override
        public void execute(@Nonnull Executor executor, Object value) {
            if (AbstractInvocationFuture.cascadeException(value, this.future)) {
                return;
            }
            try {
                executor.execute(() -> {
                    try {
                        this.consumer.accept(value);
                        this.future.complete(null);
                    }
                    catch (Throwable t) {
                        this.future.completeExceptionally(t);
                    }
                });
            }
            catch (RejectedExecutionException exception) {
                this.future.completeExceptionally(AbstractInvocationFuture.this.wrapToInstanceNotActiveException(exception));
                throw exception;
            }
        }
    }

    private final class WhenCompleteNode<V, T extends Throwable>
    implements BiWaiter<V, T> {
        final CompletableFuture<V> future;
        final BiConsumer<V, T> biConsumer;

        WhenCompleteNode(@Nonnull CompletableFuture<V> future, BiConsumer<V, T> biConsumer) {
            this.future = future;
            this.biConsumer = biConsumer;
        }

        @Override
        public void execute(@Nonnull Executor executor, V value, T throwable) {
            try {
                executor.execute(() -> {
                    try {
                        this.biConsumer.accept(value, throwable);
                    }
                    catch (Throwable t) {
                        AbstractInvocationFuture.completeDependentExceptionally(this.future, throwable, t);
                        return;
                    }
                    this.complete(value, throwable);
                });
            }
            catch (RejectedExecutionException exception) {
                this.future.completeExceptionally(AbstractInvocationFuture.this.wrapToInstanceNotActiveException(exception));
                throw exception;
            }
        }

        private void complete(V value, T throwable) {
            if (throwable == null) {
                this.future.complete(value);
            } else {
                this.future.completeExceptionally((Throwable)throwable);
            }
        }
    }

    private final class HandleNode<V, R>
    implements BiWaiter<V, Throwable> {
        final CompletableFuture<R> future;
        final BiFunction<V, Throwable, R> biFunction;

        HandleNode(CompletableFuture<R> future, BiFunction<V, Throwable, R> biFunction) {
            this.future = future;
            this.biFunction = biFunction;
        }

        @Override
        public void execute(@Nonnull Executor executor, V value, Throwable throwable) {
            try {
                executor.execute(() -> {
                    try {
                        this.future.complete(this.biFunction.apply(value, throwable));
                    }
                    catch (Throwable t) {
                        this.future.completeExceptionally(t);
                    }
                });
            }
            catch (RejectedExecutionException exception) {
                this.future.completeExceptionally(AbstractInvocationFuture.this.wrapToInstanceNotActiveException(exception));
                throw exception;
            }
        }
    }

    protected static final class ExceptionallyNode<R>
    implements Waiter {
        final CompletableFuture<R> future;
        final Function<Throwable, ? extends R> function;

        ExceptionallyNode(CompletableFuture<R> future, Function<Throwable, ? extends R> function) {
            this.future = future;
            this.function = function;
        }

        public void execute(Object resolved) {
            if (resolved instanceof ExceptionalResult) {
                Throwable throwable = ((ExceptionalResult)resolved).cause;
                try {
                    R value = this.function.apply(throwable);
                    this.future.complete(value);
                }
                catch (Throwable t) {
                    this.future.completeExceptionally(t);
                }
            } else {
                this.future.complete(resolved);
            }
        }
    }

    protected final class ApplyNode<V, R>
    implements UniWaiter {
        final CompletableFuture<R> future;
        final Function<V, R> function;

        ApplyNode(CompletableFuture<R> future, Function<V, R> function) {
            this.future = future;
            this.function = function;
        }

        @Override
        public void execute(@Nonnull Executor executor, Object value) {
            if (AbstractInvocationFuture.cascadeException(value, this.future)) {
                return;
            }
            try {
                executor.execute(() -> {
                    try {
                        this.future.complete(this.function.apply(value));
                    }
                    catch (Throwable t) {
                        this.future.completeExceptionally(t);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.future.completeExceptionally(AbstractInvocationFuture.this.wrapToInstanceNotActiveException(e));
                throw e;
            }
        }
    }

    static interface BiWaiter<V, T extends Throwable>
    extends Waiter {
        public void execute(@Nonnull Executor var1, V var2, T var3);
    }

    static interface UniWaiter
    extends Waiter {
        public void execute(@Nonnull Executor var1, Object var2);
    }

    static interface Waiter
    extends CompletableFuture.AsynchronousCompletionTask {
    }

    public static final class ExceptionalResult {
        private final Throwable cause;

        public ExceptionalResult(Throwable cause) {
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Throwable wrapForJoinInternal() {
            return AbstractInvocationFuture.wrapOrPeel(this.cause);
        }

        public String toString() {
            return "ExceptionalResult{cause=" + this.cause + '}';
        }
    }

    static final class WaitNode {
        final Object waiter;
        volatile Object next;
        @Nonnull
        private final Executor executor;

        WaitNode(Object waiter, @Nullable Executor executor) {
            this.waiter = waiter;
            this.executor = executor == null ? ConcurrencyUtil.getDefaultAsyncExecutor() : executor;
        }

        public String toString() {
            return "WaitNode{waiter=" + this.waiter + ", next=" + this.next + ", executor=" + this.executor + '}';
        }
    }

    class ManagedBlocker
    implements ForkJoinPool.ManagedBlocker {
        private final long timeoutNanos;

        ManagedBlocker(long timeoutNanos) {
            this.timeoutNanos = timeoutNanos;
        }

        @Override
        public boolean isReleasable() {
            return Thread.currentThread().isInterrupted() || AbstractInvocationFuture.this.isDone();
        }

        @Override
        public boolean block() throws InterruptedException {
            if (this.isReleasable()) {
                return true;
            }
            if (this.timeoutNanos == 0L) {
                LockSupport.park();
            } else if (this.timeoutNanos > 0L) {
                LockSupport.parkNanos(this.timeoutNanos);
            }
            return this.isReleasable();
        }
    }
}

