/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;

public class VectorType<T>
implements SeaTunnelDataType<T> {
    private static final long serialVersionUID = 2L;
    public static final VectorType<Float> VECTOR_FLOAT_TYPE = new VectorType<Float>(Float.class, SqlType.FLOAT_VECTOR);
    public static final VectorType<Map> VECTOR_SPARSE_FLOAT_TYPE = new VectorType<Map>(Map.class, SqlType.SPARSE_FLOAT_VECTOR);
    public static final VectorType<Byte> VECTOR_BINARY_TYPE = new VectorType<Byte>(Byte.class, SqlType.BINARY_VECTOR);
    public static final VectorType<ByteBuffer> VECTOR_FLOAT16_TYPE = new VectorType<ByteBuffer>(ByteBuffer.class, SqlType.FLOAT16_VECTOR);
    public static final VectorType<ByteBuffer> VECTOR_BFLOAT16_TYPE = new VectorType<ByteBuffer>(ByteBuffer.class, SqlType.BFLOAT16_VECTOR);
    private final Class<T> typeClass;
    private final SqlType sqlType;

    protected VectorType(Class<T> typeClass, SqlType sqlType) {
        this.typeClass = typeClass;
        this.sqlType = sqlType;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VectorType)) {
            return false;
        }
        VectorType that = (VectorType)obj;
        return Objects.equals(this.typeClass, that.typeClass) && Objects.equals((Object)this.sqlType, (Object)that.sqlType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeClass, this.sqlType});
    }

    public String toString() {
        return this.sqlType.toString();
    }
}

