/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config;

import com.hazelcast.config.Config;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelProperties;

public class SeaTunnelConfig {
    private static final ILogger LOGGER = Logger.getLogger(SeaTunnelConfig.class);
    private final EngineConfig engineConfig = new EngineConfig();
    private Config hazelcastConfig = new Config();

    public SeaTunnelConfig() {
        this.hazelcastConfig.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(53326);
        this.hazelcastConfig.getHotRestartPersistenceConfig().setBaseDir(new File(SeaTunnelConfig.seatunnelHome(), "recovery").getAbsoluteFile());
        System.setProperty("hazelcast.compat.classloading.cache.disabled", "true");
    }

    private static String seatunnelHome() {
        return new File(System.getProperty(SeaTunnelProperties.SEATUNNEL_HOME.getName(), SeaTunnelProperties.SEATUNNEL_HOME.getDefaultValue())).getAbsolutePath();
    }

    public Config getHazelcastConfig() {
        return this.hazelcastConfig;
    }

    public void setHazelcastConfig(Config hazelcastConfig) {
        this.hazelcastConfig = hazelcastConfig;
    }

    public EngineConfig getEngineConfig() {
        return this.engineConfig;
    }

    static {
        String value = SeaTunnelConfig.seatunnelHome();
        LOGGER.info("seatunnel.home is " + value);
        System.setProperty(SeaTunnelProperties.SEATUNNEL_HOME.getName(), value);
    }
}

