/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.service.jar;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;

public class ServerConnectorPackageClient {
    private static final ILogger LOGGER = Logger.getLogger(ServerConnectorPackageClient.class);
    private final NodeEngineImpl nodeEngine;
    private final ReadWriteLock readWriteLock;

    public ServerConnectorPackageClient(NodeEngineImpl nodeEngine, SeaTunnelConfig seaTunnelConfig) {
        this.nodeEngine = nodeEngine;
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public Set<URL> getConnectorJarFromLocal(Set<ConnectorJarIdentifier> connectorJarIdentifiers) {
        return connectorJarIdentifiers.stream().map(connectorJarIdentifier -> {
            String connectorJarStoragePath = connectorJarIdentifier.getStoragePath();
            File storageFile = new File(connectorJarStoragePath);
            try {
                if (storageFile.exists()) {
                    return Optional.of(storageFile.toURI().toURL());
                }
                return Optional.empty();
            }
            catch (MalformedURLException e) {
                LOGGER.warning(String.format("Cannot get plugin URL: {%s}", storageFile));
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(optional -> (URL)optional.get()).collect(Collectors.toSet());
    }

    public void storageConnectorJarFile(byte[] connectorJarByteData, ConnectorJarIdentifier connectorJarIdentifier) {
        this.readWriteLock.writeLock().lock();
        this.storageConnectorJarFile(connectorJarByteData, new File(connectorJarIdentifier.getStoragePath()));
        this.readWriteLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void storageConnectorJarFile(byte[] connectorJarByteData, File storageFile) {
        boolean success = false;
        try {
            if (!storageFile.exists()) {
                FileOutputStream fos = new FileOutputStream(storageFile);
                fos.write(connectorJarByteData);
                return;
            } else {
                LOGGER.warning(String.format("File storage for an existing file %s. This may indicate a duplicate download. Ignoring newest download.", storageFile));
            }
            return;
        }
        catch (IOException ioe) {
            try {
                LOGGER.warning(String.format("The connector jar package file %s storage failed.", storageFile));
                if (success) return;
                if (storageFile.delete()) return;
                if (!storageFile.exists()) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                if (storageFile.delete()) throw throwable;
                if (!storageFile.exists()) throw throwable;
                LOGGER.warning(String.format("Could not delete the corrupted connector jar package file %s.", storageFile));
                throw throwable;
            }
            LOGGER.warning(String.format("Could not delete the corrupted connector jar package file %s.", storageFile));
            return;
        }
    }

    public void deleteConnectorJar(ConnectorJarIdentifier connectorJarIdentifier) {
        try {
            File storageLocation = new File(connectorJarIdentifier.getStoragePath());
            this.readWriteLock.writeLock().lock();
            this.deleteConnectorJarInternal(storageLocation);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void deleteConnectorJarInternal(File storageFile) {
        if (!storageFile.delete() && storageFile.exists()) {
            LOGGER.warning(String.format("Failed to delete connector jar file %s", storageFile));
        }
    }
}

