/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import javax.annotation.Nonnull;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonPoint;

public abstract class ProfileFeatureImpl
extends PointCollectionImpl
implements ProfileFeature {
    private LatLonPoint latlonPoint;
    protected double time;

    public ProfileFeatureImpl(String name, CalendarDateUnit timeUnit, String altUnits, double lat, double lon, double time, int nfeatures) {
        super(name, timeUnit, altUnits);
        this.latlonPoint = LatLonPoint.create(lat, lon);
        this.time = time;
        if (nfeatures >= 0) {
            this.getInfo();
            this.info.nfeatures = nfeatures;
        }
    }

    @Override
    @Nonnull
    public LatLonPoint getLatLon() {
        return this.latlonPoint;
    }

    public Object getId() {
        return this.getName();
    }

    @Override
    @Nonnull
    public FeatureType getCollectionFeatureType() {
        return FeatureType.PROFILE;
    }
}

