/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialOperator;

import java.io.Serializable;
import org.apache.sedona.core.spatialOperator.SpatialPredicate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometry;

public class SpatialPredicateEvaluators {
    private SpatialPredicateEvaluators() {
    }

    public static SpatialPredicateEvaluator create(SpatialPredicate predicate) {
        switch (predicate) {
            case CONTAINS: {
                return new ConcreteContainsEvaluator();
            }
            case INTERSECTS: {
                return new ConcreteIntersectsEvaluator();
            }
            case WITHIN: {
                return new ConcreteWithinEvaluator();
            }
            case COVERS: {
                return new ConcreteCoversEvaluator();
            }
            case COVERED_BY: {
                return new ConcreteCoveredByEvaluator();
            }
            case TOUCHES: {
                return new ConcreteTouchesEvaluator();
            }
            case OVERLAPS: {
                return new ConcreteOverlapsEvaluator();
            }
            case CROSSES: {
                return new ConcreteCrossesEvaluator();
            }
            case EQUALS: {
                return new ConcreteEqualsEvaluator();
            }
        }
        throw new IllegalArgumentException("Invalid spatial predicate: " + String.valueOf((Object)predicate));
    }

    private static class ConcreteEqualsEvaluator
    implements EqualsEvaluator {
        private ConcreteEqualsEvaluator() {
        }
    }

    private static class ConcreteCrossesEvaluator
    implements CrossesEvaluator {
        private ConcreteCrossesEvaluator() {
        }
    }

    private static class ConcreteOverlapsEvaluator
    implements OverlapsEvaluator {
        private ConcreteOverlapsEvaluator() {
        }
    }

    private static class ConcreteTouchesEvaluator
    implements TouchesEvaluator {
        private ConcreteTouchesEvaluator() {
        }
    }

    private static class ConcreteCoveredByEvaluator
    implements CoveredByEvaluator {
        private ConcreteCoveredByEvaluator() {
        }
    }

    private static class ConcreteCoversEvaluator
    implements CoversEvaluator {
        private ConcreteCoversEvaluator() {
        }
    }

    private static class ConcreteWithinEvaluator
    implements WithinEvaluator {
        private ConcreteWithinEvaluator() {
        }
    }

    private static class ConcreteIntersectsEvaluator
    implements IntersectsEvaluator {
        private ConcreteIntersectsEvaluator() {
        }
    }

    private static class ConcreteContainsEvaluator
    implements ContainsEvaluator {
        private ConcreteContainsEvaluator() {
        }
    }

    public static interface EqualsEvaluator
    extends SpatialPredicateEvaluator {
        @Override
        default public boolean eval(Geometry left, Geometry right) {
            return left.symDifference(right).isEmpty();
        }

        @Override
        default public boolean eval(PreparedGeometry left, Geometry right) {
            return left.getGeometry().symDifference(right).isEmpty();
        }
    }

    public static interface CrossesEvaluator
    extends SpatialPredicateEvaluator {
        @Override
        default public boolean eval(Geometry left, Geometry right) {
            return left.crosses(right);
        }

        @Override
        default public boolean eval(PreparedGeometry left, Geometry right) {
            return left.crosses(right);
        }
    }

    public static interface OverlapsEvaluator
    extends SpatialPredicateEvaluator {
        @Override
        default public boolean eval(Geometry left, Geometry right) {
            return left.overlaps(right);
        }

        @Override
        default public boolean eval(PreparedGeometry left, Geometry right) {
            return left.overlaps(right);
        }
    }

    public static interface TouchesEvaluator
    extends SpatialPredicateEvaluator {
        @Override
        default public boolean eval(Geometry left, Geometry right) {
            return left.touches(right);
        }

        @Override
        default public boolean eval(PreparedGeometry left, Geometry right) {
            return left.touches(right);
        }
    }

    public static interface CoveredByEvaluator
    extends SpatialPredicateEvaluator {
        @Override
        default public boolean eval(Geometry left, Geometry right) {
            return left.coveredBy(right);
        }

        @Override
        default public boolean eval(PreparedGeometry left, Geometry right) {
            return left.coveredBy(right);
        }
    }

    public static interface CoversEvaluator
    extends SpatialPredicateEvaluator {
        @Override
        default public boolean eval(Geometry left, Geometry right) {
            return left.covers(right);
        }

        @Override
        default public boolean eval(PreparedGeometry left, Geometry right) {
            return left.covers(right);
        }
    }

    public static interface WithinEvaluator
    extends SpatialPredicateEvaluator {
        @Override
        default public boolean eval(Geometry left, Geometry right) {
            return left.within(right);
        }

        @Override
        default public boolean eval(PreparedGeometry left, Geometry right) {
            return left.within(right);
        }
    }

    public static interface IntersectsEvaluator
    extends SpatialPredicateEvaluator {
        @Override
        default public boolean eval(Geometry left, Geometry right) {
            return left.intersects(right);
        }

        @Override
        default public boolean eval(PreparedGeometry left, Geometry right) {
            return left.intersects(right);
        }
    }

    public static interface ContainsEvaluator
    extends SpatialPredicateEvaluator {
        @Override
        default public boolean eval(Geometry left, Geometry right) {
            return left.contains(right);
        }

        @Override
        default public boolean eval(PreparedGeometry left, Geometry right) {
            return left.contains(right);
        }
    }

    public static interface SpatialPredicateEvaluator
    extends Serializable {
        public boolean eval(Geometry var1, Geometry var2);

        public boolean eval(PreparedGeometry var1, Geometry var2);
    }
}

