/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.osmpbf.extractors;

import java.util.HashMap;
import org.apache.sedona.sql.datasources.osmpbf.build.Osmformat;
import org.apache.sedona.sql.datasources.osmpbf.features.TagsResolver;
import org.apache.sedona.sql.datasources.osmpbf.model.OsmNode;

public class NodeExtractor {
    Osmformat.PrimitiveGroup primitiveGroup;
    Osmformat.PrimitiveBlock primitiveBlock;

    public NodeExtractor(Osmformat.PrimitiveGroup primitiveGroup, Osmformat.PrimitiveBlock primitiveBlock) {
        this.primitiveGroup = primitiveGroup;
        this.primitiveBlock = primitiveBlock;
    }

    public OsmNode extract(int idx, Osmformat.StringTable stringTable) {
        return this.parse(idx, stringTable);
    }

    private OsmNode parse(int idx, Osmformat.StringTable stringTable) {
        Osmformat.Node node = this.primitiveGroup.getNodes(idx);
        long id = node.getId();
        long latitude = node.getLat();
        long longitude = node.getLon();
        long latOffset = this.primitiveBlock.getLatOffset();
        long lonOffset = this.primitiveBlock.getLonOffset();
        long granularity = this.primitiveBlock.getGranularity();
        double lat = 1.0E-9 * (double)(latOffset + latitude * granularity);
        double lon = 1.0E-9 * (double)(lonOffset + longitude * granularity);
        HashMap<String, String> tags = TagsResolver.resolveTags(node.getKeysCount(), node::getKeys, node::getVals, stringTable);
        return new OsmNode(id, lat, lon, tags);
    }
}

