/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.geoparquet.internal;

import java.io.Serializable;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetColumn;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetRowIndexUtil;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ParquetRowIndexUtil$ {
    public static ParquetRowIndexUtil$ MODULE$;

    static {
        new ParquetRowIndexUtil$();
    }

    public ParquetRowIndexUtil.RowIndexGenerator createGeneratorIfNeeded(StructType sparkSchema) {
        int columnIdx = this.findRowIndexColumnIndexInSchema(sparkSchema);
        return columnIdx >= 0 ? new ParquetRowIndexUtil.RowIndexGenerator(columnIdx) : null;
    }

    public RecordReader<Void, InternalRow> addRowIndexToRecordReaderIfNeeded(ParquetRecordReader<InternalRow> reader, StructType sparkSchema) {
        int rowIndexColumnIdx = this.findRowIndexColumnIndexInSchema(sparkSchema);
        return rowIndexColumnIdx >= 0 ? new ParquetRowIndexUtil.RecordReaderWithRowIndexes(reader, rowIndexColumnIdx) : reader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int findRowIndexColumnIndexInSchema(StructType sparkSchema) {
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkSchema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetRowIndexUtil$.$anonfun$findRowIndexColumnIndexInSchema$1(x0$1)));
        if (!(option instanceof Some)) return -1;
        Some some = (Some)option;
        Tuple2 tuple2 = (Tuple2)some.value();
        if (tuple2 == null) return -1;
        StructField field = (StructField)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        if (field == null) return -1;
        StructField structField = field;
        int n = idx;
        DataType dataType = structField.dataType();
        LongType$ longType$ = LongType$.MODULE$;
        if (dataType == null) {
            if (longType$ == null) return n;
            throw new RuntimeException(new StringBuilder(20).append(ParquetFileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME()).append(" ").append("must be of LongType").toString());
        } else if (dataType.equals(longType$)) return n;
        throw new RuntimeException(new StringBuilder(20).append(ParquetFileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME()).append(" ").append("must be of LongType").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRowIndexColumn(ParquetColumn column) {
        if (column.path().length() != 1) return false;
        Object object = column.path().last();
        String string = ParquetFileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME();
        if (object != null) {
            if (!object.equals(string)) return false;
            return true;
        }
        if (string == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$findRowIndexColumnIndexInSchema$1(Tuple2 x0$1) {
        StructField field;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null || (field = (StructField)tuple2._1()) == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField structField = field;
        String string = structField.name();
        String string2 = ParquetFileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME();
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    private ParquetRowIndexUtil$() {
        MODULE$ = this;
    }
}

