/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.graphframes;

import java.util.NoSuchElementException;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class GraphFramesConf$ {
    public static GraphFramesConf$ MODULE$;
    private final OptionalConfigEntry<Object> USE_LABELS_AS_COMPONENTS;
    private final OptionalConfigEntry<String> CONNECTED_COMPONENTS_ALGORITHM;
    private final OptionalConfigEntry<Object> CONNECTED_COMPONENTS_BROADCAST_THRESHOLD;
    private final OptionalConfigEntry<Object> CONNECTED_COMPONENTS_CHECKPOINT_INTERVAL;
    private final OptionalConfigEntry<String> CONNECTED_COMPONENTS_INTERMEDIATE_STORAGE_LEVEL;

    static {
        new GraphFramesConf$();
    }

    private OptionalConfigEntry<Object> USE_LABELS_AS_COMPONENTS() {
        return this.USE_LABELS_AS_COMPONENTS;
    }

    private OptionalConfigEntry<String> CONNECTED_COMPONENTS_ALGORITHM() {
        return this.CONNECTED_COMPONENTS_ALGORITHM;
    }

    private OptionalConfigEntry<Object> CONNECTED_COMPONENTS_BROADCAST_THRESHOLD() {
        return this.CONNECTED_COMPONENTS_BROADCAST_THRESHOLD;
    }

    private OptionalConfigEntry<Object> CONNECTED_COMPONENTS_CHECKPOINT_INTERVAL() {
        return this.CONNECTED_COMPONENTS_CHECKPOINT_INTERVAL;
    }

    private OptionalConfigEntry<String> CONNECTED_COMPONENTS_INTERMEDIATE_STORAGE_LEVEL() {
        return this.CONNECTED_COMPONENTS_INTERMEDIATE_STORAGE_LEVEL;
    }

    private Option<String> get(ConfigEntry<?> entry) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).conf().get(entry.key()));
        }
        catch (NoSuchElementException noSuchElementException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<String> getConnectedComponentsAlgorithm() {
        Option<String> option = this.get((ConfigEntry<?>)this.CONNECTED_COMPONENTS_ALGORITHM());
        if (option instanceof Some) {
            Some some = (Some)option;
            String threshold = (String)some.value();
            return new Some((Object)threshold.toLowerCase());
        }
        return None$.MODULE$;
    }

    public Option<Object> getConnectedComponentsBroadcastThreshold() {
        Option<String> option = this.get((ConfigEntry<?>)this.CONNECTED_COMPONENTS_BROADCAST_THRESHOLD());
        if (option instanceof Some) {
            Some some = (Some)option;
            String threshold = (String)some.value();
            return new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(threshold)).toInt()));
        }
        return None$.MODULE$;
    }

    public Option<Object> getConnectedComponentsCheckpointInterval() {
        Option<String> option = this.get((ConfigEntry<?>)this.CONNECTED_COMPONENTS_CHECKPOINT_INTERVAL());
        if (option instanceof Some) {
            Some some = (Some)option;
            String interval = (String)some.value();
            return new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(interval)).toInt()));
        }
        return None$.MODULE$;
    }

    public Option<StorageLevel> getConnectedComponentsStorageLevel() {
        Option<String> option = this.get((ConfigEntry<?>)this.CONNECTED_COMPONENTS_INTERMEDIATE_STORAGE_LEVEL());
        if (option instanceof Some) {
            Some some = (Some)option;
            String level = (String)some.value();
            return new Some((Object)StorageLevel$.MODULE$.fromString(level.toUpperCase()));
        }
        return None$.MODULE$;
    }

    public Option<Object> getUseLabelsAsComponents() {
        Option<String> option = this.get((ConfigEntry<?>)this.USE_LABELS_AS_COMPONENTS());
        if (option instanceof Some) {
            Some some = (Some)option;
            String use = (String)some.value();
            return new Some((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(use)).toBoolean()));
        }
        return None$.MODULE$;
    }

    private GraphFramesConf$() {
        MODULE$ = this;
        this.USE_LABELS_AS_COMPONENTS = SQLConf$.MODULE$.buildConf("spark.graphframes.useLabelsAsComponents").doc(new StringOps(Predef$.MODULE$.augmentString(" Tells the connected components algorithm to use (default: \"true\") labels as components in the output\n          | DataFrame. If set to \"false\", randomly generated labels with the data type LONG will returned.\n          |")).stripMargin()).version("0.9.0").booleanConf().createOptional();
        this.CONNECTED_COMPONENTS_ALGORITHM = SQLConf$.MODULE$.buildConf("spark.graphframes.connectedComponents.algorithm").doc(new StringOps(Predef$.MODULE$.augmentString(" Sets the connected components algorithm to use (default: \"graphframes\"). Supported algorithms\n          |   - \"graphframes\": Uses alternating large star and small star iterations proposed in\n          |     [[http://dx.doi.org/10.1145/2670979.2670997 Connected Components in MapReduce and Beyond]]\n          |     with skewed join optimization.\n          |   - \"graphx\": Converts the graph to a GraphX graph and then uses the connected components\n          |     implementation in GraphX.\n          | @see org.graphframes.lib.ConnectedComponents.supportedAlgorithms")).stripMargin()).version("0.9.0").stringConf().createOptional();
        this.CONNECTED_COMPONENTS_BROADCAST_THRESHOLD = SQLConf$.MODULE$.buildConf("spark.graphframes.connectedComponents.broadcastthreshold").doc(new StringOps(Predef$.MODULE$.augmentString(" Sets broadcast threshold in propagating component assignments (default: 1000000). If a node\n          | degree is greater than this threshold at some iteration, its component assignment will be\n          | collected and then broadcasted back to propagate the assignment to its neighbors. Otherwise,\n          | the assignment propagation is done by a normal Spark join. This parameter is only used when\n          | the algorithm is set to \"graphframes\".")).stripMargin()).version("0.9.0").intConf().createOptional();
        this.CONNECTED_COMPONENTS_CHECKPOINT_INTERVAL = SQLConf$.MODULE$.buildConf("spark.graphframes.connectedComponents.checkpointinterval").doc(new StringOps(Predef$.MODULE$.augmentString(" Sets checkpoint interval in terms of number of iterations (default: 2). Checkpointing\n          | regularly helps recover from failures, clean shuffle files, shorten the lineage of the\n          | computation graph, and reduce the complexity of plan optimization. As of Spark 2.0, the\n          | complexity of plan optimization would grow exponentially without checkpointing. Hence,\n          | disabling or setting longer-than-default checkpoint intervals are not recommended. Checkpoint\n          | data is saved under `org.apache.spark.SparkContext.getCheckpointDir` with prefix\n          | \"connected-components\". If the checkpoint directory is not set, this throws a\n          | `java.io.IOException`. Set a nonpositive value to disable checkpointing. This parameter is\n          | only used when the algorithm is set to \"graphframes\". Its default value might change in the\n          | future.\n          | @see `org.apache.spark.SparkContext.setCheckpointDir` in Spark API doc")).stripMargin()).version("0.9.0").intConf().createOptional();
        this.CONNECTED_COMPONENTS_INTERMEDIATE_STORAGE_LEVEL = SQLConf$.MODULE$.buildConf("spark.graphframes.connectedComponents.intermediatestoragelevel").doc("Sets storage level for intermediate datasets that require multiple passes (default: ``MEMORY_AND_DISK``).").version("0.9.0").stringConf().createOptional();
    }
}

