/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.expressions;

import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.expressions.Aggregator;
import org.apache.spark.sql.sedona_sql.expressions.TraitSTAggregateExec;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U2Q\u0001B\u0003\u0001\u001bEAQ!\n\u0001\u0005\u0002\u001dBQ!\u000b\u0001\u0005\u0002)BQa\f\u0001\u0005\u0002A\u0012\u0001c\u0015+`\u000b:4X\r\\8qK~\u000bum\u001a:\u000b\u0005\u00199\u0011aC3yaJ,7o]5p]NT!\u0001C\u0005\u0002\u0015M,Gm\u001c8b?N\fHN\u0003\u0002\u000b\u0017\u0005\u00191/\u001d7\u000b\u00051i\u0011!B:qCJ\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c2\u0001\u0001\n\"!\u0015\u0019RcF\f\u0018\u001b\u0005!\"B\u0001\u0004\n\u0013\t1BC\u0001\u0006BO\u001e\u0014XmZ1u_J\u0004\"\u0001G\u0010\u000e\u0003eQ!AG\u000e\u0002\t\u001d,w.\u001c\u0006\u00039u\t1A\u001b;t\u0015\tqr\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007.\u0003\u0002!3\tAq)Z8nKR\u0014\u0018\u0010\u0005\u0002#G5\tQ!\u0003\u0002%\u000b\t!BK]1jiN#\u0016iZ4sK\u001e\fG/Z#yK\u000e\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002QA\u0011!\u0005A\u0001\u0007e\u0016$WoY3\u0015\u0007]YS\u0006C\u0003-\u0005\u0001\u0007q#\u0001\u0004ck\u001a4WM\u001d\u0005\u0006]\t\u0001\raF\u0001\u0006S:\u0004X\u000f^\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0004/E\u001a\u0004\"\u0002\u001a\u0004\u0001\u00049\u0012a\u00022vM\u001a,'/\r\u0005\u0006i\r\u0001\raF\u0001\bEV4g-\u001a:3\u0001")
public class ST_Envelope_Aggr
extends Aggregator<Geometry, Geometry, Geometry>
implements TraitSTAggregateExec {
    private final Geometry initialGeometry;
    private final ExpressionEncoder<Geometry> serde;

    @Override
    public Geometry zero() {
        return TraitSTAggregateExec.zero$(this);
    }

    @Override
    public ExpressionEncoder<Geometry> bufferEncoder() {
        return TraitSTAggregateExec.bufferEncoder$(this);
    }

    @Override
    public ExpressionEncoder<Geometry> outputEncoder() {
        return TraitSTAggregateExec.outputEncoder$(this);
    }

    @Override
    public Geometry finish(Geometry out) {
        return TraitSTAggregateExec.finish$(this, out);
    }

    @Override
    public Geometry initialGeometry() {
        return this.initialGeometry;
    }

    @Override
    public ExpressionEncoder<Geometry> serde() {
        return this.serde;
    }

    @Override
    public void org$apache$spark$sql$sedona_sql$expressions$TraitSTAggregateExec$_setter_$initialGeometry_$eq(Geometry x$1) {
        this.initialGeometry = x$1;
    }

    @Override
    public void org$apache$spark$sql$sedona_sql$expressions$TraitSTAggregateExec$_setter_$serde_$eq(ExpressionEncoder<Geometry> x$1) {
        this.serde = x$1;
    }

    public Geometry reduce(Geometry buffer, Geometry input) {
        Envelope accumulateEnvelope = buffer.getEnvelopeInternal();
        Envelope newEnvelope = input.getEnvelopeInternal();
        Coordinate[] coordinates = new Coordinate[5];
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        if (accumulateEnvelope.equals(this.initialGeometry().getEnvelopeInternal())) {
            minX = newEnvelope.getMinX();
            minY = newEnvelope.getMinY();
            maxX = newEnvelope.getMaxX();
            maxY = newEnvelope.getMaxY();
        } else if (newEnvelope.equals(this.initialGeometry().getEnvelopeInternal())) {
            minX = accumulateEnvelope.getMinX();
            minY = accumulateEnvelope.getMinY();
            maxX = accumulateEnvelope.getMaxX();
            maxY = accumulateEnvelope.getMaxY();
        } else {
            minX = Math.min(accumulateEnvelope.getMinX(), newEnvelope.getMinX());
            minY = Math.min(accumulateEnvelope.getMinY(), newEnvelope.getMinY());
            maxX = Math.max(accumulateEnvelope.getMaxX(), newEnvelope.getMaxX());
            maxY = Math.max(accumulateEnvelope.getMaxY(), newEnvelope.getMaxY());
        }
        coordinates[0] = new Coordinate(minX, minY);
        coordinates[1] = new Coordinate(minX, maxY);
        coordinates[2] = new Coordinate(maxX, maxY);
        coordinates[3] = new Coordinate(maxX, minY);
        coordinates[4] = coordinates[0];
        GeometryFactory geometryFactory = new GeometryFactory();
        return geometryFactory.createPolygon(coordinates);
    }

    public Geometry merge(Geometry buffer1, Geometry buffer2) {
        Envelope leftEnvelope = buffer1.getEnvelopeInternal();
        Envelope rightEnvelope = buffer2.getEnvelopeInternal();
        Coordinate[] coordinates = new Coordinate[5];
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        if (leftEnvelope.equals(this.initialGeometry().getEnvelopeInternal())) {
            minX = rightEnvelope.getMinX();
            minY = rightEnvelope.getMinY();
            maxX = rightEnvelope.getMaxX();
            maxY = rightEnvelope.getMaxY();
        } else if (rightEnvelope.equals(this.initialGeometry().getEnvelopeInternal())) {
            minX = leftEnvelope.getMinX();
            minY = leftEnvelope.getMinY();
            maxX = leftEnvelope.getMaxX();
            maxY = leftEnvelope.getMaxY();
        } else {
            minX = Math.min(leftEnvelope.getMinX(), rightEnvelope.getMinX());
            minY = Math.min(leftEnvelope.getMinY(), rightEnvelope.getMinY());
            maxX = Math.max(leftEnvelope.getMaxX(), rightEnvelope.getMaxX());
            maxY = Math.max(leftEnvelope.getMaxY(), rightEnvelope.getMaxY());
        }
        coordinates[0] = new Coordinate(minX, minY);
        coordinates[1] = new Coordinate(minX, maxY);
        coordinates[2] = new Coordinate(maxX, maxY);
        coordinates[3] = new Coordinate(maxX, minY);
        coordinates[4] = coordinates[0];
        GeometryFactory geometryFactory = new GeometryFactory();
        return geometryFactory.createPolygon(coordinates);
    }

    public ST_Envelope_Aggr() {
        TraitSTAggregateExec.$init$(this);
    }
}

