/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.guava.collect.Iterables;
import org.apache.sedona.shaded.s2.S2Cell;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2CellIndex;
import org.apache.sedona.shaded.s2.S2CellUnion;
import org.apache.sedona.shaded.s2.S2Region;

public class S2RegionSharder {
    private final S2CellIndex index;

    public S2RegionSharder(List<S2CellUnion> boundaries) {
        this.index = new S2CellIndex();
        for (int i = 0; i < boundaries.size(); ++i) {
            this.index.add(boundaries.get(i), i);
        }
        this.index.build();
    }

    public S2RegionSharder(S2CellIndex index) {
        this.index = index;
    }

    public int getMostIntersectingShard(S2Region region, int defaultShard) {
        Map<Integer, S2CellUnion> shardCoverings = this.intersections(region);
        int bestShard = defaultShard;
        long bestSum = 0L;
        ImmutableList<Integer> sortedKeys = ImmutableList.sortedCopyOf(shardCoverings.keySet());
        Iterator iterator = sortedKeys.iterator();
        while (iterator.hasNext()) {
            int shardId = (Integer)iterator.next();
            S2CellUnion shardCovering = shardCoverings.get(shardId);
            long sum = 0L;
            for (S2CellId id : shardCovering.cellIds()) {
                sum += id.lowestOnBit();
            }
            if (sum <= bestSum) continue;
            bestShard = shardId;
            bestSum = sum;
        }
        return bestShard;
    }

    public Collection<Integer> getIntersectingShards(S2Region region) {
        return this.intersections(region).keySet();
    }

    private Map<Integer, S2CellUnion> intersections(S2Region region) {
        S2CellUnion regionCovering = new S2CellUnion();
        region.getCellUnionBound(regionCovering.cellIds());
        HashMap<Integer, S2CellUnion> shardCoverings = new HashMap<Integer, S2CellUnion>();
        this.index.visitIntersectingCells(regionCovering, (cell, shardId) -> {
            S2CellUnion shard = (S2CellUnion)shardCoverings.get(shardId);
            if (shard == null) {
                shard = new S2CellUnion();
                shardCoverings.put(shardId, shard);
            }
            shard.cellIds().add(cell);
            return true;
        });
        if (shardCoverings.size() == 1) {
            return shardCoverings;
        }
        S2CellUnion tempIntersection = new S2CellUnion();
        for (S2CellUnion shardCovering : shardCoverings.values()) {
            shardCovering.normalize();
            tempIntersection.getIntersection(shardCovering, regionCovering);
            Iterables.removeIf(tempIntersection, id -> !region.mayIntersect(new S2Cell((S2CellId)id)));
            shardCovering.cellIds().clear();
            shardCovering.cellIds().addAll(tempIntersection.cellIds());
        }
        Iterables.removeIf(shardCoverings.values(), cells -> cells.size() == 0);
        return shardCoverings;
    }
}

