/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import java.awt.Color;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedImageAdapter;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.sedona.common.Functions;
import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.common.raster.RasterAccessors;
import org.apache.sedona.common.raster.RasterEditors;
import org.geotools.api.coverage.SampleDimensionType;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.Category;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.ClassChanger;
import org.geotools.util.NumberRange;
import org.locationtech.jts.geom.Geometry;

public class RasterUtils {
    private static final GridCoverageFactory gridCoverageFactory = CoverageFactoryFinder.getGridCoverageFactory(null);

    private RasterUtils() {
    }

    public static GridCoverage2D create(WritableRaster raster, GridGeometry2D gridGeometry, GridSampleDimension[] bands) {
        return RasterUtils.create(raster, gridGeometry, bands, null);
    }

    public static GridCoverage2D clone(WritableRaster raster, GridGeometry2D gridGeometry2D, GridSampleDimension[] bands, GridCoverage2D referenceRaster, Double noDataValue, boolean keepMetadata) {
        ColorModel colorModel;
        Map propertyMap = null;
        if (keepMetadata) {
            propertyMap = referenceRaster.getProperties();
        }
        ColorModel originalColorModel = referenceRaster.getRenderedImage().getColorModel();
        if (Objects.isNull(gridGeometry2D)) {
            gridGeometry2D = referenceRaster.getGridGeometry();
        }
        int numBand = raster.getNumBands();
        int rasterDataType = raster.getDataBuffer().getDataType();
        if (originalColorModel.isCompatibleRaster(raster)) {
            colorModel = originalColorModel;
        } else {
            BogusColorSpace cs = new BogusColorSpace(numBand);
            int[] nBits = new int[numBand];
            Arrays.fill(nBits, DataBuffer.getDataTypeSize(rasterDataType));
            colorModel = new ComponentColorModel((ColorSpace)cs, nBits, false, true, 1, rasterDataType);
        }
        if (noDataValue != null) {
            GridSampleDimension[] newBands = new GridSampleDimension[numBand];
            for (int k = 0; k < numBand; ++k) {
                newBands[k] = bands != null ? RasterUtils.createSampleDimensionWithNoDataValue(bands[k], (double)noDataValue) : RasterUtils.createSampleDimensionWithNoDataValue("band_" + k, (double)noDataValue);
            }
            bands = newBands;
        }
        GridCoverage2D[] referenceRasterSources = keepMetadata ? referenceRaster.getSources().toArray(new GridCoverage2D[0]) : null;
        String rasterName = keepMetadata ? referenceRaster.getName() : "genericCoverage";
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        return gridCoverageFactory.create((CharSequence)rasterName, (RenderedImage)image, gridGeometry2D, bands, (GridCoverage[])referenceRasterSources, propertyMap);
    }

    public static GridCoverage2D clone(WritableRaster raster, GridSampleDimension[] bands, GridCoverage2D referenceRaster, Double noDataValue, boolean keepMetadata) {
        return RasterUtils.clone(raster, null, bands, referenceRaster, noDataValue, keepMetadata);
    }

    public static GridCoverage2D clone(RenderedImage image, GridSampleDimension[] bands, GridCoverage2D referenceRaster, Double noDataValue, boolean keepMetadata) {
        return RasterUtils.clone(image, null, bands, referenceRaster, noDataValue, keepMetadata);
    }

    public static GridCoverage2D clone(RenderedImage image, GridGeometry2D gridGeometry2D, GridSampleDimension[] bands, GridCoverage2D referenceRaster, Double noDataValue, boolean keepMetadata) {
        int numBand = image.getSampleModel().getNumBands();
        if (Objects.isNull(gridGeometry2D)) {
            gridGeometry2D = referenceRaster.getGridGeometry();
        }
        if (noDataValue != null) {
            GridSampleDimension[] newBands = new GridSampleDimension[numBand];
            for (int k = 0; k < numBand; ++k) {
                newBands[k] = bands != null ? RasterUtils.createSampleDimensionWithNoDataValue(bands[k], (double)noDataValue) : RasterUtils.createSampleDimensionWithNoDataValue("band_" + k, (double)noDataValue);
            }
            bands = newBands;
        }
        GridCoverage2D[] referenceRasterSources = keepMetadata ? referenceRaster.getSources().toArray(new GridCoverage2D[0]) : null;
        Map propertyMap = null;
        if (keepMetadata) {
            propertyMap = referenceRaster.getProperties();
        }
        String rasterName = keepMetadata ? referenceRaster.getName() : "genericCoverage";
        return gridCoverageFactory.create((CharSequence)rasterName, image, gridGeometry2D, bands, (GridCoverage[])referenceRasterSources, propertyMap);
    }

    public static GridCoverage2D create(WritableRaster raster, GridGeometry2D gridGeometry, GridSampleDimension[] bands, Double noDataValue) {
        return RasterUtils.create(raster, gridGeometry, bands, noDataValue, null);
    }

    public static GridCoverage2D create(WritableRaster raster, GridGeometry2D gridGeometry, GridSampleDimension[] bands, Double noDataValue, Map properties) {
        int numBand = raster.getNumBands();
        int rasterDataType = raster.getDataBuffer().getDataType();
        BogusColorSpace cs = new BogusColorSpace(numBand);
        int[] nBits = new int[numBand];
        Arrays.fill(nBits, DataBuffer.getDataTypeSize(rasterDataType));
        ComponentColorModel colorModel = new ComponentColorModel((ColorSpace)cs, nBits, false, true, 1, rasterDataType);
        if (noDataValue != null) {
            GridSampleDimension[] newBands = new GridSampleDimension[numBand];
            for (int k = 0; k < numBand; ++k) {
                newBands[k] = bands != null ? RasterUtils.createSampleDimensionWithNoDataValue(bands[k], (double)noDataValue) : RasterUtils.createSampleDimensionWithNoDataValue("band_" + k, (double)noDataValue);
            }
            bands = newBands;
        }
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        return gridCoverageFactory.create((CharSequence)"genericCoverage", (RenderedImage)image, gridGeometry, bands, null, properties);
    }

    public static GridCoverage2D create(RenderedImage image, GridGeometry2D gridGeometry, GridSampleDimension[] bands, Double noDataValue) {
        int numBand = image.getSampleModel().getNumBands();
        if (noDataValue != null) {
            GridSampleDimension[] newBands = new GridSampleDimension[numBand];
            for (int k = 0; k < numBand; ++k) {
                newBands[k] = bands != null ? RasterUtils.createSampleDimensionWithNoDataValue(bands[k], (double)noDataValue) : RasterUtils.createSampleDimensionWithNoDataValue("band_" + k, (double)noDataValue);
            }
            bands = newBands;
        }
        return gridCoverageFactory.create((CharSequence)"genericCoverage", image, gridGeometry, bands, null, null);
    }

    public static GridSampleDimension createSampleDimensionWithNoDataValue(GridSampleDimension sampleDimension, double noDataValue) {
        double existingNoDataValue = RasterUtils.getNoDataValue(sampleDimension);
        if (Double.compare(existingNoDataValue, noDataValue) == 0) {
            return sampleDimension;
        }
        String description = sampleDimension.getDescription().toString();
        List categories = sampleDimension.getCategories();
        double offset = sampleDimension.getOffset();
        double scale = sampleDimension.getScale();
        ArrayList<Category> newCategories = new ArrayList<Category>(categories.size());
        for (Category category : categories) {
            NumberRange range = category.getRange();
            if (range.contains((Number)noDataValue)) {
                Number min2 = (Number)((Object)range.getMinValue());
                Number max = (Number)((Object)range.getMaxValue());
                Class clazz = ClassChanger.getWidestClass((Number)min2, (Number)max);
                min2 = ClassChanger.cast((Number)min2, (Class)clazz);
                max = ClassChanger.cast((Number)max, (Class)clazz);
                Number nodata = ClassChanger.cast((Number)noDataValue, (Class)clazz);
                if (min2.doubleValue() < noDataValue) {
                    Category leftCategory = new Category((CharSequence)category.getName(), category.getColors(), new NumberRange(clazz, min2, range.isMinIncluded(), nodata, false));
                    newCategories.add(leftCategory);
                }
                if (!(max.doubleValue() > noDataValue)) continue;
                Category rightCategory = new Category((CharSequence)category.getName(), category.getColors(), new NumberRange(clazz, nodata, false, max, range.isMaxIncluded()));
                newCategories.add(rightCategory);
                continue;
            }
            if (category.getName().equals(Category.NODATA.getName())) continue;
            newCategories.add(category);
        }
        Number nodata = TypeMap.wrapSample((double)noDataValue, (SampleDimensionType)sampleDimension.getSampleDimensionType(), (boolean)false);
        newCategories.add(new Category((CharSequence)Category.NODATA.getName(), new Color(0, 0, 0, 0), new NumberRange(nodata.getClass(), nodata, nodata)));
        return new GridSampleDimension(description, newCategories.toArray(new Category[0]), offset, scale);
    }

    public static GridSampleDimension createSampleDimensionWithNoDataValue(String description, double noDataValue) {
        Category noDataCategory = new Category((CharSequence)Category.NODATA.getName(), new Color(0, 0, 0, 0), new NumberRange(Double.class, (Number)noDataValue, (Number)noDataValue));
        Category[] categories = new Category[]{noDataCategory};
        return new GridSampleDimension((CharSequence)description, categories, null);
    }

    public static GridSampleDimension removeNoDataValue(GridSampleDimension sampleDimension) {
        String description = sampleDimension.getDescription().toString();
        List categories = sampleDimension.getCategories();
        ArrayList<Category> newCategories = new ArrayList<Category>(categories.size());
        InternationalString noDataCategoryName = Category.NODATA.getName();
        for (Category category : categories) {
            if (category.getName().equals(noDataCategoryName)) continue;
            newCategories.add(category);
        }
        if (newCategories.size() == categories.size()) {
            return sampleDimension;
        }
        double offset = sampleDimension.getOffset();
        double scale = sampleDimension.getScale();
        return new GridSampleDimension(description, newCategories.toArray(new Category[0]), offset, scale);
    }

    public static double getNoDataValue(GridSampleDimension sampleDimension) {
        List categories = sampleDimension.getCategories();
        InternationalString noDataCategoryName = Category.NODATA.getName();
        for (Category category : categories) {
            if (!category.getName().equals(noDataCategoryName)) continue;
            return category.getRange().getMinimum();
        }
        return Double.NaN;
    }

    public static AffineTransform2D getGDALAffineTransform(GridCoverage2D raster) {
        return RasterUtils.getAffineTransform(raster, PixelOrientation.UPPER_LEFT);
    }

    public static AffineTransform2D getAffineTransform(GridCoverage2D raster, PixelOrientation orientation) throws UnsupportedOperationException {
        GridGeometry2D gridGeometry2D = raster.getGridGeometry();
        MathTransform2D crsTransform = gridGeometry2D.getGridToCRS2D(orientation);
        if (!(crsTransform instanceof AffineTransform2D)) {
            throw new UnsupportedOperationException("Only AffineTransform2D is supported");
        }
        return (AffineTransform2D)crsTransform;
    }

    public static AffineTransform2D translateAffineTransform(AffineTransform2D affine, int offsetX, int offsetY) {
        double ipX = affine.getTranslateX();
        double ipY = affine.getTranslateY();
        double scaleX = affine.getScaleX();
        double scaleY = affine.getScaleY();
        double skewX = affine.getShearX();
        double skewY = affine.getShearY();
        double newIpX = ipX + (double)offsetX * scaleX + (double)offsetY * skewX;
        double newIpY = ipY + (double)offsetX * skewY + (double)offsetY * scaleY;
        return new AffineTransform2D(scaleX, skewY, skewX, scaleY, newIpX, newIpY);
    }

    public static Point2D getWorldCornerCoordinates(GridCoverage2D raster, int colX, int rowY) throws TransformException {
        Position2D gridCoord = new Position2D((double)(colX - 1), (double)(rowY - 1));
        return raster.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT).transform((Point2D)gridCoord, null);
    }

    public static Point2D getWorldCornerCoordinatesWithRangeCheck(GridCoverage2D raster, int colX, int rowY) throws IndexOutOfBoundsException, TransformException {
        Position2D gridCoordinates2D = new Position2D((double)(colX - 1), (double)(rowY - 1));
        if (!raster.getGridGeometry().getGridRange2D().contains((Point2D)gridCoordinates2D)) {
            throw new IndexOutOfBoundsException(String.format("Specified pixel coordinates (%d, %d) do not lie in the raster", colX, rowY));
        }
        return raster.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT).transform((Point2D)gridCoordinates2D, null);
    }

    public static int[] getGridCoordinatesFromWorld(GridCoverage2D raster, double longitude, double latitude) throws TransformException {
        Position2D directPosition2D = new Position2D(raster.getCoordinateReferenceSystem2D(), longitude, latitude);
        Point2D worldCoord = raster.getGridGeometry().getCRSToGrid2D(PixelOrientation.UPPER_LEFT).transform((Point2D)directPosition2D, null);
        double[] coords = new double[]{worldCoord.getX(), worldCoord.getY()};
        int[] gridCoords = new int[]{(int)Math.floor(coords[0]), (int)Math.floor(coords[1])};
        return gridCoords;
    }

    public static void ensureBand(GridCoverage2D raster, int band) throws IllegalArgumentException {
        if (band < 1 || band > RasterAccessors.numBands(raster)) {
            throw new IllegalArgumentException(String.format("Provided band index %d is not present in the raster", band));
        }
    }

    public static Raster getRaster(RenderedImage renderedImage) {
        while (renderedImage instanceof RenderedImageAdapter) {
            renderedImage = ((RenderedImageAdapter)renderedImage).getWrappedImage();
        }
        if (renderedImage instanceof BufferedImage) {
            return ((BufferedImage)renderedImage).getRaster();
        }
        return renderedImage.getData();
    }

    public static Geometry convertCRSIfNeeded(Geometry geometry, CoordinateReferenceSystem targetCRS) {
        int geomSRID = geometry.getSRID();
        if (geomSRID == 0) {
            geomSRID = 4326;
        }
        if (targetCRS != null && !(targetCRS instanceof DefaultEngineeringCRS)) {
            try {
                geometry = FunctionsGeoTools.transformToGivenTarget(geometry, "epsg:" + geomSRID, targetCRS, true);
            }
            catch (FactoryException | TransformException e) {
                throw new RuntimeException("Cannot transform CRS of query window", e);
            }
        }
        return geometry;
    }

    public static Pair<GridCoverage2D, Geometry> setDefaultCRSAndTransform(GridCoverage2D raster, Geometry geom) throws FactoryException {
        int rasterSRID = RasterAccessors.srid(raster);
        int geomSRID = Functions.getSRID(geom);
        if (rasterSRID == 0) {
            raster = RasterEditors.setSrid(raster, 4326);
            rasterSRID = RasterAccessors.srid(raster);
        }
        if (geomSRID == 0) {
            geom = Functions.setSRID(geom, 4326);
            geomSRID = Functions.getSRID(geom);
        }
        if (rasterSRID != geomSRID) {
            geom = RasterUtils.convertCRSIfNeeded(geom, raster.getCoordinateReferenceSystem());
            geom = Functions.setSRID(geom, RasterAccessors.srid(raster));
        }
        return Pair.of(raster, geom);
    }

    public static int getDataTypeCode(String s2) {
        switch (s2.toUpperCase()) {
            case "D": 
            case "REAL_64BITS": {
                return 5;
            }
            case "I": 
            case "SIGNED_32BITS": {
                return 3;
            }
            case "B": 
            case "UNSIGNED_8BITS": {
                return 0;
            }
            case "F": 
            case "REAL_32BITS": {
                return 4;
            }
            case "S": 
            case "SIGNED_16BITS": {
                return 2;
            }
            case "US": 
            case "UNSIGNED_16BITS": {
                return 1;
            }
        }
        return 5;
    }

    public static boolean isDataTypeIntegral(int dataTypeCode) {
        switch (dataTypeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static GridCoverage2D copyRasterAndAppendBand(GridCoverage2D gridCoverage2D, Object bandValues, Double noDataValue) {
        RenderedImage originalImage = gridCoverage2D.getRenderedImage();
        Raster raster = RasterUtils.getRaster(originalImage);
        Point location = raster.getBounds().getLocation();
        WritableRaster wr = RasterFactory.createBandedRaster((int)raster.getDataBuffer().getDataType(), (int)originalImage.getWidth(), (int)originalImage.getHeight(), (int)(gridCoverage2D.getNumSampleDimensions() + 1), (Point)location);
        for (int i = 0; i < raster.getWidth(); ++i) {
            for (int j = 0; j < raster.getHeight(); ++j) {
                Object[] copiedPixels;
                Object[] pixels;
                Object[] values;
                if (bandValues instanceof double[]) {
                    values = (double[])bandValues;
                    pixels = raster.getPixel(i, j, (double[])null);
                    copiedPixels = new double[pixels.length + 1];
                    System.arraycopy(pixels, 0, copiedPixels, 0, pixels.length);
                    copiedPixels[pixels.length] = values[j * raster.getWidth() + i];
                    wr.setPixel(i, j, (double[])copiedPixels);
                    continue;
                }
                if (!(bandValues instanceof int[])) continue;
                values = (int[])bandValues;
                pixels = raster.getPixel(i, j, (int[])null);
                copiedPixels = new int[pixels.length + 1];
                System.arraycopy(pixels, 0, copiedPixels, 0, pixels.length);
                copiedPixels[pixels.length] = values[j * raster.getWidth() + i];
                wr.setPixel(i, j, (int[])copiedPixels);
            }
        }
        int numBand = wr.getNumBands();
        GridSampleDimension[] originalSampleDimensions = gridCoverage2D.getSampleDimensions();
        GridSampleDimension[] sampleDimensions = new GridSampleDimension[numBand];
        System.arraycopy(originalSampleDimensions, 0, sampleDimensions, 0, originalSampleDimensions.length);
        sampleDimensions[numBand - 1] = noDataValue != null ? RasterUtils.createSampleDimensionWithNoDataValue("band" + numBand, (double)noDataValue) : new GridSampleDimension((CharSequence)("band" + numBand));
        return RasterUtils.clone(wr, gridCoverage2D.getGridGeometry(), sampleDimensions, gridCoverage2D, null, true);
    }

    public static GridCoverage2D copyRasterAndAppendBand(GridCoverage2D gridCoverage2D, Object bandValues) {
        return RasterUtils.copyRasterAndAppendBand(gridCoverage2D, bandValues, null);
    }

    public static GridCoverage2D copyRasterAndReplaceBand(GridCoverage2D gridCoverage2D, int bandIndex, Object bandValues, Double noDataValue, boolean removeNoDataIfNull) {
        RasterUtils.ensureBand(gridCoverage2D, bandIndex);
        RenderedImage originalImage = gridCoverage2D.getRenderedImage();
        Raster raster = RasterUtils.getRaster(originalImage);
        WritableRaster wr = raster.createCompatibleWritableRaster();
        for (int i = 0; i < raster.getWidth(); ++i) {
            for (int j = 0; j < raster.getHeight(); ++j) {
                Object[] bands;
                Object[] values;
                if (bandValues instanceof double[]) {
                    values = (double[])bandValues;
                    bands = raster.getPixel(i, j, (double[])null);
                    bands[bandIndex - 1] = values[j * raster.getWidth() + i];
                    wr.setPixel(i, j, (double[])bands);
                    continue;
                }
                if (!(bandValues instanceof int[])) continue;
                values = (int[])bandValues;
                bands = raster.getPixel(i, j, (int[])null);
                bands[bandIndex - 1] = values[j * raster.getWidth() + i];
                wr.setPixel(i, j, (int[])bands);
            }
        }
        GridSampleDimension[] sampleDimensions = gridCoverage2D.getSampleDimensions();
        GridSampleDimension sampleDimension = sampleDimensions[bandIndex - 1];
        if (noDataValue == null && removeNoDataIfNull) {
            sampleDimensions[bandIndex - 1] = RasterUtils.removeNoDataValue(sampleDimension);
        } else if (noDataValue != null) {
            sampleDimensions[bandIndex - 1] = RasterUtils.createSampleDimensionWithNoDataValue(sampleDimension, (double)noDataValue);
        }
        return RasterUtils.clone(wr, gridCoverage2D.getGridGeometry(), sampleDimensions, gridCoverage2D, null, true);
    }

    public static GridCoverage2D copyRasterAndReplaceBand(GridCoverage2D gridCoverage2D, int bandIndex, Object bandValues) {
        return RasterUtils.copyRasterAndReplaceBand(gridCoverage2D, bandIndex, bandValues, null, false);
    }

    public static void isRasterSameShape(GridCoverage2D raster1, GridCoverage2D raster2) {
        int width1 = RasterAccessors.getWidth(raster1);
        int height1 = RasterAccessors.getHeight(raster1);
        int width2 = RasterAccessors.getWidth(raster2);
        int height2 = RasterAccessors.getHeight(raster2);
        if (width1 != width2 && height1 != height2) {
            throw new IllegalArgumentException(String.format("Provided rasters are not of same shape. \nFirst raster having width of %d and height of %d. \nSecond raster having width of %d and height of %d", width1, height1, width2, height2));
        }
    }

    public static GridCoverage2D shiftRasterToZeroOrigin(GridCoverage2D raster, Double noDataValue) {
        RenderedImage image = raster.getRenderedImage();
        SampleModel sampleModel = image.getSampleModel();
        int width = image.getWidth();
        int height = image.getHeight();
        int minX = image.getMinX();
        int minY = image.getMinY();
        if (minX != 0 || minY != 0) {
            GridGeometry2D gridGeometry = raster.getGridGeometry();
            AffineTransform2D transform = (AffineTransform2D)gridGeometry.getGridToCRS2D();
            AffineTransform2D newAffine = RasterUtils.translateAffineTransform(transform, minX, minY);
            GridEnvelope2D newGridEnvelope = new GridEnvelope2D(0, 0, width, height);
            GridGeometry2D newGridGeometry = new GridGeometry2D((GridEnvelope)newGridEnvelope, (MathTransform)newAffine, gridGeometry.getCoordinateReferenceSystem());
            WritableRaster wr = RasterFactory.createBandedRaster((int)sampleModel.getDataType(), (int)image.getWidth(), (int)image.getHeight(), (int)sampleModel.getNumBands(), null);
            wr.setRect(-minX, -minY, RasterUtils.getRaster(image));
            return RasterUtils.clone(wr, newGridGeometry, raster.getSampleDimensions(), raster, noDataValue, false);
        }
        WritableRaster wr = RasterFactory.createBandedRaster((int)sampleModel.getDataType(), (int)image.getWidth(), (int)image.getHeight(), (int)sampleModel.getNumBands(), null);
        wr.setRect(0, 0, RasterUtils.getRaster(image));
        return RasterUtils.clone(wr, raster.getGridGeometry(), raster.getSampleDimensions(), raster, noDataValue, false);
    }

    public static List<Double> getNeighboringPixels(int x, int y, int band, Raster raster, Double noDataValue) {
        ArrayList<Double> neighbors = new ArrayList<Double>();
        int width = raster.getWidth();
        int height = raster.getHeight();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                double value;
                int nx = x + dx;
                int ny = y + dy;
                if (nx < 0 || nx >= width || ny < 0 || ny >= height || dx == 0 && dy == 0 || (value = raster.getSampleDouble(nx, ny, band)) == noDataValue) continue;
                neighbors.add(value);
            }
        }
        return neighbors;
    }

    public static GridCoverage2D replaceNoDataValues(GridCoverage2D raster) {
        Raster rasterData = raster.getRenderedImage().getData();
        WritableRaster writableRaster = rasterData.createCompatibleWritableRaster();
        Median medianCalculator = new Median();
        for (int band = 0; band < raster.getNumSampleDimensions(); ++band) {
            GridSampleDimension sampleDimension = raster.getSampleDimension(band);
            double noDataValue = RasterUtils.getNoDataValue(sampleDimension);
            for (int y = 0; y < rasterData.getHeight(); ++y) {
                for (int x = 0; x < rasterData.getWidth(); ++x) {
                    double originalValue = rasterData.getSampleDouble(x, y, band);
                    if (originalValue == noDataValue) {
                        List<Double> neighbors = RasterUtils.getNeighboringPixels(x, y, band, rasterData, noDataValue);
                        double[] neighborArray = neighbors.stream().mapToDouble(Double::doubleValue).toArray();
                        double medianValue = neighborArray.length > 0 ? medianCalculator.evaluate(neighborArray) : Double.NaN;
                        writableRaster.setSample(x, y, band, !Double.isNaN(medianValue) ? medianValue : originalValue);
                        continue;
                    }
                    writableRaster.setSample(x, y, band, originalValue);
                }
            }
        }
        GridCoverage2D modifiedRaster = RasterUtils.clone(writableRaster, raster.getGridGeometry(), raster.getSampleDimensions(), raster, null, true);
        return modifiedRaster;
    }

    public static GridCoverage2D extractNoDataValueMask(GridCoverage2D raster) {
        Raster rasterData = raster.getRenderedImage().getData();
        WritableRaster writableRaster = rasterData.createCompatibleWritableRaster(RasterAccessors.getWidth(raster), RasterAccessors.getHeight(raster));
        for (int band = 0; band < raster.getNumSampleDimensions(); ++band) {
            GridSampleDimension sampleDimension = raster.getSampleDimension(band);
            Double noDataValue = RasterUtils.getNoDataValue(sampleDimension);
            for (int y = 0; y < rasterData.getHeight(); ++y) {
                for (int x = 0; x < rasterData.getWidth(); ++x) {
                    double originalValue = rasterData.getSampleDouble(x, y, band);
                    if (originalValue == noDataValue) {
                        writableRaster.setSample(x, y, band, originalValue);
                        continue;
                    }
                    writableRaster.setSample(x, y, band, Double.NaN);
                }
            }
        }
        GridCoverage2D modifiedRaster = RasterUtils.clone(writableRaster, raster.getGridGeometry(), raster.getSampleDimensions(), raster, null, true);
        return modifiedRaster;
    }

    public static GridCoverage2D applyRasterMask(GridCoverage2D raster, GridCoverage2D mask) {
        Raster rasterData = raster.getRenderedImage().getData();
        Raster maskData = mask.getRenderedImage().getData();
        WritableRaster writableRaster = rasterData.createCompatibleWritableRaster(RasterAccessors.getWidth(raster), RasterAccessors.getHeight(raster));
        for (int band = 0; band < raster.getNumSampleDimensions(); ++band) {
            for (int y = 0; y < rasterData.getHeight(); ++y) {
                for (int x = 0; x < rasterData.getWidth(); ++x) {
                    double originalValue = rasterData.getSampleDouble(x, y, band);
                    double maskValue = maskData.getSampleDouble(x, y, band);
                    if (!Double.isNaN(maskValue)) {
                        writableRaster.setSample(x, y, band, maskValue);
                        continue;
                    }
                    writableRaster.setSample(x, y, band, originalValue);
                }
            }
        }
        GridCoverage2D modifiedRaster = RasterUtils.clone(writableRaster, raster.getGridGeometry(), raster.getSampleDimensions(), raster, null, false);
        return modifiedRaster;
    }
}

