/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;
import org.apache.sedona.shaded.guava.annotations.GwtCompatible;
import org.apache.sedona.shaded.s2.S1Angle;
import org.apache.sedona.shaded.s2.S1ChordAngle;
import org.apache.sedona.shaded.s2.S2LatLng;
import org.apache.sedona.shaded.s2.S2Point;

@JsType
@GwtCompatible
public class S2Earth {
    private S2Earth() {
    }

    public static double getRadiusMeters() {
        return 6371010.0;
    }

    public static double getRadiusKm() {
        return 0.001 * S2Earth.getRadiusMeters();
    }

    @JsIgnore
    public static double getLowestAltitudeMeters() {
        return -10898.0;
    }

    @JsIgnore
    public static double getHighestAltitudeMeters() {
        return 8846.0;
    }

    @JsIgnore
    public static S1Angle metersToAngle(double distanceMeters) {
        return S1Angle.radians(S2Earth.metersToRadians(distanceMeters));
    }

    @JsIgnore
    public static S1ChordAngle metersToChordAngle(double distanceMeters) {
        return S1ChordAngle.fromRadians(S2Earth.metersToRadians(distanceMeters));
    }

    public static double toMeters(S1Angle angle) {
        return angle.radians() * S2Earth.getRadiusMeters();
    }

    @JsIgnore
    public static double toMeters(S1ChordAngle chordAngle) {
        return chordAngle.radians() * S2Earth.getRadiusMeters();
    }

    public static double toKm(S1Angle angle) {
        return angle.radians() * S2Earth.getRadiusKm();
    }

    public static double kmToRadians(double km3) {
        return km3 / S2Earth.getRadiusKm();
    }

    public static double radiansToKm(double radians2) {
        return radians2 * S2Earth.getRadiusKm();
    }

    public static double metersToRadians(double meters) {
        return meters / S2Earth.getRadiusMeters();
    }

    public static double radiansToMeters(double radians2) {
        return radians2 * S2Earth.getRadiusMeters();
    }

    public static double squareKmToSteradians(double km22) {
        return km22 / (S2Earth.getRadiusKm() * S2Earth.getRadiusKm());
    }

    public static double squareMetersToSteradians(double m22) {
        return m22 / (S2Earth.getRadiusMeters() * S2Earth.getRadiusMeters());
    }

    public static double steradiansToSquareKm(double steradians) {
        return steradians * S2Earth.getRadiusKm() * S2Earth.getRadiusKm();
    }

    public static double steradiansToSquareMeters(double steradians) {
        return steradians * S2Earth.getRadiusMeters() * S2Earth.getRadiusMeters();
    }

    @JsMethod(name="getDistanceBetweenPointsKm")
    public static double getDistanceKm(S2Point a, S2Point b) {
        return S2Earth.radiansToKm(a.angle(b));
    }

    @JsMethod(name="getDistanceBetweenLatLngsKm")
    public static double getDistanceKm(S2LatLng a, S2LatLng b) {
        return S2Earth.toKm(a.getDistance(b));
    }

    @JsMethod(name="getDistanceBetweenPointsMeters")
    public static double getDistanceMeters(S2Point a, S2Point b) {
        return S2Earth.radiansToMeters(a.angle(b));
    }

    @JsMethod(name="getDistanceBetweenLatLngsMeters")
    public static double getDistanceMeters(S2LatLng a, S2LatLng b) {
        return S2Earth.toMeters(a.getDistance(b));
    }

    public static double haversine(double angle) {
        double halfSin = Math.sin(angle / 2.0);
        return halfSin * halfSin;
    }

    public static S1Angle getInitialBearing(S2LatLng a, S2LatLng b) {
        double lat1 = a.latRadians();
        double cosLat2 = Math.cos(b.latRadians());
        double latDiff = b.latRadians() - a.latRadians();
        double lngDiff = b.lngRadians() - a.lngRadians();
        double x = Math.sin(latDiff) + Math.sin(lat1) * cosLat2 * 2.0 * S2Earth.haversine(lngDiff);
        double y = Math.sin(lngDiff) * cosLat2;
        return S1Angle.radians(Math.atan2(y, x));
    }
}

