/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sedona.shaded.guava.annotations.VisibleForTesting;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.guava.collect.Iterables;
import org.apache.sedona.shaded.guava.collect.Lists;
import org.apache.sedona.shaded.guava.collect.Sets;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2CellUnion;
import org.apache.sedona.shaded.s2.S2IndexingHelper;
import org.apache.sedona.shaded.s2.S2LatLng;
import org.apache.sedona.shaded.s2.S2Region;
import org.apache.sedona.shaded.s2.S2RegionCoverer;

public class S2IndexingHelperImpl
implements S2IndexingHelper {
    private final S2RegionCoverer coverer;
    private final boolean onlyPointsIndexed;
    private final boolean optimizeForSpace;

    public static Builder builder() {
        return new Builder();
    }

    private S2IndexingHelperImpl(S2RegionCoverer coverer, boolean onlyPointsIndexed, boolean optimizeForSpace) {
        this.coverer = coverer;
        this.onlyPointsIndexed = onlyPointsIndexed;
        this.optimizeForSpace = optimizeForSpace;
    }

    @Override
    public int minLevel() {
        return this.coverer.minLevel();
    }

    @Override
    public int maxLevel() {
        return this.coverer.maxLevel();
    }

    @Override
    public int levelMod() {
        return this.coverer.levelMod();
    }

    @Override
    public Collection<S2IndexingHelper.Term> getIndexTerms(S2LatLng latlng) {
        S2CellId cellId = S2CellId.fromLatLng(latlng).parent(this.maxLevel());
        ImmutableList.Builder termBuilder = ImmutableList.builder();
        for (int level = this.minLevel(); level <= this.maxLevel(); level += this.levelMod()) {
            termBuilder.add(new TermImpl(S2IndexingHelper.TermType.ANCESTOR, cellId.parent(level)));
        }
        return termBuilder.build();
    }

    @Override
    public Collection<S2IndexingHelper.Term> getIndexTerms(Iterable<S2CellId> cellIds) {
        Preconditions.checkState(!this.onlyPointsIndexed, "Attempting to index a region when helper has been told only to index points");
        ImmutableList.Builder<S2IndexingHelper.Term> termBuilder = ImmutableList.builder();
        HashSet<S2CellId> ancestors = Sets.newHashSet();
        for (S2CellId cellId : cellIds) {
            int level = cellId.level();
            this.checkValidLevel(level);
            if (this.canBeAncestor(level)) {
                termBuilder.add((Object)new TermImpl(S2IndexingHelper.TermType.COVERING, cellId));
                if (!this.optimizeForSpace) {
                    termBuilder.add((Object)new TermImpl(S2IndexingHelper.TermType.ANCESTOR, cellId));
                }
            } else {
                termBuilder.add((Object)new TermImpl(S2IndexingHelper.TermType.ANCESTOR, cellId));
            }
            this.buildTermsForAncestors(cellId, level, termBuilder, ancestors, S2IndexingHelper.TermType.ANCESTOR);
        }
        return termBuilder.build();
    }

    @Override
    public Collection<S2IndexingHelper.Term> getIndexTerms(S2Region region) {
        S2CellUnion cellUnion = this.regionToCellUnion(region);
        return this.getIndexTerms((Iterable<S2CellId>)this.getDenormalizedCellIds(cellUnion));
    }

    @Override
    public Collection<S2IndexingHelper.Term> getIndexTerms(List<S2Region> regions) {
        S2CellUnion cellUnion = this.regionListToCellUnion(regions);
        return this.getIndexTerms((Iterable<S2CellId>)this.getDenormalizedCellIds(cellUnion));
    }

    @Override
    public Collection<S2IndexingHelper.Term> getQueryTerms(S2LatLng latlng) {
        S2CellId cellId = S2CellId.fromLatLng(latlng).parent(this.maxLevel());
        ImmutableList.Builder termBuilder = ImmutableList.builder();
        for (int level = this.minLevel(); level <= this.maxLevel(); level += this.levelMod()) {
            if (this.maxLevel() - level < this.levelMod()) {
                termBuilder.add(new TermImpl(S2IndexingHelper.TermType.ANCESTOR, cellId.parent(level)));
                continue;
            }
            if (this.onlyPointsIndexed) continue;
            termBuilder.add(new TermImpl(S2IndexingHelper.TermType.COVERING, cellId.parent(level)));
        }
        return termBuilder.build();
    }

    @Override
    public Collection<S2IndexingHelper.Term> getQueryTerms(Iterable<S2CellId> cellIds) {
        ImmutableList.Builder<S2IndexingHelper.Term> termBuilder = ImmutableList.builder();
        HashSet<S2CellId> ancestors = Sets.newHashSet();
        for (S2CellId cellId : cellIds) {
            int level = cellId.level();
            this.checkValidLevel(level);
            termBuilder.add((Object)new TermImpl(S2IndexingHelper.TermType.ANCESTOR, cellId));
            if (this.onlyPointsIndexed) continue;
            if (this.optimizeForSpace && this.canBeAncestor(level)) {
                termBuilder.add((Object)new TermImpl(S2IndexingHelper.TermType.COVERING, cellId));
            }
            this.buildTermsForAncestors(cellId, level, termBuilder, ancestors, S2IndexingHelper.TermType.COVERING);
        }
        return termBuilder.build();
    }

    @Override
    public Collection<S2IndexingHelper.Term> getQueryTerms(S2Region region) {
        S2CellUnion cellUnion = this.regionToCellUnion(region);
        return this.getQueryTerms((Iterable<S2CellId>)this.getDenormalizedCellIds(cellUnion));
    }

    @Override
    public Collection<S2IndexingHelper.Term> getQueryTerms(List<S2Region> regions) {
        S2CellUnion cellUnion = this.regionListToCellUnion(regions);
        return this.getQueryTerms((Iterable<S2CellId>)this.getDenormalizedCellIds(cellUnion));
    }

    private void checkValidLevel(int level) {
        Preconditions.checkArgument(level >= this.minLevel(), "Found cell at level %s, below the minimum of %s", level, this.minLevel());
        Preconditions.checkArgument(level <= this.maxLevel(), "Found cell at level %s, above the maximum of %s", level, this.maxLevel());
        Preconditions.checkArgument((level - this.minLevel()) % this.levelMod() == 0, "Found cell at level %s, not an integer number of %s-level steps over %s", (Object)level, (Object)this.levelMod(), (Object)this.minLevel());
    }

    private boolean canBeAncestor(int level) {
        return level < this.maxLevel();
    }

    private void buildTermsForAncestors(S2CellId cellId, int level, ImmutableList.Builder<S2IndexingHelper.Term> termBuilder, Set<S2CellId> ancestors, S2IndexingHelper.TermType type) {
        while ((level -= this.levelMod()) >= this.minLevel() && ancestors.add(cellId = cellId.parent(level))) {
            termBuilder.add((Object)new TermImpl(type, cellId));
        }
    }

    private synchronized S2CellUnion regionToCellUnion(S2Region region) {
        if (region instanceof S2CellUnion) {
            return (S2CellUnion)region;
        }
        return this.coverer.getCovering(region);
    }

    private S2CellUnion regionListToCellUnion(List<S2Region> regions) {
        Preconditions.checkArgument(!regions.isEmpty());
        return new S2CellUnion().initFromCellIds(Lists.newArrayList(Iterables.concat(Lists.transform(regions, region -> this.regionToCellUnion((S2Region)region).cellIds()))));
    }

    private List<S2CellId> getDenormalizedCellIds(S2CellUnion cellUnion) {
        ArrayList<S2CellId> cellIds = Lists.newArrayList();
        cellUnion.denormalize(this.minLevel(), this.levelMod(), cellIds);
        return ImmutableList.copyOf(cellIds);
    }

    @VisibleForTesting
    public static class TermImpl
    implements S2IndexingHelper.Term {
        private final S2IndexingHelper.TermType type;
        private final long cellId;

        public TermImpl(S2IndexingHelper.TermType type, S2CellId cellId) {
            this.type = type;
            this.cellId = cellId.id();
        }

        @Override
        public S2IndexingHelper.TermType type() {
            return this.type;
        }

        @Override
        public long cellId() {
            return this.cellId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TermImpl)) {
                return false;
            }
            TermImpl term = (TermImpl)o;
            if (this.cellId != term.cellId) {
                return false;
            }
            return this.type == term.type;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (int)(this.cellId ^ this.cellId >>> 32);
            return result;
        }

        public String toString() {
            return String.format("%s:%016X", this.type.name(), this.cellId);
        }
    }

    public static class Builder {
        private S2RegionCoverer.Builder covererBuilder = S2RegionCoverer.builder();
        private boolean onlyPointsIndexed = false;
        private boolean optimizeForSpace = false;

        private Builder() {
        }

        public S2IndexingHelperImpl build() {
            S2RegionCoverer coverer = this.covererBuilder.build();
            S2IndexingHelperImpl impl = new S2IndexingHelperImpl(coverer, this.onlyPointsIndexed, this.optimizeForSpace);
            this.covererBuilder = null;
            return impl;
        }

        @CanIgnoreReturnValue
        public Builder setMinLevel(int level) {
            this.covererBuilder.setMinLevel(level);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxLevel(int level) {
            this.covererBuilder.setMaxLevel(level);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLevelMod(int spacing) {
            this.covererBuilder.setLevelMod(spacing);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxCells(int limit) {
            this.covererBuilder.setMaxCells(limit);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOptimizeForComplexity() {
            this.optimizeForSpace = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOptimizeForSpace() {
            this.optimizeForSpace = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPointAndRegionsIndexed() {
            this.onlyPointsIndexed = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOnlyPointIndexed() {
            this.onlyPointsIndexed = true;
            return this;
        }
    }
}

