/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.base.Predicate;
import org.apache.sedona.shaded.guava.collect.Lists;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2ContainsVertexQuery;
import org.apache.sedona.shaded.s2.S2CrossingEdgesQuery;
import org.apache.sedona.shaded.s2.S2Edge;
import org.apache.sedona.shaded.s2.S2EdgeUtil;
import org.apache.sedona.shaded.s2.S2Error;
import org.apache.sedona.shaded.s2.S2Iterator;
import org.apache.sedona.shaded.s2.S2Loop;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Polygon;
import org.apache.sedona.shaded.s2.S2RobustCrossProd;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.S2ShapeIndex;
import org.jspecify.annotations.Nullable;

public class S2ShapeUtil {
    private static final Comparator<S2Edge> EDGE_ORDER = (e1, e2) -> {
        int result = e1.getStart().compareTo(e2.getStart());
        if (result != 0) {
            return result;
        }
        return e1.getEnd().compareTo(e2.getEnd());
    };

    private S2ShapeUtil() {
    }

    public static boolean hasInterior(S2ShapeIndex index) {
        int s2 = index.getShapes().size();
        while (--s2 >= 0) {
            S2Shape shape = index.getShapes().get(s2);
            if (shape.dimension() != 2) continue;
            return true;
        }
        return false;
    }

    public static boolean isDegenerateSingleEdge(S2Shape shape) {
        return shape.numEdges() == 1 && shape.getChainVertex(0, 0).equalsPoint(shape.getChainVertex(0, 1));
    }

    static boolean findSelfIntersection(S2ShapeIndex index, S2Loop loop, S2Error error) {
        Preconditions.checkArgument(index.shapes.size() == 1);
        S2Iterator.ListIterator<S2ShapeIndex.Cell> it = index.iterator();
        while (!it.done()) {
            if (S2ShapeUtil.findSelfIntersection(((S2ShapeIndex.Cell)it.entry()).clipped(0), loop, error)) {
                return true;
            }
            it.next();
        }
        return false;
    }

    public static boolean findSelfIntersection(S2ShapeIndex index, S2Error error) {
        if (index.shapes.size() == 0) {
            return false;
        }
        assert (index.shapes.size() == 1);
        S2CrossingEdgesQuery query = new S2CrossingEdgesQuery(S2CrossingEdgesQuery.CrossingType.ALL, false);
        S2Shape shape = index.shapes.get(0);
        return !query.visitCrossingEdgePairs(index, (aShapeId, aEdgeId, aSrc, aDst, bShapeId, bEdgeId, bSrc, bDst, isInterior) -> !S2ShapeUtil.findCrossingError(shape, aEdgeId, aSrc, aDst, bEdgeId, bSrc, bDst, isInterior, error));
    }

    private static void initLoopError(S2Error.Code code, String format, S2Shape.ChainPosition ap, S2Shape.ChainPosition bp, boolean isPolygon, S2Error error) {
        error.init(code, format, ap.offset, bp.offset);
        if (isPolygon) {
            error.init(code, "Loop %d: %s", ap.chainId, error.text());
        }
    }

    private static boolean findCrossingError(S2Shape shape, int aEdgeId, S2Point aSrc, S2Point aDst, int bEdgeId, S2Point bSrc, S2Point bDst, boolean isInterior, S2Error error) {
        S2Shape.ChainPosition ap = new S2Shape.ChainPosition();
        S2Shape.ChainPosition bp = new S2Shape.ChainPosition();
        S2Shape.MutableEdge aEdge = new S2Shape.MutableEdge();
        S2Shape.MutableEdge bEdge = new S2Shape.MutableEdge();
        boolean isPolygon = shape.numChains() > 1;
        shape.getChainPosition(aEdgeId, ap);
        shape.getChainPosition(bEdgeId, bp);
        if (isInterior) {
            if (ap.chainId != bp.chainId) {
                error.init(S2Error.Code.POLYGON_LOOPS_CROSS, "Loop %d edge %d crosses loop %d edge %d", ap.chainId, ap.offset, bp.chainId, bp.offset);
            } else {
                S2ShapeUtil.initLoopError(S2Error.Code.LOOP_SELF_INTERSECTION, "Edge %d crosses edge %d", ap, bp, isPolygon, error);
            }
            return true;
        }
        if (!aDst.equalsPoint(bDst)) {
            return false;
        }
        if (ap.chainId == bp.chainId) {
            S2ShapeUtil.initLoopError(S2Error.Code.DUPLICATE_VERTICES, "Edge %d has duplicate vertex with edge %d", ap, bp, isPolygon, error);
            return true;
        }
        int aLen = shape.getChainLength(ap.chainId);
        int bLen = shape.getChainLength(bp.chainId);
        int aNext = ap.offset + 1 == aLen ? 0 : ap.offset + 1;
        int bNext = bp.offset + 1 == bLen ? 0 : bp.offset + 1;
        shape.getChainEdge(ap.chainId, aNext, aEdge);
        shape.getChainEdge(bp.chainId, bNext, bEdge);
        S2Point a2 = aEdge.b;
        S2Point b2 = bEdge.b;
        if (aSrc.equalsPoint(bSrc) || aSrc.equalsPoint(b2)) {
            error.init(S2Error.Code.POLYGON_LOOPS_SHARE_EDGE, "Loop %d edge %d has duplicate near loop %d edge %d", ap.chainId, ap.offset, bp.chainId, bp.offset);
            return true;
        }
        if (S2EdgeUtil.getWedgeRelation(aSrc, aDst, a2, bSrc, b2) == S2EdgeUtil.WedgeRelation.WEDGE_PROPERLY_OVERLAPS && S2EdgeUtil.getWedgeRelation(aSrc, aDst, a2, b2, bSrc) == S2EdgeUtil.WedgeRelation.WEDGE_PROPERLY_OVERLAPS) {
            error.init(S2Error.Code.POLYGON_LOOPS_CROSS, "Loop %d edge %d crosses loop %d edge %d", ap.chainId, ap.offset, bp.chainId, bp.offset);
            return true;
        }
        return false;
    }

    static boolean findAnyCrossing(S2ShapeIndex index, List<S2Loop> loops, S2Error error) {
        S2Iterator.ListIterator<S2ShapeIndex.Cell> it = index.iterator();
        while (!it.done()) {
            if (S2ShapeUtil.findSelfIntersection(loops, (S2ShapeIndex.Cell)it.entry(), error)) {
                return true;
            }
            if (((S2ShapeIndex.Cell)it.entry()).numShapes() >= 2 && S2ShapeUtil.findLoopCrossing(loops, (S2ShapeIndex.Cell)it.entry(), error)) {
                return true;
            }
            it.next();
        }
        return false;
    }

    static boolean findSelfIntersection(S2ShapeIndex.S2ClippedShape aClipped, S2Loop aLoop, S2Error error) {
        int aNumClipped = aClipped.numEdges();
        for (int i = 0; i < aNumClipped - 1; ++i) {
            int aj;
            int ai = aClipped.edge(i);
            int j = i + 1;
            if (aClipped.edge(j) == ai + 1 && ++j >= aNumClipped) continue;
            S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(aLoop.vertex(ai), aLoop.vertex(ai + 1));
            int ajPrev = -2;
            while (j < aNumClipped && (aj = aClipped.edge(j)) - ai != aLoop.numVertices() - 1) {
                if (aj != ajPrev + 1) {
                    crosser.restartAt(aLoop.vertex(aj));
                }
                ajPrev = aj;
                int crossing = crosser.robustCrossing(aLoop.vertex(aj + 1));
                if (crossing >= 0) {
                    if (crossing == 0) {
                        error.init(S2Error.Code.DUPLICATE_VERTICES, "Edge %d has duplicate vertex with edge %d", ai, aj);
                    } else {
                        error.init(S2Error.Code.LOOP_SELF_INTERSECTION, "Edge %d crosses edge %d", ai, aj);
                    }
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    static int indexOf(List<? extends S2Shape> shapes, S2Shape shape) {
        for (int i = 0; i < shapes.size(); ++i) {
            if (shapes.get(i) != shape) continue;
            return i;
        }
        return -1;
    }

    public static int lowerBound(int low, int high, IntPredicate targetIsGreater) {
        while (low < high) {
            int middle = low + (high - low) / 2;
            if (targetIsGreater.test(middle)) {
                low = middle + 1;
                continue;
            }
            high = middle;
        }
        return low;
    }

    public static int upperBound(int low, int high, IntPredicate targetIsSmaller) {
        while (low < high) {
            int middle = low + (high - low) / 2;
            if (targetIsSmaller.test(middle)) {
                high = middle;
                continue;
            }
            low = middle + 1;
        }
        return low;
    }

    static boolean findSelfIntersection(List<S2Loop> loops, S2ShapeIndex.Cell cell, S2Error error) {
        for (int a = 0; a < cell.numShapes(); ++a) {
            S2Loop loop;
            S2ShapeIndex.S2ClippedShape aClipped = cell.clipped(a);
            if (!S2ShapeUtil.findSelfIntersection(aClipped, loop = loops.get(aClipped.shapeId()), error)) continue;
            error.init(error.code(), "Loop %d: %s", aClipped.shapeId(), error.text());
            return true;
        }
        return false;
    }

    static boolean getCrossingError(List<S2Loop> loops, S2Loop aLoop, int ai, S2Loop bLoop, int bj, int crossing, S2Error error) {
        if (crossing > 0) {
            error.init(S2Error.Code.POLYGON_LOOPS_CROSS, "Loop %d edge %d crosses loop %d edge %d", S2ShapeUtil.indexOf(loops, aLoop), ai, S2ShapeUtil.indexOf(loops, bLoop), bj);
            return true;
        }
        if (aLoop.vertex(ai + 1).equalsPoint(bLoop.vertex(bj + 1))) {
            if (aLoop.vertex(ai).equalsPoint(bLoop.vertex(bj)) || aLoop.vertex(ai).equalsPoint(bLoop.vertex(bj + 2))) {
                error.init(S2Error.Code.POLYGON_LOOPS_SHARE_EDGE, "Loop %d edge %d has duplicate near loop %d edge %d: (%s)-(%s)", S2ShapeUtil.indexOf(loops, aLoop), ai, S2ShapeUtil.indexOf(loops, bLoop), bj, aLoop.vertex(ai).toDegreesString(), aLoop.vertex(ai + 1).toDegreesString());
                return true;
            }
            if (S2EdgeUtil.getWedgeRelation(aLoop.vertex(ai), aLoop.vertex(ai + 1), aLoop.vertex(ai + 2), bLoop.vertex(bj), bLoop.vertex(bj + 2)) == S2EdgeUtil.WedgeRelation.WEDGE_PROPERLY_OVERLAPS) {
                error.init(S2Error.Code.POLYGON_LOOPS_CROSS, "Loop %d edge %d crosses loop %d edge %d", S2ShapeUtil.indexOf(loops, aLoop), ai, S2ShapeUtil.indexOf(loops, bLoop), bj);
                return true;
            }
        }
        return false;
    }

    static boolean findLoopCrossing(List<S2Loop> loops, S2ShapeIndex.Cell cell, S2Error error) {
        for (int a = 0; a < cell.numShapes() - 1; ++a) {
            S2ShapeIndex.S2ClippedShape aClipped = cell.clipped(a);
            S2Loop aLoop = loops.get(aClipped.shapeId());
            int aNumClipped = aClipped.numEdges();
            for (int i = 0; i < aNumClipped; ++i) {
                int ai = aClipped.edge(i);
                S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(aLoop.vertex(ai), aLoop.vertex(ai + 1));
                for (int b = a + 1; b < cell.numShapes(); ++b) {
                    S2ShapeIndex.S2ClippedShape bClipped = cell.clipped(b);
                    S2Loop bLoop = loops.get(bClipped.shapeId());
                    int bjPrev = -2;
                    int bNumClipped = bClipped.numEdges();
                    for (int j = 0; j < bNumClipped; ++j) {
                        int bj = bClipped.edge(j);
                        if (bj != bjPrev + 1) {
                            crosser.restartAt(bLoop.vertex(bj));
                        }
                        bjPrev = bj;
                        int crossing = crosser.robustCrossing(bLoop.vertex(bj + 1));
                        if (crossing < 0 || !S2ShapeUtil.getCrossingError(loops, aLoop, ai, bLoop, bj, crossing, error)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean equals(S2Shape a, S2Shape b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return a == null;
        }
        if (a.hasInterior() != b.hasInterior()) {
            return false;
        }
        if (a.hasInterior() && a.containsOrigin() != b.containsOrigin()) {
            return false;
        }
        if (a.dimension() != b.dimension()) {
            return false;
        }
        if (a.numChains() != b.numChains()) {
            return false;
        }
        for (int i = 0; i < a.numChains(); ++i) {
            if (a.getChainStart(i) != b.getChainStart(i)) {
                return false;
            }
            if (a.getChainLength(i) == b.getChainLength(i)) continue;
            return false;
        }
        if (a.numEdges() != b.numEdges()) {
            return false;
        }
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        for (int i = 0; i < a.numEdges(); ++i) {
            a.getEdge(i, edge);
            S2Point p = edge.a;
            S2Point q = edge.b;
            b.getEdge(i, edge);
            if (p.equalsPoint(edge.a) && q.equalsPoint(edge.b)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(List<S2Shape> a, List<S2Shape> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (S2ShapeUtil.equals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(S2ShapeIndex.S2ClippedShape a, S2ShapeIndex.S2ClippedShape b) {
        if (a.containsCenter() != b.containsCenter()) {
            return false;
        }
        if (a.numEdges() != b.numEdges()) {
            return false;
        }
        for (int i = 0; i < a.numEdges(); ++i) {
            if (a.edge(i) == b.edge(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(S2ShapeIndex.Cell a, S2ShapeIndex.Cell b) {
        if (a.id() != b.id()) {
            return false;
        }
        if (a.numShapes() != b.numShapes()) {
            return false;
        }
        for (int i = 0; i < a.numShapes(); ++i) {
            if (S2ShapeUtil.equals(a.clipped(i), b.clipped(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(S2ShapeIndex a, S2ShapeIndex b) {
        if (!S2ShapeUtil.equals(a.getShapes(), b.getShapes())) {
            return false;
        }
        S2Iterator.ListIterator<S2ShapeIndex.Cell> aIt = a.iterator();
        S2Iterator.ListIterator<S2ShapeIndex.Cell> bIt = b.iterator();
        while (!aIt.done()) {
            if (bIt.done()) {
                return false;
            }
            if (!S2ShapeUtil.equals((S2ShapeIndex.Cell)aIt.entry(), (S2ShapeIndex.Cell)bIt.entry())) {
                return false;
            }
            for (int i = 0; i < ((S2ShapeIndex.Cell)aIt.entry()).numShapes(); ++i) {
                if (((S2ShapeIndex.Cell)aIt.entry()).clipped(i).shapeId() == ((S2ShapeIndex.Cell)bIt.entry()).clipped(i).shapeId()) continue;
                return false;
            }
            aIt.next();
            bIt.next();
        }
        return bIt.done();
    }

    public static boolean containsBruteForce(S2Shape shape, S2Point point) {
        if (shape.dimension() < 2) {
            return false;
        }
        S2Shape.ReferencePoint refPoint = shape.getReferencePoint();
        if (refPoint.equalsPoint(point)) {
            return refPoint.contained();
        }
        S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(refPoint.point(), point);
        boolean inside = refPoint.contained();
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        for (int i = 0; i < shape.numEdges(); ++i) {
            shape.getEdge(i, edge);
            inside ^= crosser.edgeOrVertexCrossing(edge.getStart(), edge.getEnd());
        }
        return inside;
    }

    public static S2Shape.ReferencePoint getReferencePoint(S2Shape shape) {
        int i;
        assert (shape.dimension() == 2);
        if (shape.numEdges() == 0) {
            return S2Shape.ReferencePoint.create(shape.numChains() > 0);
        }
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        shape.getEdge(0, edge);
        Boolean result = S2ShapeUtil.getReferencePointAtVertex(shape, edge.a);
        if (result != null) {
            return S2Shape.ReferencePoint.create(edge.a, result);
        }
        int n = shape.numEdges();
        ArrayList<S2Edge> fwdEdges = new ArrayList<S2Edge>(n);
        ArrayList<S2Edge> revEdges = new ArrayList<S2Edge>(n);
        for (i = 0; i < n; ++i) {
            shape.getEdge(i, edge);
            fwdEdges.add(new S2Edge(edge.a, edge.b));
            revEdges.add(new S2Edge(edge.b, edge.a));
        }
        Collections.sort(fwdEdges, EDGE_ORDER);
        Collections.sort(revEdges, EDGE_ORDER);
        for (i = 0; i < n; ++i) {
            S2Point v;
            S2Edge rev;
            S2Edge fwd = (S2Edge)fwdEdges.get(i);
            int cmp = EDGE_ORDER.compare(fwd, rev = (S2Edge)revEdges.get(i));
            if (cmp < 0) {
                v = fwd.getStart();
            } else {
                if (cmp <= 0) continue;
                v = rev.getStart();
            }
            return S2Shape.ReferencePoint.create(v, S2ShapeUtil.getReferencePointAtVertex(shape, v));
        }
        for (i = 0; i < shape.numChains(); ++i) {
            if (shape.getChainLength(i) != 0) continue;
            return S2Shape.ReferencePoint.create(true);
        }
        return S2Shape.ReferencePoint.create(false);
    }

    private static @Nullable Boolean getReferencePointAtVertex(S2Shape shape, S2Point vtest) {
        S2ContainsVertexQuery query = new S2ContainsVertexQuery(vtest);
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        int n = shape.numEdges();
        for (int e = 0; e < n; ++e) {
            shape.getEdge(e, edge);
            if (vtest.equalsPoint(edge.a)) {
                query.addOutgoing(edge.b);
            }
            if (!vtest.equalsPoint(edge.b)) continue;
            query.addIncoming(edge.a);
        }
        int containsSign = query.containsSign();
        if (containsSign == 0) {
            return null;
        }
        return containsSign > 0;
    }

    public static int numVertices(S2ShapeIndex index) {
        int sum = 0;
        for (S2Shape shape : index.getShapes()) {
            if (shape == null) continue;
            sum += S2ShapeUtil.numVertices(shape);
        }
        return sum;
    }

    public static int numVertices(S2Shape shape) {
        switch (shape.dimension()) {
            case 0: {
                return shape.numChains();
            }
            case 1: {
                return shape.numEdges() + shape.numChains();
            }
            case 2: {
                return shape.numEdges();
            }
        }
        throw new IllegalArgumentException("Invalid dimension: " + shape.dimension());
    }

    public static long countVertices(S2ShapeIndex index) {
        long vertices = 0L;
        block5: for (S2Shape shape : index.getShapes()) {
            switch (shape.dimension()) {
                case 0: {
                    vertices += (long)shape.numChains();
                    continue block5;
                }
                case 1: {
                    vertices += (long)(shape.numEdges() + shape.numChains());
                    continue block5;
                }
                case 2: {
                    vertices += (long)shape.numEdges();
                    continue block5;
                }
            }
            throw new IllegalStateException("Invalid shape dimension " + shape.dimension());
        }
        return vertices;
    }

    public static void visitSurfaceIntegral(List<S2Point> vertices, TriangleConsumer consumer) {
        S2Point v0;
        if (vertices.size() < 3) {
            return;
        }
        double maxLength = 3.141582653589793;
        S2Point origin = v0 = vertices.get(0);
        int numVertices = vertices.size();
        int i = 1;
        while (i + 1 < numVertices) {
            assert (i == 1 || origin.angle(vertices.get(i)) < 3.141582653589793);
            assert (origin.equals(v0) || Math.abs(origin.dotProd(v0)) < 1.0E-15);
            S2Point v1 = vertices.get(i);
            S2Point v2 = vertices.get(i + 1);
            if (v2.angle(origin) > 3.141582653589793) {
                S2Point oldOrigin = origin;
                if (origin.equalsPoint(v0)) {
                    origin = S2RobustCrossProd.robustCrossProd(v0, v1).normalize();
                } else if (v1.angle(v0) < 3.141582653589793) {
                    origin = v0;
                } else {
                    origin = v0.crossProd(oldOrigin);
                    consumer.accept(v0, oldOrigin, origin);
                }
                consumer.accept(oldOrigin, v1, origin);
            }
            consumer.accept(origin, v1, v2);
            ++i;
        }
        if (!origin.equalsPoint(v0)) {
            consumer.accept(origin, vertices.get(numVertices - 1), v0);
        }
    }

    public static int countEdges(S2ShapeIndex index) {
        return S2ShapeUtil.countEdgesUpTo(index, Integer.MAX_VALUE);
    }

    public static int countEdgesUpTo(S2ShapeIndex index, int maxEdges) {
        int numEdges = 0;
        for (S2Shape shape : index.getShapes()) {
            if (shape != null && (numEdges += shape.numEdges()) > maxEdges) break;
        }
        return numEdges;
    }

    public static S2Polygon shapeToS2Polygon(S2Shape poly) {
        Preconditions.checkState(poly.dimension() == 2);
        S2Polygon output = new S2Polygon();
        ArrayList<S2Loop> loops = new ArrayList<S2Loop>(poly.numChains());
        if (poly.isFull()) {
            loops.add(S2Loop.full());
            output.initNested(loops);
            return output;
        }
        for (int i = 0; i < poly.numChains(); ++i) {
            loops.add(new S2Loop(poly.chain(i)));
        }
        if (loops.size() == 1) {
            output.initNested(loops);
        } else {
            output.initOriented(loops);
        }
        return output;
    }

    public static class RangeIterator<T extends S2Iterator.Entry> {
        protected final S2Iterator<T> it;
        protected S2CellId id;
        protected S2CellId rangeMin;
        protected S2CellId rangeMax;

        public RangeIterator(S2Iterator<T> it) {
            this.it = it;
            this.refresh();
        }

        public S2Iterator<T> iterator() {
            return this.it;
        }

        public S2CellId id() {
            return this.id;
        }

        public T entry() {
            return this.it.entry();
        }

        public S2CellId rangeMin() {
            return this.rangeMin;
        }

        public S2CellId rangeMax() {
            return this.rangeMax;
        }

        public void next() {
            this.it.next();
            this.refresh();
        }

        public boolean done() {
            return this.id().equals(S2CellId.sentinel());
        }

        public S2ShapeIndex.CellRelation locate(S2CellId cell) {
            return this.it.locate(cell);
        }

        public void seekTo(RangeIterator<?> target) {
            this.it.seek(target.rangeMin());
            if ((this.it.done() || this.it.id().rangeMin().greaterThan(target.rangeMax())) && this.it.prev() && this.it.id().rangeMax().lessThan(target.id())) {
                this.it.next();
            }
            this.refresh();
        }

        public void seekBeyond(RangeIterator<?> target) {
            this.it.seek(target.rangeMax().next());
            if (!this.it.done() && this.it.id().rangeMin().lessOrEquals(target.rangeMax())) {
                this.it.next();
            }
            this.refresh();
        }

        protected void refresh() {
            this.id = this.it.done() ? S2CellId.sentinel() : this.it.id();
            this.rangeMin = this.id.rangeMin();
            this.rangeMax = this.id.rangeMax();
        }
    }

    public static interface TriangleConsumer {
        public void accept(S2Point var1, S2Point var2, S2Point var3);
    }

    static class LoadedShape {
        private S2ShapeIndex index;
        public final ArrayList<S2Point> srcs = new ArrayList();
        public final ArrayList<S2Point> dsts = new ArrayList();
        public int[] ids = new int[0];
        private final S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        public S2Shape shape;
        public int shapeId;

        LoadedShape() {
        }

        public void init(S2ShapeIndex index) {
            this.index = index;
        }

        public void load(S2ShapeIndex.S2ClippedShape clipped) {
            this.shapeId = clipped.shapeId();
            this.shape = this.index.getShapes().get(this.shapeId);
            this.srcs.clear();
            this.dsts.clear();
            if (this.ids.length < clipped.numEdges()) {
                this.ids = Arrays.copyOf(this.ids, clipped.numEdges());
            }
            for (int i = 0; i < clipped.numEdges(); ++i) {
                int id = clipped.edge(i);
                this.shape.getEdge(id, this.edge);
                this.ids[i] = id;
                this.srcs.add(this.edge.getStart());
                this.dsts.add(this.edge.getEnd());
            }
        }

        public int size() {
            return this.srcs.size();
        }

        public boolean visit(Visitor visitor) {
            for (int i = 0; i < this.srcs.size(); ++i) {
                if (visitor.visit(this.shapeId, this.ids[i], this.srcs.get(i), this.dsts.get(i))) continue;
                return false;
            }
            return true;
        }

        public static interface Visitor {
            public boolean visit(int var1, int var2, S2Point var3, S2Point var4);
        }
    }

    public static interface IntPredicate {
        public boolean test(int var1);
    }

    public static class S2EdgeVectorShape
    extends AbstractList<S2Edge>
    implements S2Shape {
        private final List<S2Edge> edges = Lists.newArrayList();

        public S2EdgeVectorShape() {
        }

        public S2EdgeVectorShape(S2Point a, S2Point b) {
            this.add(a, b);
        }

        public void add(S2Point a, S2Point b) {
            Preconditions.checkArgument(!a.equalsPoint(b));
            this.edges.add(new S2Edge(a, b));
        }

        public void addDegenerate(S2Point a) {
            this.edges.add(new S2Edge(a, a));
        }

        @Override
        public void getEdge(int index, S2Shape.MutableEdge result) {
            S2Edge edge = this.edges.get(index);
            result.set(edge.getStart(), edge.getEnd());
        }

        @Override
        public boolean hasInterior() {
            return false;
        }

        @Override
        public boolean containsOrigin() {
            return false;
        }

        @Override
        public int numEdges() {
            return this.edges.size();
        }

        @Override
        public int numChains() {
            return this.edges.size();
        }

        @Override
        public int getChainStart(int chainId) {
            Preconditions.checkElementIndex(chainId, this.numChains());
            return chainId;
        }

        @Override
        public int getChainLength(int chainId) {
            Preconditions.checkElementIndex(chainId, this.numChains());
            return 1;
        }

        @Override
        public void getChainEdge(int chainId, int offset, S2Shape.MutableEdge result) {
            Preconditions.checkElementIndex(offset, this.getChainLength(chainId));
            this.getEdge(chainId, result);
        }

        @Override
        public void getChainPosition(int edgeId, S2Shape.ChainPosition result) {
            result.set(edgeId, 0);
        }

        @Override
        public S2Point getChainVertex(int chainId, int edgeOffset) {
            Preconditions.checkElementIndex(edgeOffset, 2);
            S2Edge edge = this.edges.get(chainId);
            return edgeOffset == 0 ? edge.getStart() : edge.getEnd();
        }

        @Override
        public int dimension() {
            return 1;
        }

        @Override
        public S2Edge get(int index) {
            return this.edges.get(index);
        }

        @Override
        public int size() {
            return this.edges.size();
        }
    }

    public static interface PointVisitor
    extends Predicate<S2Point> {
    }
}

