/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.EncodedInts;
import org.apache.sedona.shaded.s2.PrimitiveArrays;

@JsType
public interface S2Coder<T>
extends Serializable {
    public static final S2Coder<Long> UNBOXED_VARINT = new S2Coder<Long>(){

        @Override
        public void encode(Long value, OutputStream output) throws IOException {
            EncodedInts.writeVarint64(output, value);
        }

        @Override
        public Long decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
            return data.readVarint64(cursor);
        }
    };
    public static final S2Coder<byte[]> BYTES = new S2Coder<byte[]>(){

        @Override
        public void encode(byte[] bytes, OutputStream output) throws IOException {
            EncodedInts.writeVarint64(output, bytes.length);
            output.write(bytes);
        }

        @Override
        public byte[] decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
            int length = data.readVarint32(cursor);
            Preconditions.checkArgument((long)length <= cursor.remaining(), "Length too long");
            byte[] b = new byte[length];
            for (int i = 0; i < b.length; ++i) {
                b[i] = data.get(cursor.position++);
            }
            return b;
        }

        @Override
        public boolean isLazy() {
            return false;
        }
    };
    public static final S2Coder<String> STRING = BYTES.delegating(value -> value.getBytes(StandardCharsets.UTF_8), b -> new String((byte[])b, StandardCharsets.UTF_8));

    @JsIgnore
    public void encode(T var1, OutputStream var2) throws IOException;

    @JsIgnore
    default public byte[] encode(T value) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        this.encode(value, bytes);
        return bytes.toByteArray();
    }

    default public byte[] unsafeEncode(T value) {
        try {
            return this.encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    default public T unsafeDecode(PrimitiveArrays.Bytes data) {
        try {
            return this.decode(data);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    default public SerializableSupplier<T> memoize(T value) {
        return new MemoizeEncoded<T>(this, value);
    }

    public T decode(PrimitiveArrays.Bytes var1, PrimitiveArrays.Cursor var2) throws IOException;

    @JsIgnore
    default public T decode(PrimitiveArrays.Bytes data) throws IOException {
        return this.decode(data, data.cursor());
    }

    default public boolean isLazy() {
        return true;
    }

    default public <U> S2Coder<U> delegating(final SerializableFunction<U, T> encode, final SerializableFunction<T, U> decode) {
        final S2Coder base = this;
        return new S2Coder<U>(){

            @Override
            @JsIgnore
            public void encode(U value, OutputStream output) throws IOException {
                base.encode(encode.apply(value), output);
            }

            @Override
            public U decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
                return decode.apply(base.decode(data, cursor));
            }

            @Override
            public boolean isLazy() {
                return base.isLazy();
            }
        };
    }

    public static interface SerializableSupplier<T>
    extends Supplier<T>,
    Serializable {
    }

    public static final class MemoizeEncoded<T>
    implements SerializableSupplier<T> {
        private final S2Coder<T> coder;
        private transient T decoded;
        private final byte[] encoded;

        MemoizeEncoded(S2Coder<T> coder, T value) {
            this.coder = coder;
            this.decoded = value;
            this.encoded = coder.unsafeEncode(value);
        }

        @Override
        public T get() {
            if (this.decoded == null) {
                this.decoded = this.coder.unsafeDecode(PrimitiveArrays.Bytes.fromByteArray(this.encoded));
                return this.decoded;
            }
            return this.decoded;
        }
    }

    @JsType
    public static interface SerializableFunction<A, B>
    extends Serializable {
        public B apply(A var1) throws IOException;
    }
}

