/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource$;
import org.apache.spark.sql.sedona_sql.io.geojson.GeoJSONUtils$;
import org.apache.spark.sql.sedona_sql.io.geojson.SparkCompatUtil$;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartition;
import org.apache.spark.sql.sedona_sql.io.stac.StacUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001B\u000f\u001f\u00015B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011!i\u0007A!A!\u0002\u0013q\u0007\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011B?\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!I\u0011Q\u0004\u0001C\u0002\u0013%\u0011q\u0004\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\"!Y\u0011q\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0019\u0011-\t\u0019\u0004\u0001a\u0001\u0002\u0004%I!!\u000e\t\u0015\u0005\u0005\u0003\u00011A\u0001B\u0003&!\u000eC\u0006\u0002D\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0003bCA)\u0001\u0001\u0007\t\u0019!C\u0005\u0003'B1\"a\u0016\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002H!I\u0011\u0011\f\u0001A\u0002\u0013%\u00111\f\u0005\n\u0003[\u0002\u0001\u0019!C\u0005\u0003_B\u0001\"a\u001d\u0001A\u0003&\u0011Q\f\u0005\n\u0003k\u0002!\u0019!C\u0005\u0003oB\u0001\"!%\u0001A\u0003%\u0011\u0011\u0010\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\ti\n\u0001C!\u0003?Cq!!)\u0001\t\u0003\n\u0019\u000bC\u0004\u0002&\u0002!I!a*\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"I\u00111\u001a\u0001\u0012\u0002\u0013\u0005\u0011Q\u001a\u0005\b\u0003G\u0004A\u0011AAs\u0011\u001d\t\t\u0010\u0001C\u0001\u0003g\u00141c\u0015;bGB\u000b'\u000f^5uS>t'+Z1eKJT!a\b\u0011\u0002\tM$\u0018m\u0019\u0006\u0003C\t\n!![8\u000b\u0005\r\"\u0013AC:fI>t\u0017mX:rY*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\f\u001c\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001\u00027b]\u001eT\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026a\t1qJ\u00196fGR\u00042a\u000e\u001f?\u001b\u0005A$BA\u001d;\u0003\u0011\u0011X-\u00193\u000b\u0005m\"\u0013!C2p]:,7\r^8s\u0013\ti\u0004HA\bQCJ$\u0018\u000e^5p]J+\u0017\rZ3s!\ty$)D\u0001A\u0015\t\tE%\u0001\u0005dCR\fG._:u\u0013\t\u0019\u0005IA\u0006J]R,'O\\1m%><\u0018!\u00032s_\u0006$7-Y:u!\r1\u0005JS\u0007\u0002\u000f*\u0011AIJ\u0005\u0003\u0013\u001e\u0013\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0005-sU\"\u0001'\u000b\u000553\u0013\u0001B;uS2L!a\u0014'\u00033M+'/[1mSj\f'\r\\3D_:4\u0017nZ;sCRLwN\\\u0001\na\u0006\u0014H/\u001b;j_:\u0004\"AU*\u000e\u0003yI!\u0001\u0016\u0010\u0003\u001bM#\u0018m\u0019)beRLG/[8o\u0003\u0019\u00198\r[3nCB\u0011qKW\u0007\u00021*\u0011\u0011\fJ\u0001\u0006if\u0004Xm]\u0005\u00037b\u0013!b\u0015;sk\u000e$H+\u001f9f\u0003\u0011y\u0007\u000f^:\u0011\ty;'N\u001b\b\u0003?\u0016\u0004\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u0017\u0002\rq\u0012xn\u001c;?\u0015\u0005!\u0017!B:dC2\f\u0017B\u00014d\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0004\u001b\u0006\u0004(B\u00014d!\tq6.\u0003\u0002mS\n11\u000b\u001e:j]\u001e\fQb\u001d9bi&\fGNR5mi\u0016\u0014\bcA8qe6\t1-\u0003\u0002rG\n1q\n\u001d;j_:\u0004\"a\u001d>\u000e\u0003QT!!\u001e<\u0002\u0015\u001d,w\u000e]1scV,GO\u0003\u0002xq\u0006YA-\u0019;bg>,(oY3t\u0015\tIH%A\u0005fq\u0016\u001cW\u000f^5p]&\u00111\u0010\u001e\u0002\u0018\u000f\u0016|\u0007+\u0019:rk\u0016$8\u000b]1uS\u0006dg)\u001b7uKJ\fa\u0002^3na>\u0014\u0018\r\u001c$jYR,'\u000fE\u0002paz\u00042a`A\u0004\u001b\t\t\tAC\u0002 \u0003\u0007Q1!!\u0002y\u0003)!\u0017\r^1t_V\u00148-Z\u0005\u0005\u0003\u0013\t\tA\u0001\bUK6\u0004xN]1m\r&dG/\u001a:\u0002\rqJg.\u001b;?)9\ty!!\u0005\u0002\u0014\u0005U\u0011qCA\r\u00037\u0001\"A\u0015\u0001\t\u000b\u0011;\u0001\u0019A#\t\u000bA;\u0001\u0019A)\t\u000bU;\u0001\u0019\u0001,\t\u000bq;\u0001\u0019A/\t\u000b5<\u0001\u0019\u00018\t\u000bq<\u0001\u0019A?\u0002\u001b%$X-\\:Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0003E\u0003\u0002$\u0005%\".\u0004\u0002\u0002&)\u0019\u0011qE2\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002,\u0005\u0015\"\u0001C%uKJ\fGo\u001c:\u0002\u001d%$X-\\:Ji\u0016\u0014\u0018\r^8sA\u0005Y1-\u001e:sK:$\u0018\n^3n+\u0005Q\u0017aD2veJ,g\u000e^%uK6|F%Z9\u0015\t\u0005]\u0012Q\b\t\u0004_\u0006e\u0012bAA\u001eG\n!QK\\5u\u0011!\tydCA\u0001\u0002\u0004Q\u0017a\u0001=%c\u0005a1-\u001e:sK:$\u0018\n^3nA\u0005Y1-\u001e:sK:$h)\u001b7f+\t\t9\u0005\u0005\u0003\u0002J\u00055SBAA&\u0015\t\t#'\u0003\u0003\u0002P\u0005-#\u0001\u0002$jY\u0016\fqbY;se\u0016tGOR5mK~#S-\u001d\u000b\u0005\u0003o\t)\u0006C\u0005\u0002@9\t\t\u00111\u0001\u0002H\u0005a1-\u001e:sK:$h)\u001b7fA\u0005ya-Z1ukJ,\u0017\n^3sCR|'/\u0006\u0002\u0002^A)\u0011qLA5}9!\u0011\u0011MA3\u001d\r\u0001\u00171M\u0005\u0002I&\u0019\u0011qM2\u0002\u000fA\f7m[1hK&!\u00111FA6\u0015\r\t9gY\u0001\u0014M\u0016\fG/\u001e:f\u0013R,'/\u0019;pe~#S-\u001d\u000b\u0005\u0003o\t\t\bC\u0005\u0002@E\t\t\u00111\u0001\u0002^\u0005\u0001b-Z1ukJ,\u0017\n^3sCR|'\u000fI\u0001\u0007[\u0006\u0004\b/\u001a:\u0016\u0005\u0005e\u0004\u0003BA>\u0003\u001bk!!! \u000b\t\u0005}\u0014\u0011Q\u0001\tI\u0006$\u0018MY5oI*!\u00111QAC\u0003\u001dQ\u0017mY6t_:TA!a\"\u0002\n\u0006Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0003\u0017\u000b1aY8n\u0013\u0011\ty)! \u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0002\u000f5\f\u0007\u000f]3sA\u0005!a.\u001a=u)\t\t9\nE\u0002p\u00033K1!a'd\u0005\u001d\u0011un\u001c7fC:\f1aZ3u)\u0005q\u0014!B2m_N,GCAA\u001c\u0003Y\u0019\u0007.Z2l\u0003:$G)\u001a7fi\u0016$V-\u001c9GS2,G\u0003BA\u001c\u0003SCq!a+\u0019\u0001\u0004\t9%\u0001\u0003gS2,\u0017!\u00064fi\u000eD7i\u001c8uK:$x+\u001b;i%\u0016$(/\u001f\u000b\u0006U\u0006E\u0016\u0011\u0019\u0005\b\u0003gK\u0002\u0019AA[\u0003\r)(\u000f\u001c\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111\u0018\u001a\u0002\u00079,G/\u0003\u0003\u0002@\u0006e&aA+S\u0019\"I\u00111Y\r\u0011\u0002\u0003\u0007\u0011QY\u0001\u000b[\u0006D(+\u001a;sS\u0016\u001c\bcA8\u0002H&\u0019\u0011\u0011Z2\u0003\u0007%sG/A\u0010gKR\u001c\u0007nQ8oi\u0016tGoV5uQJ+GO]=%I\u00164\u0017-\u001e7uII*\"!a4+\t\u0005\u0015\u0017\u0011[\u0016\u0003\u0003'\u0004B!!6\u0002`6\u0011\u0011q\u001b\u0006\u0005\u00033\fY.A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\\2\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002b\u0006]'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)2M]3bi\u0016\u0004\u0016M\u001d;ji&|g.\u001a3GS2,G\u0003BAt\u0003_\u0004B!!;\u0002l6\ta/C\u0002\u0002nZ\u0014q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\u0005\b\u0003\u0007Z\u0002\u0019AA$\u0003=\u0019'/Z1uKN\u0003\u0018M]6QCRDGc\u0001\u0018\u0002v\"1\u0011q\u001f\u000fA\u0002)\f!\u0002]1uQN#(/\u001b8h\u0001")
public class StacPartitionReader
implements PartitionReader<InternalRow> {
    private final StructType schema;
    private final Map<String, String> opts;
    private final Iterator<String> itemsIterator;
    private String currentItem;
    private File currentFile;
    private Iterator<InternalRow> featureIterator;
    private final ObjectMapper mapper;

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    private Iterator<String> itemsIterator() {
        return this.itemsIterator;
    }

    private String currentItem() {
        return this.currentItem;
    }

    private void currentItem_$eq(String x$1) {
        this.currentItem = x$1;
    }

    private File currentFile() {
        return this.currentFile;
    }

    private void currentFile_$eq(File x$1) {
        this.currentFile = x$1;
    }

    private Iterator<InternalRow> featureIterator() {
        return this.featureIterator;
    }

    private void featureIterator_$eq(Iterator<InternalRow> x$1) {
        this.featureIterator = x$1;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public boolean next() {
        if (this.featureIterator().hasNext()) {
            return true;
        }
        if (this.itemsIterator().hasNext()) {
            Iterator iterator;
            File tempFile;
            this.currentItem_$eq((String)this.itemsIterator().next());
            if (this.currentItem().startsWith("http://") || this.currentItem().startsWith("https://") || this.currentItem().startsWith("file://")) {
                URL url = new URL(this.currentItem());
                tempFile = File.createTempFile("stac_item_", ".json");
                try (PrintWriter writer = new PrintWriter(tempFile);){
                    String nodeType;
                    String fileContent = this.fetchContentWithRetry(url, this.fetchContentWithRetry$default$2());
                    JsonNode rootNode = this.mapper().readTree(fileContent);
                    String string = nodeType = rootNode.get("type").asText();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1377727980: {
                            if (!"FeatureCollection".equals(string)) break;
                            JsonNode features = rootNode.get("features");
                            java.util.Iterator featureIterator = features.elements();
                            while (featureIterator.hasNext()) {
                                JsonNode feature = (JsonNode)featureIterator.next();
                                String content = this.mapper().writeValueAsString((Object)feature);
                                writer.write(content);
                                writer.write("\n");
                            }
                        }
                        case 685445846: {
                            if (!"Feature".equals(string)) break;
                            String content = this.mapper().writeValueAsString((Object)rootNode);
                            writer.write(content);
                        }
                    }
                    throw new IllegalArgumentException(new StringBuilder(27).append("Unsupported type for item: ").append(nodeType).toString());
                }
            } else {
                throw new IllegalArgumentException(new StringBuilder(31).append("Unsupported protocol for item: ").append(this.currentItem()).toString());
            }
            this.checkAndDeleteTempFile(this.currentFile());
            this.currentFile_$eq(tempFile);
            if (this.currentFile().exists()) {
                JSONOptionsInRead parsedOptions = new JSONOptionsInRead(this.opts, (String)this.opts.getOrElse((Object)"sessionLocalTimeZone", (Function0 & Serializable)() -> "UTC"), (String)this.opts.getOrElse((Object)"columnNameOfCorruptRecord", (Function0 & Serializable)() -> "_corrupt_record"));
                JsonDataSource dataSource = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions);
                StructType alteredSchema = GeoJSONUtils$.MODULE$.updateGeometrySchema(this.schema, (DataType)StringType$.MODULE$);
                JacksonParser parser = SparkCompatUtil$.MODULE$.constructJacksonParser((DataType)alteredSchema, (JSONOptions)parsedOptions, true);
                Iterator<InternalRow> rows = SparkCompatUtil$.MODULE$.readFile(dataSource, new Configuration(), this.createPartitionedFile(this.currentFile()), parser, this.schema);
                iterator = rows.map((Function1 & Serializable)row -> {
                    InternalRow geometryConvertedRow = GeoJSONUtils$.MODULE$.convertGeoJsonToGeometry((InternalRow)row, alteredSchema);
                    InternalRow propertiesPromotedRow = StacUtils$.MODULE$.promotePropertiesToTop(geometryConvertedRow, alteredSchema);
                    return propertiesPromotedRow;
                });
            } else {
                iterator = package$.MODULE$.Iterator().empty();
            }
            this.featureIterator_$eq((Iterator<InternalRow>)iterator);
            return this.next();
        }
        return false;
    }

    public InternalRow get() {
        return (InternalRow)this.featureIterator().next();
    }

    public void close() {
        this.checkAndDeleteTempFile(this.currentFile());
    }

    private void checkAndDeleteTempFile(File file) {
        if (file != null && file.exists() && file.getAbsolutePath().startsWith(System.getProperty("java.io.tmpdir"))) {
            file.delete();
            return;
        }
    }

    public String fetchContentWithRetry(URL url, int maxRetries) {
        int attempt = 0;
        boolean success = false;
        String fileContent = "";
        while (attempt < maxRetries && !success) {
            try {
                fileContent = Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                success = true;
            }
            catch (Exception e) {
                if (++attempt < maxRetries) continue;
                throw new RuntimeException(new StringBuilder(48).append("Failed to fetch content from URL after ").append(maxRetries).append(" attempts").toString(), e);
            }
        }
        return fileContent;
    }

    public int fetchContentWithRetry$default$2() {
        return 3;
    }

    public PartitionedFile createPartitionedFile(File currentFile) {
        Object[] objectArray;
        Class<?> partitionedFileClass = Class.forName("org.apache.spark.sql.execution.datasources.PartitionedFile");
        Constructor[] constructors = partitionedFileClass.getConstructors();
        Constructor constructor = (Constructor)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])constructors), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StacPartitionReader.$anonfun$createPartitionedFile$1(x$3))).getOrElse((Function0 & Serializable)() -> (Constructor)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])constructors), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StacPartitionReader.$anonfun$createPartitionedFile$3(x$4))).getOrElse((Function0 & Serializable)() -> {
            throw new NoSuchMethodException("No constructor with 7 or 8 parameters found");
        }));
        if (constructor.getParameterCount() == 7) {
            Class<?> secondParamType = constructor.getParameterTypes()[1];
            String string = secondParamType.getName();
            String string2 = "org.apache.spark.paths.SparkPath";
            objectArray = !(string != null ? !string.equals(string2) : string2 != null) ? new Object[]{null, this.createSparkPath(currentFile.getPath()), 0L, currentFile.length(), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L} : new Object[]{null, currentFile.getPath(), 0L, currentFile.length(), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L};
        } else {
            objectArray = new Object[]{null, this.createSparkPath(currentFile.getPath()), 0L, currentFile.length(), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L, null};
        }
        Object[] params = objectArray;
        return (PartitionedFile)constructor.newInstance(params);
    }

    public Object createSparkPath(String pathString) {
        Class<?> sparkPathClass = Class.forName("org.apache.spark.paths.SparkPath");
        Constructor<?> constructor = sparkPathClass.getDeclaredConstructor(String.class);
        constructor.setAccessible(true);
        return constructor.newInstance(pathString);
    }

    public static final /* synthetic */ boolean $anonfun$createPartitionedFile$1(Constructor x$3) {
        return x$3.getParameterCount() == 7;
    }

    public static final /* synthetic */ boolean $anonfun$createPartitionedFile$3(Constructor x$4) {
        return x$4.getParameterCount() == 8;
    }

    public StacPartitionReader(Broadcast<SerializableConfiguration> broadcast, StacPartition partition, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        this.schema = schema;
        this.opts = opts;
        this.itemsIterator = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])partition.items()));
        this.featureIterator = package$.MODULE$.Iterator().empty();
        this.mapper = new ObjectMapper();
    }
}

