/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterFactory;
import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.common.raster.MapAlgebra;
import org.apache.sedona.common.raster.RasterAccessors;
import org.apache.sedona.common.raster.RasterBandEditors;
import org.apache.sedona.common.utils.RasterInterpolate;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.Operations;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.locationtech.jts.index.strtree.STRtree;

public class RasterEditors {
    public static GridCoverage2D setPixelType(GridCoverage2D raster, String dataType) {
        int newDataType = RasterUtils.getDataTypeCode(dataType);
        RenderedImage originalImage = raster.getRenderedImage();
        Raster originalData = RasterUtils.getRaster(originalImage);
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        int numBands = originalImage.getSampleModel().getNumBands();
        WritableRaster modifiedRaster = RasterFactory.createBandedRaster((int)newDataType, (int)width, (int)height, (int)numBands, null);
        GridSampleDimension[] sampleDimensions = raster.getSampleDimensions();
        for (int band = 0; band < numBands; ++band) {
            double[] samples = originalData.getSamples(0, 0, width, height, band, (double[])null);
            modifiedRaster.setSamples(0, 0, width, height, band, samples);
            if (Double.isNaN(RasterUtils.getNoDataValue(sampleDimensions[band]))) continue;
            sampleDimensions[band] = RasterUtils.createSampleDimensionWithNoDataValue(sampleDimensions[band], RasterEditors.castRasterDataType(RasterUtils.getNoDataValue(sampleDimensions[band]), newDataType));
        }
        return RasterUtils.clone(modifiedRaster, raster.getGridGeometry(), sampleDimensions, raster, null, true);
    }

    public static GridCoverage2D setSrid(GridCoverage2D raster, int srid) {
        Object crs = srid == 0 ? DefaultEngineeringCRS.GENERIC_2D : FunctionsGeoTools.sridToCRS(srid);
        GridCoverageFactory gridCoverageFactory = CoverageFactoryFinder.getGridCoverageFactory(null);
        MathTransform2D transform = raster.getGridGeometry().getGridToCRS2D();
        Map properties = raster.getProperties();
        GridCoverage[] sources = raster.getSources().toArray(new GridCoverage[0]);
        return gridCoverageFactory.create((CharSequence)raster.getName().toString(), raster.getRenderedImage(), (CoordinateReferenceSystem)crs, (MathTransform)transform, raster.getSampleDimensions(), sources, properties);
    }

    public static GridCoverage2D setGeoReference(GridCoverage2D raster, String geoRefCoords, String format) {
        AffineTransform2D affine;
        String[] coords = geoRefCoords.split(" ");
        if (coords.length != 6) {
            return null;
        }
        double scaleX = Double.parseDouble(coords[0]);
        double skewY = Double.parseDouble(coords[1]);
        double skewX = Double.parseDouble(coords[2]);
        double scaleY = Double.parseDouble(coords[3]);
        double upperLeftX = Double.parseDouble(coords[4]);
        double upperLeftY = Double.parseDouble(coords[5]);
        if (format.equalsIgnoreCase("GDAL")) {
            affine = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        } else if (format.equalsIgnoreCase("ESRI")) {
            affine = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX -= scaleX * 0.5, upperLeftY -= scaleY * 0.5);
        } else {
            throw new IllegalArgumentException("Please select between the following formats GDAL and ESRI");
        }
        int height = RasterAccessors.getHeight(raster);
        int width = RasterAccessors.getWidth(raster);
        GridGeometry2D gridGeometry2D = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, width, height), PixelOrientation.UPPER_LEFT, (MathTransform)affine, raster.getCoordinateReferenceSystem(), null);
        return RasterUtils.clone(raster.getRenderedImage(), gridGeometry2D, raster.getSampleDimensions(), raster, null, true);
    }

    public static GridCoverage2D setGeoReference(GridCoverage2D raster, String geoRefCoords) {
        return RasterEditors.setGeoReference(raster, geoRefCoords, "GDAL");
    }

    public static GridCoverage2D setGeoReference(GridCoverage2D raster, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY) {
        String geoRedCoord = String.format("%f %f %f %f %f %f", scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        return RasterEditors.setGeoReference(raster, geoRedCoord, "GDAL");
    }

    public static GridCoverage2D resample(GridCoverage2D raster, double widthOrScale, double heightOrScale, double gridX, double gridY, boolean useScale, String algorithm) throws TransformException {
        GridCoverage2D newRaster;
        AffineTransform2D affine = RasterUtils.getGDALAffineTransform(raster);
        int originalWidth = RasterAccessors.getWidth(raster);
        int originalHeight = RasterAccessors.getHeight(raster);
        double upperLeftX = affine.getTranslateX();
        double upperLeftY = affine.getTranslateY();
        double originalSkewX = affine.getShearX();
        double originalSkewY = affine.getShearY();
        double originalScaleX = affine.getScaleX();
        double originalScaleY = affine.getScaleY();
        CoordinateReferenceSystem crs = raster.getCoordinateReferenceSystem2D();
        int newWidth = useScale ? originalWidth : (int)Math.floor(widthOrScale);
        int newHeight = useScale ? originalHeight : (int)Math.floor(heightOrScale);
        double newScaleX = useScale ? widthOrScale : originalScaleX;
        double newScaleY = useScale ? heightOrScale : originalScaleY;
        double newUpperLeftX = upperLeftX;
        double newUpperLeftY = upperLeftY;
        if (RasterEditors.noConfigChange(originalWidth, originalHeight, upperLeftX, upperLeftY, originalScaleX, originalScaleY, newWidth, newHeight, gridX, gridY, newScaleX, newScaleY, useScale)) {
            return raster;
        }
        ReferencedEnvelope envelope2D = raster.getEnvelope2D();
        if (!useScale) {
            newScaleX = Math.abs(envelope2D.getMaxX() - envelope2D.getMinX()) / (double)newWidth;
            newScaleY = Math.signum(originalScaleY) * Math.abs(envelope2D.getMaxY() - envelope2D.getMinY()) / (double)newHeight;
        } else {
            newWidth = (int)Math.ceil(Math.abs(envelope2D.getMaxX() - envelope2D.getMinX()) / Math.abs(newScaleX));
            newHeight = (int)Math.ceil(Math.abs(envelope2D.getMaxY() - envelope2D.getMinY()) / Math.abs(newScaleY));
        }
        if (!RasterEditors.approximateEquals(upperLeftX, gridX) || !RasterEditors.approximateEquals(upperLeftY, gridY)) {
            int[] expectedCellCoordinates;
            GridCoverage2D tempRaster = RasterEditors.setGeoReference(raster, gridX, gridY, newScaleX, newScaleY, originalSkewX, originalSkewY);
            Point2D expectedGeoPoint = RasterUtils.getWorldCornerCoordinates(tempRaster, (expectedCellCoordinates = RasterUtils.getGridCoordinatesFromWorld(tempRaster, upperLeftX, upperLeftY))[0] + 1, expectedCellCoordinates[1] + 1);
            if (!RasterEditors.approximateEquals(expectedGeoPoint.getX(), upperLeftX)) {
                if (!useScale) {
                    newScaleX = Math.abs(envelope2D.getMaxX() - expectedGeoPoint.getX()) / (double)newWidth;
                } else {
                    newWidth = (int)Math.ceil(Math.abs(envelope2D.getMaxX() - expectedGeoPoint.getX()) / Math.abs(newScaleX));
                }
                newUpperLeftX = expectedGeoPoint.getX();
            }
            if (!RasterEditors.approximateEquals(expectedGeoPoint.getY(), upperLeftY)) {
                if (!useScale) {
                    newScaleY = Math.signum(newScaleY) * Math.abs(envelope2D.getMinY() - expectedGeoPoint.getY()) / (double)newHeight;
                } else {
                    newHeight = (int)Math.ceil(Math.abs(envelope2D.getMinY() - expectedGeoPoint.getY()) / Math.abs(newScaleY));
                }
                newUpperLeftY = expectedGeoPoint.getY();
            }
        }
        AffineTransform2D transform = new AffineTransform2D(newScaleX, originalSkewY, originalSkewX, newScaleY, newUpperLeftX, newUpperLeftY);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, newWidth, newHeight), PixelInCell.CELL_CORNER, (MathTransform)transform, crs, null);
        Interpolation resamplingAlgorithm = RasterEditors.createInterpolationAlgorithm(algorithm);
        if (!Objects.isNull(algorithm) && !algorithm.isEmpty() && (algorithm.equalsIgnoreCase("Bilinear") || algorithm.equalsIgnoreCase("Bicubic"))) {
            GridCoverage2D noDataValueMask = RasterUtils.extractNoDataValueMask(raster);
            GridCoverage2D resampledNoDataValueMask = RasterEditors.resample(noDataValueMask, widthOrScale, heightOrScale, gridX, -gridY, useScale, "NearestNeighbor");
            raster = RasterUtils.replaceNoDataValues(raster);
            newRaster = (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)raster, null, (GridGeometry)gridGeometry, resamplingAlgorithm);
            newRaster = RasterUtils.applyRasterMask(newRaster, resampledNoDataValueMask);
        } else {
            newRaster = (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)raster, null, (GridGeometry)gridGeometry, resamplingAlgorithm);
        }
        return newRaster;
    }

    public static GridCoverage2D resample(GridCoverage2D raster, double widthOrScale, double heightOrScale, boolean useScale, String algorithm) throws TransformException {
        return RasterEditors.resample(raster, widthOrScale, heightOrScale, RasterAccessors.getUpperLeftX(raster), RasterAccessors.getUpperLeftY(raster), useScale, algorithm);
    }

    public static GridCoverage2D resample(GridCoverage2D raster, GridCoverage2D referenceRaster, boolean useScale, String algorithm) throws FactoryException, TransformException {
        int destSRID;
        int srcSRID = RasterAccessors.srid(raster);
        if (srcSRID != (destSRID = RasterAccessors.srid(referenceRaster))) {
            throw new IllegalArgumentException("Provided input raster and reference raster have different SRIDs");
        }
        double[] refRasterMetadata = RasterAccessors.metadata(referenceRaster);
        int newWidth = (int)refRasterMetadata[2];
        int newHeight = (int)refRasterMetadata[3];
        double gridX = refRasterMetadata[0];
        double gridY = refRasterMetadata[1];
        double newScaleX = refRasterMetadata[4];
        double newScaleY = refRasterMetadata[5];
        if (useScale) {
            return RasterEditors.resample(raster, newScaleX, newScaleY, gridX, gridY, useScale, algorithm);
        }
        return RasterEditors.resample(raster, newWidth, newHeight, gridX, gridY, useScale, algorithm);
    }

    private static boolean approximateEquals(double a, double b) {
        double tolerance = 1.0E-6;
        return Math.abs(a - b) <= tolerance;
    }

    private static boolean noConfigChange(int oldWidth, int oldHeight, double oldUpperX, double oldUpperY, double originalScaleX, double originalScaleY, int newWidth, int newHeight, double newUpperX, double newUpperY, double newScaleX, double newScaleY, boolean useScale) {
        if (!useScale) {
            return oldWidth == newWidth && oldHeight == newHeight && RasterEditors.approximateEquals(oldUpperX, newUpperX) && RasterEditors.approximateEquals(oldUpperY, newUpperY);
        }
        return RasterEditors.approximateEquals(originalScaleX, newScaleX) && RasterEditors.approximateEquals(originalScaleY, newScaleY) && RasterEditors.approximateEquals(oldUpperX, newUpperX) && RasterEditors.approximateEquals(oldUpperY, newUpperY);
    }

    public static GridCoverage2D normalizeAll(GridCoverage2D rasterGeom) {
        return RasterEditors.normalizeAll(rasterGeom, 0.0, 255.0, true, null, null, null);
    }

    public static GridCoverage2D normalizeAll(GridCoverage2D rasterGeom, double minLim, double maxLim) {
        return RasterEditors.normalizeAll(rasterGeom, minLim, maxLim, true, null, null, null);
    }

    public static GridCoverage2D normalizeAll(GridCoverage2D rasterGeom, double minLim, double maxLim, boolean normalizeAcrossBands) {
        return RasterEditors.normalizeAll(rasterGeom, minLim, maxLim, normalizeAcrossBands, null, null, null);
    }

    public static GridCoverage2D normalizeAll(GridCoverage2D rasterGeom, double minLim, double maxLim, boolean normalizeAcrossBands, Double noDataValue) {
        return RasterEditors.normalizeAll(rasterGeom, minLim, maxLim, normalizeAcrossBands, noDataValue, null, null);
    }

    public static GridCoverage2D normalizeAll(GridCoverage2D rasterGeom, double minLim, double maxLim, Double noDataValue, Double minValue, Double maxValue) {
        return RasterEditors.normalizeAll(rasterGeom, minLim, maxLim, true, noDataValue, minValue, maxValue);
    }

    public static GridCoverage2D normalizeAll(GridCoverage2D rasterGeom, double minLim, double maxLim, boolean normalizeAcrossBands, Double noDataValue, Double minValue, Double maxValue) {
        double bandNoDataValue;
        double[] bandValues;
        int bandIndex;
        double safetyTrigger;
        if (minLim > maxLim) {
            throw new IllegalArgumentException("minLim cannot be greater than maxLim");
        }
        int numBands = rasterGeom.getNumSampleDimensions();
        RenderedImage renderedImage = rasterGeom.getRenderedImage();
        int rasterDataType = renderedImage.getSampleModel().getDataType();
        double globalMin = minValue != null ? minValue : Double.MAX_VALUE;
        double globalMax = maxValue != null ? maxValue : -1.7976931348623157E308;
        double[] minValues = new double[numBands];
        double[] maxValues = new double[numBands];
        Arrays.fill(minValues, Double.MAX_VALUE);
        Arrays.fill(maxValues, -1.7976931348623157E308);
        double d = safetyTrigger = noDataValue == null ? 1.0 : 0.0;
        if (minValue == null || maxValue == null) {
            for (bandIndex = 0; bandIndex < numBands; ++bandIndex) {
                bandValues = MapAlgebra.bandAsArray(rasterGeom, bandIndex + 1);
                bandNoDataValue = RasterUtils.getNoDataValue(rasterGeom.getSampleDimension(bandIndex));
                if (noDataValue == null) {
                    noDataValue = maxLim;
                }
                for (double val : bandValues) {
                    if (val == bandNoDataValue) continue;
                    if (normalizeAcrossBands) {
                        globalMin = Math.min(globalMin, val);
                        globalMax = Math.max(globalMax, val);
                        continue;
                    }
                    minValues[bandIndex] = Math.min(minValues[bandIndex], val);
                    maxValues[bandIndex] = Math.max(maxValues[bandIndex], val);
                }
            }
        } else {
            globalMin = minValue;
            globalMax = maxValue;
        }
        for (bandIndex = 0; bandIndex < numBands; ++bandIndex) {
            double currentMax;
            double currentMin;
            bandValues = MapAlgebra.bandAsArray(rasterGeom, bandIndex + 1);
            bandNoDataValue = RasterUtils.getNoDataValue(rasterGeom.getSampleDimension(bandIndex));
            double d2 = normalizeAcrossBands ? globalMin : (currentMin = minValue != null ? minValue : minValues[bandIndex]);
            double d3 = normalizeAcrossBands ? globalMax : (currentMax = maxValue != null ? maxValue : maxValues[bandIndex]);
            if (Double.compare(currentMax, currentMin) == 0) {
                Arrays.fill(bandValues, minLim);
            } else {
                for (int i = 0; i < bandValues.length; ++i) {
                    if (bandValues[i] != bandNoDataValue) {
                        double normalizedValue = minLim + (bandValues[i] - currentMin) * (maxLim - safetyTrigger - minLim) / (currentMax - currentMin);
                        bandValues[i] = RasterEditors.castRasterDataType(normalizedValue, rasterDataType);
                        continue;
                    }
                    bandValues[i] = noDataValue;
                }
            }
            rasterGeom = MapAlgebra.addBandFromArray(rasterGeom, bandValues, bandIndex + 1);
            rasterGeom = RasterBandEditors.setBandNoDataValue(rasterGeom, bandIndex + 1, noDataValue);
        }
        return rasterGeom;
    }

    public static GridCoverage2D reprojectMatch(GridCoverage2D source, GridCoverage2D target, String interpolationAlgorithm) {
        Interpolation interp = RasterEditors.createInterpolationAlgorithm(interpolationAlgorithm);
        CoordinateReferenceSystem crs = target.getCoordinateReferenceSystem();
        GridGeometry2D gridGeometry = target.getGridGeometry();
        GridCoverage2D result = (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)source, crs, (GridGeometry)gridGeometry, interp);
        return RasterUtils.shiftRasterToZeroOrigin(result, null);
    }

    private static Interpolation createInterpolationAlgorithm(String algorithm) {
        Interpolation interp = Interpolation.getInstance((int)0);
        if (!Objects.isNull(algorithm) && !algorithm.isEmpty()) {
            if (algorithm.equalsIgnoreCase("nearestneighbor")) {
                interp = Interpolation.getInstance((int)0);
            } else if (algorithm.equalsIgnoreCase("bilinear")) {
                interp = Interpolation.getInstance((int)1);
            } else if (algorithm.equalsIgnoreCase("bicubic")) {
                interp = Interpolation.getInstance((int)2);
            }
        }
        return interp;
    }

    private static double castRasterDataType(double value, int dataType) {
        switch (dataType) {
            case 0: {
                double remainder = value % 256.0;
                double v = remainder < 0.0 ? remainder + 256.0 : remainder;
                return (int)v;
            }
            case 2: {
                return (short)value;
            }
            case 3: {
                return (int)value;
            }
            case 1: {
                return (char)value;
            }
            case 4: {
                return (float)value;
            }
        }
        return value;
    }

    public static GridCoverage2D interpolate(GridCoverage2D inputRaster) throws IllegalArgumentException {
        return RasterEditors.interpolate(inputRaster, 2.0, "fixed", null, null, null);
    }

    public static GridCoverage2D interpolate(GridCoverage2D inputRaster, Double power) throws IllegalArgumentException {
        return RasterEditors.interpolate(inputRaster, power, "fixed", null, null, null);
    }

    public static GridCoverage2D interpolate(GridCoverage2D inputRaster, Double power, String mode) throws IllegalArgumentException {
        return RasterEditors.interpolate(inputRaster, power, mode, null, null, null);
    }

    public static GridCoverage2D interpolate(GridCoverage2D inputRaster, Double power, String mode, Double numPointsOrRadius) throws IllegalArgumentException {
        return RasterEditors.interpolate(inputRaster, power, mode, numPointsOrRadius, null, null);
    }

    public static GridCoverage2D interpolate(GridCoverage2D inputRaster, Double power, String mode, Double numPointsOrRadius, Double maxRadiusOrMinPoints) throws IllegalArgumentException {
        return RasterEditors.interpolate(inputRaster, power, mode, numPointsOrRadius, maxRadiusOrMinPoints, null);
    }

    public static GridCoverage2D interpolate(GridCoverage2D inputRaster, Double power, String mode, Double numPointsOrRadius, Double maxRadiusOrMinPoints, Integer band) throws IllegalArgumentException {
        if (!mode.equalsIgnoreCase("variable") && !mode.equalsIgnoreCase("fixed")) {
            throw new IllegalArgumentException("Invalid 'mode': '" + mode + "'. Expected one of: 'Variable', 'Fixed'.");
        }
        Raster rasterData = inputRaster.getRenderedImage().getData();
        WritableRaster raster = rasterData.createCompatibleWritableRaster(RasterAccessors.getWidth(inputRaster), RasterAccessors.getHeight(inputRaster));
        int width = raster.getWidth();
        int height = raster.getHeight();
        int numBands = raster.getNumBands();
        GridSampleDimension[] gridSampleDimensions = inputRaster.getSampleDimensions();
        if (band != null && (band < 1 || band > numBands)) {
            throw new IllegalArgumentException("Band index out of range.");
        }
        for (int bandIndex = 0; bandIndex < numBands; ++bandIndex) {
            if (band == null || bandIndex == band - 1) {
                STRtree strtree = RasterInterpolate.generateSTRtree(inputRaster, bandIndex);
                Double noDataValue = RasterUtils.getNoDataValue(inputRaster.getSampleDimension(bandIndex));
                int countNoDataValues = 0;
                if (strtree.isEmpty() || strtree.size() == width * height) continue;
                if (mode.equalsIgnoreCase("variable") && (double)strtree.size() < numPointsOrRadius) {
                    throw new IllegalArgumentException("Parameter 'numPoints' is larger than no. of valid pixels in band " + bandIndex + ". Please choose an appropriate value");
                }
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        double value = rasterData.getSampleDouble(x, y, bandIndex);
                        if (Double.isNaN(value) || value == noDataValue) {
                            ++countNoDataValues;
                            double interpolatedValue = RasterInterpolate.interpolateIDW(x, y, strtree, width, height, power, mode, numPointsOrRadius, maxRadiusOrMinPoints);
                            double d = interpolatedValue = Double.isNaN(interpolatedValue) ? noDataValue : interpolatedValue;
                            if (interpolatedValue != noDataValue) {
                                --countNoDataValues;
                            }
                            raster.setSample(x, y, bandIndex, interpolatedValue);
                            continue;
                        }
                        raster.setSample(x, y, bandIndex, value);
                    }
                }
                if (countNoDataValues != 0) continue;
                gridSampleDimensions[bandIndex] = RasterUtils.removeNoDataValue(inputRaster.getSampleDimension(bandIndex));
                continue;
            }
            raster.setSamples(0, 0, raster.getWidth(), raster.getHeight(), (int)band, rasterData.getSamples(0, 0, raster.getWidth(), raster.getHeight(), (int)band, (double[])null));
        }
        return RasterUtils.clone(raster, inputRaster.getGridGeometry(), gridSampleDimensions, inputRaster, null, true);
    }
}

