/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sedona.shaded.guava.escape.Escaper;
import org.apache.sedona.shaded.guava.net.UrlEscapers;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;

public class SubsetParams {
    public static final String variables = "var";
    public static final String latlonBB = "latlonBB";
    public static final String projBB = "projBB";
    public static final String horizStride = "horizStride";
    public static final String latlonPoint = "latlonPoint";
    public static final String stations = "stn";
    public static final String time = "time";
    public static final String timeRange = "timeRange";
    public static final String timeStride = "timeStride";
    public static final String timePresent = "timePresent";
    public static final String timeAll = "timeAll";
    public static final String timeWindow = "timeWindow";
    public static final String runtime = "runtime";
    public static final String runtimeLatest = "runtimeLatest";
    public static final String runtimeAll = "runtimeAll";
    public static final String timeOffset = "timeOffset";
    public static final String timeOffsetFirst = "timeOffsetFirst";
    public static final String timeOffsetAll = "timeOffsetAll";
    public static final String timeOffsetIntv = "timeOffsetIntv";
    public static final String vertCoord = "vertCoord";
    public static final String vertIntv = "vertIntv";
    public static final String vertRange = "vertRange";
    public static final String ensCoord = "ensCoord";
    public static final String timeOffsetDate = "timeOffsetDate";
    public static final String timeOffsetUnit = "timeOffsetUnit";
    private final Map<String, Object> req = new HashMap<String, Object>();

    public void encodeForCdmrfDataRequest(Formatter f, String varname) {
        Escaper urlParamEscaper = UrlEscapers.urlFormParameterEscaper();
        f.format("req=data&var=%s", urlParamEscaper.escape(varname));
        block26: for (Map.Entry<String, Object> entry : this.getEntries()) {
            switch (entry.getKey()) {
                case "latlonBB": {
                    LatLonRect llbb = (LatLonRect)entry.getValue();
                    f.format("&north=%s&south=%s&west=%s&east=%s", llbb.getLatMax(), llbb.getLatMin(), llbb.getLonMin(), llbb.getLonMax());
                    break;
                }
                case "projBB": {
                    ProjectionRect projRect = (ProjectionRect)entry.getValue();
                    f.format("&minx=%s&miny=%s&maxx=%s&maxy=%s", projRect.getMinX(), projRect.getMinY(), projRect.getMaxX(), projRect.getMaxY());
                    break;
                }
                case "latlonPoint": {
                    LatLonPoint llPoint = (LatLonPoint)entry.getValue();
                    f.format("&lat=%s&lon=%s", llPoint.getLatitude(), llPoint.getLongitude());
                    break;
                }
                case "stn": {
                    List stns = (List)entry.getValue();
                    int count = 0;
                    for (String stn : stns) {
                        if (count++ == 0) {
                            f.format("&stn=%s", stn);
                            continue;
                        }
                        f.format(",%s", stn);
                    }
                    continue block26;
                }
                case "timeRange": {
                    CalendarDateRange timeRange = (CalendarDateRange)entry.getValue();
                    f.format("&time_start=%s&time_end=%s", timeRange.getStart(), timeRange.getEnd());
                    break;
                }
                case "timePresent": {
                    f.format("&time=present", new Object[0]);
                    break;
                }
                case "timeAll": {
                    f.format("&time=all", new Object[0]);
                    break;
                }
                case "runtimeLatest": {
                    f.format("&runtime=latest", new Object[0]);
                    break;
                }
                case "runtimeAll": {
                    f.format("&runtime=all", new Object[0]);
                    break;
                }
                case "timeOffsetAll": {
                    f.format("&timeOffset=all", new Object[0]);
                    break;
                }
                case "timeOffsetFirst": {
                    f.format("&timeOffset=first", new Object[0]);
                    break;
                }
                default: {
                    f.format("&%s=%s", entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public Set<Map.Entry<String, Object>> getEntries() {
        return this.req.entrySet();
    }

    public Set<String> getKeys() {
        return this.req.keySet();
    }

    public SubsetParams set(String key, Object value) {
        this.req.put(key, value);
        return this;
    }

    public Object get(String key) {
        return this.req.get(key);
    }

    public boolean isTrue(String key) {
        Boolean val = (Boolean)this.req.get(key);
        return val != null && val != false;
    }

    public Double getDouble(String key) {
        Object val = this.req.get(key);
        if (val == null) {
            return null;
        }
        double dval = val instanceof Number ? ((Number)val).doubleValue() : Double.parseDouble((String)val);
        return dval;
    }

    public Integer getInteger(String key) {
        Object val = this.req.get(key);
        if (val == null) {
            return null;
        }
        int dval = val instanceof Number ? ((Number)val).intValue() : Integer.parseInt((String)val);
        return dval;
    }

    public String toString() {
        Formatter f = new Formatter();
        for (Map.Entry<String, Object> entry : this.req.entrySet()) {
            f.format(" %s == ", entry.getKey());
            Object val = entry.getValue();
            if (val instanceof CalendarDate[]) {
                CalendarDate[] cd2 = (CalendarDate[])val;
                f.format("[%s,%s]", cd2[0], cd2[1]);
                continue;
            }
            if (val instanceof double[]) {
                double[] d = (double[])val;
                f.format("[%f,%f]", d[0], d[1]);
                continue;
            }
            f.format("%s,", entry.getValue());
        }
        return f.toString();
    }

    public boolean hasTimeParam() {
        return this.get(timeRange) != null || this.get(time) != null || this.get(timeStride) != null || this.get(timePresent) != null;
    }

    public boolean hasTimeOffsetParam() {
        return this.get(timeOffset) != null || this.get(timeOffsetFirst) != null || this.get(timeOffsetIntv) != null;
    }

    public boolean hasTimeOffsetIntvParam() {
        return this.get(timeOffsetIntv) != null || this.get(timeOffsetFirst) != null;
    }

    public SubsetParams setHorizStride(int stride) {
        this.set(horizStride, stride);
        return this;
    }

    public LatLonRect getLatLonBoundingBox() {
        return (LatLonRect)this.get(latlonBB);
    }

    public SubsetParams setLatLonBoundingBox(LatLonRect llbb) {
        this.set(latlonBB, llbb);
        return this;
    }

    public ProjectionRect getProjectionRect() {
        return (ProjectionRect)this.get(projBB);
    }

    public SubsetParams setProjectionRect(ProjectionRect projRect) {
        this.set(projBB, projRect);
        return this;
    }

    public LatLonPoint getLatLonPoint() {
        return (LatLonPoint)this.get(latlonPoint);
    }

    public SubsetParams setLatLonPoint(LatLonPoint pt) {
        this.set(latlonPoint, pt);
        return this;
    }

    public List<String> getStations() {
        return (List)this.get(stations);
    }

    public SubsetParams setStations(List<String> stns) {
        this.set(stations, stns);
        return this;
    }

    public List<String> getVariables() {
        return (List)this.get(variables);
    }

    public SubsetParams setVariables(List<String> vars) {
        this.set(variables, vars);
        return this;
    }

    public SubsetParams setTime(CalendarDate date) {
        this.set(time, date);
        return this;
    }

    public CalendarDate getTime() {
        return (CalendarDate)this.get(time);
    }

    public SubsetParams setTimePresent() {
        this.set(timePresent, true);
        return this;
    }

    public CalendarDateRange getTimeRange() {
        return (CalendarDateRange)this.get(timeRange);
    }

    public SubsetParams setTimeRange(CalendarDateRange dateRange) {
        this.set(timeRange, dateRange);
        return this;
    }

    public CalendarDate getRunTime() {
        return (CalendarDate)this.get(runtime);
    }

    public SubsetParams setRunTime(CalendarDate date) {
        this.set(runtime, date);
        return this;
    }

    public CalendarPeriod getTimeWindow() {
        return (CalendarPeriod)this.get(timeWindow);
    }

    public double[] getVertRange() {
        return (double[])this.get(vertRange);
    }

    public Double getVertCoord() {
        return (Double)this.get(vertCoord);
    }

    public SubsetParams setVertCoord(double coord) {
        this.set(vertCoord, coord);
        return this;
    }

    public Double getEnsCoord() {
        return (Double)this.get(ensCoord);
    }

    public SubsetParams setEnsCoord(double coord) {
        this.set(ensCoord, coord);
        return this;
    }

    public SubsetParams setVertCoordIntv(double[] vertCoordIntv) {
        this.set(vertIntv, vertCoordIntv);
        return this;
    }

    public double[] getVertCoordIntv() {
        return (double[])this.get(vertIntv);
    }

    public SubsetParams setTimeOffset(double offset) {
        this.set(timeOffset, offset);
        return this;
    }

    public Double getTimeOffset() {
        return (Double)this.get(timeOffset);
    }

    public SubsetParams setTimeOffsetIntv(double[] timeCoordIntv) {
        this.set(timeOffsetIntv, timeCoordIntv);
        return this;
    }

    public double[] getTimeOffsetIntv() {
        return (double[])this.get(timeOffsetIntv);
    }
}

