/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.utils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.enums.JoinBuildSide;
import org.apache.sedona.core.enums.JoinSpartitionDominantSide;
import org.apache.sedona.core.enums.SpatialJoinOptimizationMode;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils;
import org.locationtech.jts.geom.Envelope;

public class SedonaConf
implements Serializable {
    private boolean useIndex;
    private IndexType indexType;
    private JoinSpartitionDominantSide joinSpartitionDominantSide;
    private JoinBuildSide joinBuildSide;
    private long joinApproximateTotalCount;
    private Envelope datasetBoundary;
    private int fallbackPartitionNum;
    private GridType joinGridType;
    private long autoBroadcastJoinThreshold;
    private SpatialJoinOptimizationMode spatialJoinOptimizationMode;
    private boolean includeTieBreakersInKNNJoins = false;
    private Boolean DBSCANIncludeOutliers = true;
    private String libPostalDataDir;
    private Boolean libPostalUseSenzing = false;

    public static SedonaConf fromActiveSession() {
        return new SedonaConf(SparkSession.active().conf());
    }

    public static SedonaConf fromSparkEnv() {
        return new SedonaConf(SparkEnv.get().conf());
    }

    public SedonaConf(final SparkConf sparkConf) {
        this(new ConfGetter(){

            @Override
            public String get(String key, String defaultValue) {
                return sparkConf.get(key, defaultValue);
            }

            @Override
            public String get(String key) {
                return sparkConf.get(key, null);
            }

            @Override
            public boolean contains(String key) {
                return sparkConf.contains(key);
            }
        });
    }

    public SedonaConf(final RuntimeConfig runtimeConfig) {
        this(new ConfGetter(){

            @Override
            public String get(String key, String defaultValue) {
                return runtimeConfig.get(key, defaultValue);
            }

            @Override
            public String get(String key) {
                return runtimeConfig.get(key);
            }

            @Override
            public boolean contains(String key) {
                return runtimeConfig.contains(key);
            }
        });
    }

    private SedonaConf(ConfGetter confGetter) {
        this.useIndex = Boolean.parseBoolean(this.getConfigValue(confGetter, "global.index", "true"));
        this.indexType = IndexType.getIndexType(this.getConfigValue(confGetter, "global.indextype", "rtree"));
        this.joinApproximateTotalCount = Long.parseLong(this.getConfigValue(confGetter, "join.approxcount", "-1"));
        String[] boundaryString = this.getConfigValue(confGetter, "join.boundary", "0,0,0,0").split(",");
        this.datasetBoundary = new Envelope(Double.parseDouble(boundaryString[0]), Double.parseDouble(boundaryString[1]), Double.parseDouble(boundaryString[2]), Double.parseDouble(boundaryString[3]));
        this.joinGridType = GridType.getGridType(this.getConfigValue(confGetter, "join.gridtype", "kdbtree"));
        this.joinBuildSide = JoinBuildSide.getBuildSide(this.getConfigValue(confGetter, "join.indexbuildside", "left"));
        this.joinSpartitionDominantSide = JoinSpartitionDominantSide.getJoinSpartitionDominantSide(this.getConfigValue(confGetter, "join.spatitionside", "left"));
        this.fallbackPartitionNum = Integer.parseInt(this.getConfigValue(confGetter, "join.numpartition", "-1"));
        this.autoBroadcastJoinThreshold = SedonaConf.bytesFromString(this.getConfigValue(confGetter, "join.autoBroadcastJoinThreshold", confGetter.get("spark.sql.autoBroadcastJoinThreshold")));
        this.spatialJoinOptimizationMode = SpatialJoinOptimizationMode.getSpatialJoinOptimizationMode(this.getConfigValue(confGetter, "join.optimizationmode", "nonequi"));
        this.includeTieBreakersInKNNJoins = Boolean.parseBoolean(this.getConfigValue(confGetter, "join.knn.includeTieBreakers", "false"));
        this.DBSCANIncludeOutliers = Boolean.parseBoolean(confGetter.get("spark.sedona.dbscan.includeOutliers", "true"));
        Object libPostalDataDir = confGetter.get("spark.sedona.libpostal.dataDir", Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(Paths.get("libpostal", new String[0])).toString());
        if (!((String)libPostalDataDir).isEmpty() && !((String)libPostalDataDir).endsWith("/")) {
            libPostalDataDir = (String)libPostalDataDir + "/";
        }
        this.libPostalDataDir = libPostalDataDir;
        this.libPostalUseSenzing = Boolean.parseBoolean(confGetter.get("spark.sedona.libpostal.useSenzing", "true"));
    }

    private String getConfigValue(ConfGetter confGetter, String keySuffix, String defaultValue) {
        String sedonaKey = "sedona." + keySuffix;
        String sparkSedonaKey = "spark.sedona." + keySuffix;
        if (confGetter.contains(sedonaKey)) {
            return confGetter.get(sedonaKey, defaultValue);
        }
        return confGetter.get(sparkSedonaKey, defaultValue);
    }

    public boolean getUseIndex() {
        return this.useIndex;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public long getJoinApproximateTotalCount() {
        return this.joinApproximateTotalCount;
    }

    public Envelope getDatasetBoundary() {
        return this.datasetBoundary;
    }

    public JoinBuildSide getJoinBuildSide() {
        return this.joinBuildSide;
    }

    public GridType getJoinGridType() {
        return this.joinGridType;
    }

    public JoinSpartitionDominantSide getJoinSpartitionDominantSide() {
        return this.joinSpartitionDominantSide;
    }

    public int getFallbackPartitionNum() {
        return this.fallbackPartitionNum;
    }

    public long getAutoBroadcastJoinThreshold() {
        return this.autoBroadcastJoinThreshold;
    }

    public boolean isIncludeTieBreakersInKNNJoins() {
        return this.includeTieBreakersInKNNJoins;
    }

    public String toString() {
        try {
            Field[] fields;
            Object sb = "";
            Class<?> objClass = this.getClass();
            sb = (String)sb + "Sedona Configuration:\n";
            for (Field field : fields = objClass.getDeclaredFields()) {
                String name = field.getName();
                Object value = field.get(this);
                sb = (String)sb + name + ": " + value.toString() + "\n";
            }
            return sb;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static long bytesFromString(String str) {
        if (str == null || str.isEmpty()) {
            return 0L;
        }
        if (str.startsWith("-")) {
            return -1L * Utils.byteStringAsBytes((String)str.substring(1));
        }
        return Utils.byteStringAsBytes((String)str);
    }

    public SpatialJoinOptimizationMode getSpatialJoinOptimizationMode() {
        return this.spatialJoinOptimizationMode;
    }

    public Boolean getDBSCANIncludeOutliers() {
        return this.DBSCANIncludeOutliers;
    }

    public String getLibPostalDataDir() {
        return this.libPostalDataDir;
    }

    public Boolean getLibPostalUseSenzing() {
        return this.libPostalUseSenzing;
    }

    private static interface ConfGetter {
        public String get(String var1, String var2);

        public String get(String var1);

        public boolean contains(String var1);
    }
}

