/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.spark;

import java.io.Serializable;
import org.apache.sedona.common.utils.TelemetryCollector;
import org.apache.sedona.core.serde.SedonaKryoRegistrator;
import org.apache.sedona.sql.RasterRegistrator$;
import org.apache.sedona.sql.UDF.Catalog$;
import org.apache.sedona.sql.UDT.UdtRegistrator$;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.sql.ExperimentalMethods;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.SparkStrategy;
import org.apache.spark.sql.sedona_sql.optimization.ExtractPhysicalFunctions$;
import org.apache.spark.sql.sedona_sql.optimization.SpatialFilterPushDownForGeoParquet;
import org.apache.spark.sql.sedona_sql.optimization.SpatialTemporalFilterPushDownForStacScan;
import org.apache.spark.sql.sedona_sql.strategy.join.JoinQueryDetector;
import org.apache.spark.sql.sedona_sql.strategy.physical.function.EvalPhysicalFunctionStrategy;
import scala.Function0;
import scala.Function1;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public final class SedonaContext$ {
    public static SedonaContext$ MODULE$;

    static {
        new SedonaContext$();
    }

    private Seq<SpatialFilterPushDownForGeoParquet> customOptimizationsWithSession(SparkSession sparkSession) {
        return (Seq)new .colon.colon((Object)new SpatialFilterPushDownForGeoParquet(sparkSession), (List)new .colon.colon((Object)new SpatialTemporalFilterPushDownForStacScan(sparkSession), (List)Nil$.MODULE$));
    }

    public SQLContext create(SQLContext sqlContext) {
        this.create(sqlContext.sparkSession());
        return sqlContext;
    }

    public SparkSession create(SparkSession sparkSession) {
        return this.create(sparkSession, "java");
    }

    public SparkSession create(SparkSession sparkSession, String language) {
        TelemetryCollector.send("spark", language);
        if (!sparkSession.experimental().extraStrategies().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SedonaContext$.$anonfun$create$1(x$1)))) {
            ExperimentalMethods experimentalMethods = sparkSession.experimental();
            experimentalMethods.extraStrategies_$eq((Seq)experimentalMethods.extraStrategies().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new JoinQueryDetector(sparkSession), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
        }
        Try sedonaArrowStrategy = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (SparkStrategy)Class.forName("org.apache.spark.sql.udf.SedonaArrowStrategy").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        Try extractSedonaUDFRule = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Rule)Class.forName("org.apache.spark.sql.udf.ExtractSedonaUDFRule").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        if (sedonaArrowStrategy.isSuccess() && extractSedonaUDFRule.isSuccess()) {
            sparkSession.experimental().extraStrategies_$eq((Seq)sparkSession.experimental().extraStrategies().$colon$plus(sedonaArrowStrategy.get(), Seq$.MODULE$.canBuildFrom()));
            sparkSession.experimental().extraOptimizations_$eq((Seq)sparkSession.experimental().extraOptimizations().$colon$plus(extractSedonaUDFRule.get(), Seq$.MODULE$.canBuildFrom()));
        }
        this.customOptimizationsWithSession(sparkSession).foreach((Function1 & Serializable & scala.Serializable)opt -> {
            SedonaContext$.$anonfun$create$4(sparkSession, opt);
            return BoxedUnit.UNIT;
        });
        if (!sparkSession.experimental().extraOptimizations().contains((Object)ExtractPhysicalFunctions$.MODULE$)) {
            ExperimentalMethods experimentalMethods = sparkSession.experimental();
            experimentalMethods.extraOptimizations_$eq((Seq)experimentalMethods.extraOptimizations().$plus$plus((GenTraversableOnce)new .colon.colon((Object)ExtractPhysicalFunctions$.MODULE$, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
        }
        if (!sparkSession.experimental().extraStrategies().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SedonaContext$.$anonfun$create$6(x$2)))) {
            ExperimentalMethods experimentalMethods = sparkSession.experimental();
            experimentalMethods.extraStrategies_$eq((Seq)experimentalMethods.extraStrategies().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new EvalPhysicalFunctionStrategy(sparkSession), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
        }
        this.addGeoParquetToSupportNestedFilterSources(sparkSession);
        RasterRegistrator$.MODULE$.registerAll(sparkSession);
        UdtRegistrator$.MODULE$.registerAll();
        Catalog$.MODULE$.registerAll(sparkSession);
        return sparkSession;
    }

    public SparkSession.Builder builder() {
        return SparkSession$.MODULE$.builder().config("spark.serializer", KryoSerializer.class.getName()).config("spark.kryo.registrator", SedonaKryoRegistrator.class.getName());
    }

    private void addGeoParquetToSupportNestedFilterSources(SparkSession session) {
        block0: {
            String sources = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> session.conf().get("spark.sql.optimizer.nestedPredicatePushdown.supportedFileSources")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            if (sources.contains("geoparquet")) break block0;
            String newSources = sources.isEmpty() ? "geoparquet" : new StringBuilder(11).append(sources).append(",geoparquet").toString();
            session.conf().set("spark.sql.optimizer.nestedPredicatePushdown.supportedFileSources", newSources);
        }
    }

    public static final /* synthetic */ boolean $anonfun$create$1(SparkStrategy x$1) {
        return x$1 instanceof JoinQueryDetector;
    }

    public static final /* synthetic */ boolean $anonfun$create$5(SpatialFilterPushDownForGeoParquet opt$1, Rule x0$1) {
        Rule rule = x0$1;
        boolean bl = rule == opt$1;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$create$4(SparkSession sparkSession$1, SpatialFilterPushDownForGeoParquet opt) {
        block0: {
            if (sparkSession$1.experimental().extraOptimizations().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SedonaContext$.$anonfun$create$5(opt, x0$1)))) break block0;
            ExperimentalMethods experimentalMethods = sparkSession$1.experimental();
            experimentalMethods.extraOptimizations_$eq((Seq)experimentalMethods.extraOptimizations().$plus$plus((GenTraversableOnce)new .colon.colon((Object)opt, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
        }
    }

    public static final /* synthetic */ boolean $anonfun$create$6(SparkStrategy x$2) {
        return x$2 instanceof EvalPhysicalFunctionStrategy;
    }

    private SedonaContext$() {
        MODULE$ = this;
    }
}

