/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.fastutil.floats;

import java.io.Serializable;
import java.util.Objects;
import org.apache.sedona.shaded.fastutil.HashCommon;
import org.apache.sedona.shaded.fastutil.Pair;
import org.apache.sedona.shaded.fastutil.floats.FloatBytePair;

public class FloatByteImmutablePair
implements FloatBytePair,
Serializable {
    private static final long serialVersionUID = 0L;
    protected final float left;
    protected final byte right;

    public FloatByteImmutablePair(float left, byte right) {
        this.left = left;
        this.right = right;
    }

    public static FloatByteImmutablePair of(float left, byte right) {
        return new FloatByteImmutablePair(left, right);
    }

    @Override
    public float leftFloat() {
        return this.left;
    }

    @Override
    public byte rightByte() {
        return this.right;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof FloatBytePair) {
            return this.left == ((FloatBytePair)other).leftFloat() && this.right == ((FloatBytePair)other).rightByte();
        }
        if (other instanceof Pair) {
            return Objects.equals(Float.valueOf(this.left), ((Pair)other).left()) && Objects.equals(this.right, ((Pair)other).right());
        }
        return false;
    }

    public int hashCode() {
        return HashCommon.float2int(this.left) * 19 + this.right;
    }

    public String toString() {
        return "<" + this.leftFloat() + "," + this.rightByte() + ">";
    }
}

