/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.ui;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.twak.camp.ui.Bar;
import org.twak.camp.ui.Marker;
import org.twak.camp.ui.Mould;
import org.twak.utils.Line;

public class NaiveMould
extends Mould {
    List<PMarker> generators = new ArrayList<PMarker>();

    @Override
    public List<Marker> getAnchorsForEditing(Bar b, Point2d relStart, Point2d relEnd, Point2d ... additional) {
        Point2d absStart = relStart;
        Point2d absEnd = relEnd;
        if (additional.length >= 2) {
            absStart = additional[0];
            absEnd = additional[1];
        }
        ArrayList<Marker> out = new ArrayList<Marker>();
        this.add(out, relStart, relEnd, b, true);
        this.add(out, absStart, absEnd, b, false);
        return out;
    }

    private void add(List<Marker> out, Point2d relStart, Point2d relEnd, Bar b, boolean rel) {
        Vector2d delta = new Vector2d(relEnd);
        delta.sub(relStart);
        for (PMarker pm : this.generators) {
            if (pm.rel != rel) continue;
            Vector2d d2 = new Vector2d(delta);
            d2.scale(pm.param);
            d2.add(relStart);
            Marker o = new Marker();
            o.bar = b;
            o.set(d2);
            if (b != null) {
                o.bar = b;
            }
            out.add(o);
            o.generator = pm;
        }
    }

    @Override
    public Object remove(Marker m3) {
        this.generators.remove((PMarker)m3.generator);
        return m3.generator;
    }

    @Override
    public void create(Marker m3, Object generator) {
        if (generator == null) {
            generator = new PMarker(m3);
        } else {
            ((PMarker)generator).set(m3);
        }
        this.generators.add((PMarker)generator);
    }

    @Override
    public void clear() {
        this.generators.clear();
    }

    public static class PMarker {
        double param = 0.5;
        public boolean rel = true;

        public PMarker(double param) {
            this.param = 0.5;
        }

        public PMarker(Marker m3) {
            this.set(m3);
        }

        public void set(Marker m3) {
            Line line = new Line(m3.bar.start, m3.bar.end);
            this.param = line.findPPram(m3);
            m3.set(line.project(m3, true));
            m3.generator = this;
        }

        public void setOffLine(Marker m3) {
            Line line = new Line(m3.bar.start, m3.bar.end);
            this.param = line.findPPram(m3);
            m3.generator = this;
        }
    }
}

