# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# Generated by savvy: do not edit by hand
#
# Note:
#   This wrapper file is named as `000-wrappers.R` so that this file is loaded
#   first, which allows users to override the functions defined here (e.g., a
#   print() method for an enum).

#' @useDynLib sedonadb, .registration = TRUE
#' @keywords internal
NULL

# Check class and extract the external pointer embedded in the environment
.savvy_extract_ptr <- function(e, class) {
  if(is.null(e)) {
    return(NULL)
  }

  if(inherits(e, class)) {
    e$.ptr
  } else {
    msg <- paste0("Expected ", class, ", got ", class(e)[1])
    stop(msg, call. = FALSE)
  }
}

# Prohibit modifying environments

#' @export
`$<-.savvy_sedonadb__sealed` <- function(x, name, value) {
  class <- gsub("__bundle$", "", class(x)[1])
  stop(class, " cannot be modified", call. = FALSE)
}

#' @export
`[[<-.savvy_sedonadb__sealed` <- function(x, i, value) {
  class <- gsub("__bundle$", "", class(x)[1])
  stop(class, " cannot be modified", call. = FALSE)
}


`init_r_runtime_interrupts` <- function(`interrupts_call`, `pkg_env`) {
  invisible(.Call(savvy_init_r_runtime_interrupts__impl, `interrupts_call`, `pkg_env`))
}


`sedonadb_adbc_init_func` <- function() {
  .Call(savvy_sedonadb_adbc_init_func__impl)
}

### wrapper functions for InternalContext

`InternalContext_data_frame_from_array_stream` <- function(self) {
  function(`stream_xptr`, `collect_now`) {
    .savvy_wrap_InternalDataFrame(.Call(savvy_InternalContext_data_frame_from_array_stream__impl, `self`, `stream_xptr`, `collect_now`))
  }
}

`InternalContext_deregister_table` <- function(self) {
  function(`table_ref`) {
    invisible(.Call(savvy_InternalContext_deregister_table__impl, `self`, `table_ref`))
  }
}

`InternalContext_read_parquet` <- function(self) {
  function(`paths`) {
    .savvy_wrap_InternalDataFrame(.Call(savvy_InternalContext_read_parquet__impl, `self`, `paths`))
  }
}

`InternalContext_sql` <- function(self) {
  function(`query`) {
    .savvy_wrap_InternalDataFrame(.Call(savvy_InternalContext_sql__impl, `self`, `query`))
  }
}

`InternalContext_view` <- function(self) {
  function(`table_ref`) {
    .savvy_wrap_InternalDataFrame(.Call(savvy_InternalContext_view__impl, `self`, `table_ref`))
  }
}

`.savvy_wrap_InternalContext` <- function(ptr) {
  e <- new.env(parent = emptyenv())
  e$.ptr <- ptr
  e$`data_frame_from_array_stream` <- `InternalContext_data_frame_from_array_stream`(ptr)
  e$`deregister_table` <- `InternalContext_deregister_table`(ptr)
  e$`read_parquet` <- `InternalContext_read_parquet`(ptr)
  e$`sql` <- `InternalContext_sql`(ptr)
  e$`view` <- `InternalContext_view`(ptr)

  class(e) <- c("InternalContext", "savvy_sedonadb__sealed")
  e
}



`InternalContext` <- new.env(parent = emptyenv())

### associated functions for InternalContext

`InternalContext`$`new` <- function() {
  .savvy_wrap_InternalContext(.Call(savvy_InternalContext_new__impl))
}


class(`InternalContext`) <- c("InternalContext__bundle", "savvy_sedonadb__sealed")

#' @export
`print.InternalContext__bundle` <- function(x, ...) {
  cat('InternalContext\n')
}

### wrapper functions for InternalDataFrame

`InternalDataFrame_collect` <- function(self) {
  function(`out`) {
    .Call(savvy_InternalDataFrame_collect__impl, `self`, `out`)
  }
}

`InternalDataFrame_compute` <- function(self) {
  function(`ctx`) {
    `ctx` <- .savvy_extract_ptr(`ctx`, "InternalContext")
    .savvy_wrap_InternalDataFrame(.Call(savvy_InternalDataFrame_compute__impl, `self`, `ctx`))
  }
}

`InternalDataFrame_count` <- function(self) {
  function() {
    .Call(savvy_InternalDataFrame_count__impl, `self`)
  }
}

`InternalDataFrame_limit` <- function(self) {
  function(`n`) {
    .savvy_wrap_InternalDataFrame(.Call(savvy_InternalDataFrame_limit__impl, `self`, `n`))
  }
}

`InternalDataFrame_primary_geometry_column_index` <- function(self) {
  function() {
    .Call(savvy_InternalDataFrame_primary_geometry_column_index__impl, `self`)
  }
}

`InternalDataFrame_show` <- function(self) {
  function(`ctx`, `width_chars`, `ascii`, `limit` = NULL) {
    `ctx` <- .savvy_extract_ptr(`ctx`, "InternalContext")
    .Call(savvy_InternalDataFrame_show__impl, `self`, `ctx`, `width_chars`, `ascii`, `limit`)
  }
}

`InternalDataFrame_to_arrow_schema` <- function(self) {
  function(`out`) {
    invisible(.Call(savvy_InternalDataFrame_to_arrow_schema__impl, `self`, `out`))
  }
}

`InternalDataFrame_to_arrow_stream` <- function(self) {
  function(`out`) {
    invisible(.Call(savvy_InternalDataFrame_to_arrow_stream__impl, `self`, `out`))
  }
}

`InternalDataFrame_to_view` <- function(self) {
  function(`ctx`, `table_ref`, `overwrite`) {
    `ctx` <- .savvy_extract_ptr(`ctx`, "InternalContext")
    invisible(.Call(savvy_InternalDataFrame_to_view__impl, `self`, `ctx`, `table_ref`, `overwrite`))
  }
}

`.savvy_wrap_InternalDataFrame` <- function(ptr) {
  e <- new.env(parent = emptyenv())
  e$.ptr <- ptr
  e$`collect` <- `InternalDataFrame_collect`(ptr)
  e$`compute` <- `InternalDataFrame_compute`(ptr)
  e$`count` <- `InternalDataFrame_count`(ptr)
  e$`limit` <- `InternalDataFrame_limit`(ptr)
  e$`primary_geometry_column_index` <- `InternalDataFrame_primary_geometry_column_index`(ptr)
  e$`show` <- `InternalDataFrame_show`(ptr)
  e$`to_arrow_schema` <- `InternalDataFrame_to_arrow_schema`(ptr)
  e$`to_arrow_stream` <- `InternalDataFrame_to_arrow_stream`(ptr)
  e$`to_view` <- `InternalDataFrame_to_view`(ptr)

  class(e) <- c("InternalDataFrame", "savvy_sedonadb__sealed")
  e
}



`InternalDataFrame` <- new.env(parent = emptyenv())

### associated functions for InternalDataFrame



class(`InternalDataFrame`) <- c("InternalDataFrame__bundle", "savvy_sedonadb__sealed")

#' @export
`print.InternalDataFrame__bundle` <- function(x, ...) {
  cat('InternalDataFrame\n')
}
