/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SpanExporter;

public final class SimpleSpanProcessorBuilder {
    private final SpanExporter spanExporter;
    private Supplier<MeterProvider> meterProvider = MeterProvider::noop;
    private boolean exportUnsampledSpans = false;

    SimpleSpanProcessorBuilder(SpanExporter spanExporter) {
        this.spanExporter = Objects.requireNonNull(spanExporter, "spanExporter");
    }

    public SimpleSpanProcessorBuilder setExportUnsampledSpans(boolean exportUnsampledSpans) {
        this.exportUnsampledSpans = exportUnsampledSpans;
        return this;
    }

    public SimpleSpanProcessorBuilder setMeterProvider(Supplier<MeterProvider> meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProvider = meterProvider;
        return this;
    }

    public SimpleSpanProcessor build() {
        return new SimpleSpanProcessor(this.spanExporter, this.exportUnsampledSpans, this.meterProvider);
    }
}

